/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import net.i2p.router.web.BanlistRenderer;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.ProfileOrganizerRenderer;

public class ProfilesHelper
extends HelperBase {
    private int _full;
    private boolean _graphical;
    private static final String[] titles = new String[]{ProfilesHelper._x("High Capacity"), ProfilesHelper._x("Floodfill "), ProfilesHelper._x("Banned"), ProfilesHelper._x("All")};
    private static final String[] links = new String[]{"", "?f=2", "?f=3", "?f=1"};

    public void setFull(String f) {
        if (f != null) {
            try {
                this._full = Integer.parseInt(f);
                if (this._full < 0 || this._full > 3) {
                    this._full = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void allowGraphical() {
        this._graphical = true;
    }

    public String getSummary() {
        try {
            this.renderNavBar();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._full == 3) {
            this.getBanlistSummary();
        } else {
            this.getProfileSummary();
        }
        return "";
    }

    public String getProfileSummary() {
        try {
            ProfileOrganizerRenderer rend = new ProfileOrganizerRenderer(this._context.profileOrganizer(), this._context);
            rend.renderStatusHTML(this._out, this._full);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    public String getBanlistSummary() {
        try {
            BanlistRenderer rend = new BanlistRenderer(this._context);
            rend.renderStatusHTML(this._out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private int getTab() {
        if (this._full == 2) {
            return 1;
        }
        if (this._full == 3) {
            return 2;
        }
        if (this._full == 1) {
            return 3;
        }
        return 0;
    }

    private void renderNavBar() throws IOException {
        boolean span;
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<div class=\"confignav\" id=\"confignav\">");
        String theme = this._context.getProperty("routerconsole.theme");
        boolean bl = span = this._graphical && (theme == null || theme.equals("light"));
        if (!span) {
            buf.append("<center>");
        }
        int tab = this.getTab();
        for (int i = 0; i < titles.length; ++i) {
            if (i == tab) {
                if (span) {
                    buf.append("<span class=\"tab2\">");
                }
                buf.append(this._t(titles[i]));
            } else {
                if (span) {
                    buf.append("<span class=\"tab\">");
                }
                buf.append("<a href=\"profiles").append(links[i]).append("\">").append(this._t(titles[i])).append("</a>");
            }
            if (span) {
                buf.append(" </span>\n");
                continue;
            }
            if (i == titles.length - 1) continue;
            buf.append(" |\n");
        }
        if (!span) {
            buf.append("</center>");
        }
        buf.append("</div>");
        this._out.write(buf.toString());
    }
}

