/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.ContentHelper;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NewsFeedHelper;
import net.i2p.update.UpdateType;

public class NewsHelper
extends ContentHelper {
    public static final String PROP_LAST_UPDATE_TIME = "router.updateLastDownloaded";
    private static final String PROP_LAST_HIDDEN = "routerconsole.newsLastHidden";
    public static final String PROP_LAST_CHECKED = "routerconsole.newsLastChecked";
    public static final String PROP_LAST_UPDATED = "routerconsole.newsLastUpdated";
    public static final String PROP_TRANSLATE = "routerconsole.newsTranslate";
    public static final String NEWS_FILE = "docs/news.xml";

    public static boolean isAnyUpdateInProgress() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return false;
        }
        return mgr.isUpdateInProgress();
    }

    public static boolean isUpdateInProgress() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return false;
        }
        return mgr.isUpdateInProgress(UpdateType.ROUTER_SIGNED) || mgr.isUpdateInProgress(UpdateType.ROUTER_SIGNED_SU3) || mgr.isUpdateInProgress(UpdateType.ROUTER_UNSIGNED) || mgr.isUpdateInProgress(UpdateType.ROUTER_DEV_SU3) || mgr.isUpdateInProgress(UpdateType.TYPE_DUMMY);
    }

    public static boolean isUpdateAvailable() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return false;
        }
        return mgr.getUpdateAvailable(UpdateType.ROUTER_SIGNED) != null || mgr.getUpdateAvailable(UpdateType.ROUTER_SIGNED_SU3) != null;
    }

    public static String updateVersion() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        String rv = mgr.getUpdateAvailable(UpdateType.ROUTER_SIGNED_SU3);
        if (rv != null) {
            return rv;
        }
        return mgr.getUpdateAvailable(UpdateType.ROUTER_SIGNED);
    }

    public static String updateConstraint() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        return mgr.getUpdateConstraint(UpdateType.ROUTER_SIGNED, "");
    }

    public static String unsignedUpdateConstraint() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        return mgr.getUpdateConstraint(UpdateType.ROUTER_UNSIGNED, "");
    }

    public static String devSU3UpdateConstraint() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        return mgr.getUpdateConstraint(UpdateType.ROUTER_DEV_SU3, "");
    }

    public static String updateVersionDownloaded() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        String rv = mgr.getUpdateDownloaded(UpdateType.ROUTER_SIGNED_SU3);
        if (rv != null) {
            return rv;
        }
        return mgr.getUpdateDownloaded(UpdateType.ROUTER_SIGNED);
    }

    public static boolean isUnsignedUpdateAvailable(RouterContext ctx) {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return false;
        }
        return mgr.getUpdateAvailable(UpdateType.ROUTER_UNSIGNED) != null && ctx.getBooleanProperty("router.updateUnsigned");
    }

    public static String unsignedUpdateVersion() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        return NewsHelper.formatUnsignedVersion(mgr.getUpdateAvailable(UpdateType.ROUTER_UNSIGNED));
    }

    public static String unsignedVersionDownloaded() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        return NewsHelper.formatUnsignedVersion(mgr.getUpdateDownloaded(UpdateType.ROUTER_UNSIGNED));
    }

    public static boolean isDevSU3UpdateAvailable(RouterContext ctx) {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return false;
        }
        return mgr.getUpdateAvailable(UpdateType.ROUTER_DEV_SU3) != null && ctx.getBooleanProperty("router.updateDevSU3");
    }

    public static String devSU3UpdateVersion() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        return mgr.getUpdateAvailable(UpdateType.ROUTER_DEV_SU3);
    }

    public static String devSU3VersionDownloaded() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return null;
        }
        return mgr.getUpdateDownloaded(UpdateType.ROUTER_DEV_SU3);
    }

    private static String formatUnsignedVersion(String ver) {
        if (ver != null) {
            try {
                long modtime = Long.parseLong(ver);
                return new SimpleDateFormat("dd-MMM HH:mm").format(new Date(modtime)) + " UTC";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getUpdateStatus() {
        ConsoleUpdateManager mgr = ConsoleUpdateManager.getInstance();
        if (mgr == null) {
            return "";
        }
        return mgr.getStatus();
    }

    @Override
    public String getContent() {
        return NewsFeedHelper.getEntries(this._context, 0, 2);
    }

    public boolean shouldShowNews() {
        return NewsHelper.shouldShowNews(this._context);
    }

    public static boolean shouldShowNews(RouterContext ctx) {
        long lastUpdated = NewsHelper.lastUpdated(ctx);
        if (lastUpdated <= 0L) {
            return true;
        }
        long last = ctx.getProperty(PROP_LAST_HIDDEN, 0L);
        return lastUpdated > last;
    }

    public void showNews(boolean yes) {
        NewsHelper.showNews(this._context, yes);
    }

    public static void showNews(RouterContext ctx, boolean yes) {
        long stamp = yes ? 0L : NewsHelper.lastUpdated(ctx);
        ctx.router().saveConfig(PROP_LAST_HIDDEN, Long.toString(stamp));
    }

    public String status() {
        return NewsHelper.status(this._context);
    }

    public static String status(RouterContext ctx) {
        StringBuilder buf = new StringBuilder(128);
        long now = ctx.clock().now();
        buf.append("<i>");
        long lastUpdated = NewsHelper.lastUpdated(ctx);
        long lastFetch = NewsHelper.lastChecked(ctx);
        if (lastUpdated > 0L) {
            buf.append(Messages.getString("News last updated {0} ago.", DataHelper.formatDuration2(now - lastUpdated), ctx)).append('\n');
        }
        if (lastFetch > lastUpdated) {
            buf.append(Messages.getString("News last checked {0} ago.", DataHelper.formatDuration2(now - lastFetch), ctx));
        }
        buf.append("</i>");
        String consoleNonce = CSSHelper.getNonce();
        if (lastUpdated > 0L && consoleNonce != null) {
            if (NewsHelper.shouldShowNews(ctx)) {
                buf.append(" <a href=\"/?news=0&amp;consoleNonce=").append(consoleNonce).append("\">").append(Messages.getString("Hide news", ctx));
            } else {
                buf.append(" <a href=\"/?news=1&amp;consoleNonce=").append(consoleNonce).append("\">").append(Messages.getString("Show news", ctx));
            }
            buf.append("</a> - <a href=\"/news\">").append(Messages.getString("Show all news", ctx)).append("</a>");
        }
        return buf.toString();
    }

    public static boolean dontInstall(RouterContext ctx) {
        return NewsHelper.isUpdateDisabled(ctx) || NewsHelper.isBaseReadonly(ctx);
    }

    public static boolean isUpdateDisabled(RouterContext ctx) {
        return ctx.getBooleanProperty("router.updateDisabled");
    }

    public static boolean isBaseReadonly(RouterContext ctx) {
        File test = new File(ctx.getBaseDir(), "history.txt");
        boolean readonly = test.exists() && !test.canWrite() || !ctx.getBaseDir().canWrite();
        return readonly;
    }

    public static long lastChecked(RouterContext ctx) {
        return ctx.getProperty(PROP_LAST_CHECKED, 0L);
    }

    public static long lastUpdated(RouterContext ctx) {
        long rv = ctx.getProperty(PROP_LAST_UPDATED, 0L);
        if (rv > 0L) {
            return rv;
        }
        File newsFile = new File(ctx.getRouterDir(), NEWS_FILE);
        rv = newsFile.lastModified();
        ctx.router().saveConfig(PROP_LAST_UPDATED, Long.toString(rv));
        return rv;
    }
}

