/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.news;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.router.news.NewsEntry;
import net.i2p.router.news.NewsMetadata;
import net.i2p.router.news.RFC3339Date;
import net.i2p.router.news.XMLParser;
import net.i2p.util.Log;
import org.cybergarage.util.Debug;
import org.cybergarage.xml.Attribute;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.ParserException;

public class NewsXMLParser {
    private final I2PAppContext _context;
    private final Log _log;
    private List<NewsEntry> _entries;
    private NewsMetadata _metadata;
    private XHTMLMode _mode;
    private static final Set<String> xhtmlWhitelist = new HashSet<String>(Arrays.asList("a", "b", "br", "div", "i", "p", "span", "font", "blockquote", "hr", "del", "ins", "em", "strong", "mark", "sub", "sup", "tt", "code", "strike", "s", "u", "h4", "h5", "h6", "ol", "ul", "li", "dl", "dt", "dd", "table", "tr", "td", "th", "#text"));
    private static final Set<String> attributeBlacklist = new HashSet<String>(Arrays.asList("onabort", "onblur", "oncanplay", "oncanplaythrough", "onchange", "onclick", "oncontextmenu", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "oninput", "onivalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onpause", "onplay", "onplaying", "onprogress", "onratechange", "onreadystatechange", "onreset", "onscroll", "onseeked", "onseeking", "onselect", "onshow", "onstalled", "onsubmit", "onsuspend", "ontimeupdate", "onvolumechange", "onwaiting"));

    public NewsXMLParser(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(NewsXMLParser.class);
        this._mode = XHTMLMode.REMOVE_ELEMENT;
    }

    public void setXHTMLMode(XHTMLMode mode) {
        this._mode = mode;
    }

    public Node parse(File file) throws IOException {
        return this.parse(new BufferedInputStream(new FileInputStream(file)));
    }

    public Node parse(InputStream in) throws IOException {
        this._entries = null;
        this._metadata = null;
        XMLParser parser = new XMLParser(this._context);
        try {
            Node root = parser.parse(in);
            this.extract(root);
            return root;
        }
        catch (ParserException pe) {
            throw new I2PParserException(pe);
        }
    }

    public List<NewsEntry> getEntries() {
        return this._entries;
    }

    public NewsMetadata getMetadata() {
        return this._metadata;
    }

    private void extract(Node root) throws I2PParserException {
        if (!root.getName().equals("feed")) {
            throw new I2PParserException("no feed in XML");
        }
        this._metadata = NewsXMLParser.extractNewsMetadata(root);
        this._entries = this.extractNewsEntries(root);
    }

    private static NewsMetadata extractNewsMetadata(Node feed) throws I2PParserException {
        long time;
        String v;
        NewsMetadata rv = new NewsMetadata();
        Node n = feed.getNode("title");
        if (n != null) {
            rv.feedTitle = n.getValue();
            if (rv.feedTitle != null) {
                rv.feedTitle = rv.feedTitle.trim();
            }
        }
        if ((n = feed.getNode("subtitle")) != null) {
            rv.feedSubtitle = n.getValue();
            if (rv.feedSubtitle != null) {
                rv.feedSubtitle = rv.feedTitle.trim();
            }
        }
        if ((n = feed.getNode("id")) != null) {
            rv.feedID = n.getValue();
            if (rv.feedTitle != null) {
                rv.feedTitle = rv.feedTitle.trim();
            }
        }
        if ((n = feed.getNode("updated")) != null && (v = n.getValue()) != null && (time = RFC3339Date.parse3339Date(v.trim())) > 0L) {
            rv.feedUpdated = time;
        }
        ArrayList<NewsMetadata.Release> releases = new ArrayList<NewsMetadata.Release>();
        List<Node> releaseNodes = NewsXMLParser.getNodes(feed, "i2p:release");
        if (releaseNodes.size() == 0) {
            throw new I2PParserException("no release data in XML");
        }
        for (Node r : releaseNodes) {
            long time2;
            NewsMetadata.Release release = new NewsMetadata.Release();
            String a = r.getAttributeValue("date");
            if (a.length() > 0 && (time2 = RFC3339Date.parse3339Date(a.trim())) > 0L) {
                release.date = time2;
            }
            if ((a = r.getAttributeValue("minVersion")).length() > 0) {
                release.minVersion = a.trim();
            }
            if ((a = r.getAttributeValue("minJavaVersion")).length() > 0) {
                release.minJavaVersion = a.trim();
            }
            if ((n = r.getNode("i2p:version")) != null) {
                release.i2pVersion = n.getValue();
                if (release.i2pVersion != null) {
                    release.i2pVersion = release.i2pVersion.trim();
                }
            }
            ArrayList<NewsMetadata.Update> updates = new ArrayList<NewsMetadata.Update>();
            List<Node> updateNodes = NewsXMLParser.getNodes(r, "i2p:update");
            if (updateNodes.size() == 0) {
                throw new I2PParserException("no updates in release");
            }
            HashSet<String> types = new HashSet<String>();
            for (Node u : updateNodes) {
                String href;
                String type = u.getAttributeValue("type");
                if (type.isEmpty()) {
                    throw new I2PParserException("update with no type");
                }
                if (types.contains(type)) {
                    throw new I2PParserException("update with duplicate type");
                }
                NewsMetadata.Update update = new NewsMetadata.Update();
                update.type = type.trim();
                types.add(type);
                int totalSources = 0;
                Node t = u.getNode("i2p:torrent");
                if (t != null && (href = t.getAttributeValue("href")).length() > 0) {
                    update.torrent = href.trim();
                    ++totalSources;
                }
                if (totalSources == 0) {
                    throw new I2PParserException("no sources for update type " + type);
                }
                updates.add(update);
            }
            Collections.sort(updates);
            release.updates = updates;
            releases.add(release);
        }
        Collections.sort(releases);
        rv.releases = releases;
        return rv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<NewsEntry> extractNewsEntries(Node feed) throws I2PParserException {
        ArrayList<NewsEntry> rv = new ArrayList<NewsEntry>();
        List<Node> entries = NewsXMLParser.getNodes(feed, "entry");
        Iterator<Node> i$ = entries.iterator();
        while (true) {
            long time;
            String v;
            String a;
            if (!i$.hasNext()) {
                Collections.sort(rv);
                return rv;
            }
            Node entry = i$.next();
            NewsEntry e = new NewsEntry();
            Node n = entry.getNode("title");
            if (n != null) {
                e.title = n.getValue();
                if (e.title != null) {
                    e.title = e.title.trim();
                }
            }
            if ((n = entry.getNode("link")) != null && (a = n.getAttributeValue("href")).length() > 0) {
                e.link = a.trim();
            }
            if ((n = entry.getNode("id")) != null) {
                e.id = n.getValue();
                if (e.id != null) {
                    e.id = e.id.trim();
                }
            }
            if ((n = entry.getNode("updated")) != null && (v = n.getValue()) != null && (time = RFC3339Date.parse3339Date(v.trim())) > 0L) {
                e.updated = time;
            }
            if ((n = entry.getNode("summary")) != null) {
                e.summary = n.getValue();
                if (e.summary != null) {
                    e.summary = e.summary.trim();
                }
            }
            if ((n = entry.getNode("author")) != null && (n = n.getNode("name")) != null) {
                e.authorName = n.getValue();
                if (e.authorName != null) {
                    e.authorName = e.authorName.trim();
                }
            }
            if ((n = entry.getNode("content")) != null) {
                a = n.getAttributeValue("type");
                if (a.length() > 0) {
                    e.contentType = a;
                }
                StringBuilder buf = new StringBuilder(256);
                block8: for (int i = 0; i < n.getNNodes(); ++i) {
                    Node sn = n.getNode(i);
                    try {
                        boolean removed = this.validate(sn);
                        if (removed) {
                            --i;
                            continue;
                        }
                    }
                    catch (I2PParserException ipe) {
                        switch (this._mode) {
                            case ABORT: {
                                throw ipe;
                            }
                            case SKIP_ENTRY: {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("Skipping entry", ipe);
                                }
                                e = null;
                                break;
                            }
                            case REMOVE_ATTRIBUTE: 
                            case REMOVE_ELEMENT: {
                                if (!this._log.shouldLog(30)) continue block8;
                                this._log.warn("Removing element", ipe);
                                continue block8;
                            }
                        }
                    }
                    if (e == null) break;
                    XMLParser.toString(buf, sn);
                }
                if (e == null) continue;
                e.content = buf.toString();
            }
            rv.add(e);
        }
    }

    public static List<Node> getNodes(Node node, String name) {
        ArrayList<Node> rv = new ArrayList<Node>();
        int count = node.getNNodes();
        for (int i = 0; i < count; ++i) {
            Node n = node.getNode(i);
            if (!n.getName().equals(name)) continue;
            rv.add(n);
        }
        return rv;
    }

    private boolean validate(Node node) throws I2PParserException {
        String name = node.getName();
        if (!xhtmlWhitelist.contains(name.toLowerCase(Locale.US))) {
            switch (this._mode) {
                case ABORT: 
                case SKIP_ENTRY: {
                    throw new I2PParserException("Invalid XHTML element \"" + name + '\"');
                }
                case REMOVE_ATTRIBUTE: 
                case REMOVE_ELEMENT: {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Removing element: " + node);
                    }
                    node.getParentNode().removeNode(node);
                    return true;
                }
                case ALLOW_ALL: {
                    if (!this._log.shouldLog(30)) break;
                    this._log.warn("Allowing non-whitelisted element by configuration: " + node);
                }
            }
        }
        block11: for (int i = 0; i < node.getNAttributes(); ++i) {
            Attribute attr = node.getAttribute(i);
            String aname = attr.getName();
            if (!attributeBlacklist.contains(aname.toLowerCase(Locale.US))) continue;
            switch (this._mode) {
                case ABORT: 
                case SKIP_ENTRY: {
                    throw new I2PParserException("Invalid XHTML element \"" + name + "\" due to attribute " + aname);
                }
                case REMOVE_ELEMENT: {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Removing element: " + node + " due to attribute " + aname);
                    }
                    node.getParentNode().removeNode(node);
                    return true;
                }
                case REMOVE_ATTRIBUTE: {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Removing attribute: " + aname + " from " + node);
                    }
                    if (!node.removeAttribute(attr)) continue block11;
                    --i;
                    continue block11;
                }
                case ALLOW_ALL: {
                    if (!this._log.shouldLog(30)) continue block11;
                    this._log.warn("Allowing blacklisted attribute by configuration: " + node);
                }
            }
        }
        int count = node.getNNodes();
        for (int i = 0; i < node.getNNodes(); ++i) {
            boolean removed = this.validate(node.getNode(i));
            if (!removed) continue;
            --i;
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length <= 0 || args.length > 2) {
            System.err.println("Usage: NewsXMLParser file.xml [parserMode]");
            System.exit(1);
        }
        try {
            I2PAppContext ctx = new I2PAppContext();
            Debug.initialize(ctx);
            NewsXMLParser parser = new NewsXMLParser(ctx);
            if (args.length > 1) {
                XHTMLMode mode = XHTMLMode.valueOf(args[1]);
                parser.setXHTMLMode(mode);
            } else {
                parser.setXHTMLMode(XHTMLMode.ABORT);
            }
            parser.parse(new File(args[0]));
            NewsMetadata ud = parser.getMetadata();
            List<NewsEntry> entries = parser.getEntries();
            NewsMetadata.Release latestRelease = ud.releases.get(0);
            System.out.println("Latest version is " + latestRelease.i2pVersion);
            System.out.println("Release timestamp: " + latestRelease.date);
            System.out.println("Feed timestamp: " + ud.feedUpdated);
            System.out.println("Found " + entries.size() + " news entries");
            HashSet<String> uuids = new HashSet<String>(entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                NewsEntry e = entries.get(i);
                System.out.println("\n****** News #" + (i + 1) + ": " + e.title + '\n' + e.content);
                if (e.id == null) {
                    throw new IOException("missing ID");
                }
                if (e.title == null) {
                    throw new IOException("missing title");
                }
                if (e.content == null) {
                    throw new IOException("missing content");
                }
                if (e.authorName == null) {
                    throw new IOException("missing author");
                }
                if (e.updated == 0L) {
                    throw new IOException("missing updated");
                }
                if (uuids.add(e.id)) continue;
                throw new IOException("duplicate ID");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
    }

    private static class I2PParserException
    extends IOException {
        public I2PParserException(String s) {
            super(s);
        }

        public I2PParserException(Throwable t) {
            super("XML Parse Error", t);
        }
    }

    public static enum XHTMLMode {
        ABORT,
        REMOVE_ELEMENT,
        REMOVE_ATTRIBUTE,
        SKIP_ENTRY,
        ALLOW_ALL;

    }
}

