/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.xlattice.crypto.filters.BloomSHA1;

public class DecayingBloomFilter {
    protected final I2PAppContext _context;
    protected final Log _log;
    private BloomSHA1 _current;
    private BloomSHA1 _previous;
    protected final int _durationMs;
    protected final int _entryBytes;
    private final byte[][] _extenders;
    private final byte[] _extended;
    private final byte[] _longToEntry;
    private final long _longToEntryMask;
    protected long _currentDuplicates;
    protected volatile boolean _keepDecaying;
    protected final SimpleTimer2.TimedEvent _decayEvent;
    protected final String _name;
    protected final ReentrantReadWriteLock _reorganizeLock = new ReentrantReadWriteLock();
    private static final int DEFAULT_M = 23;
    private static final int DEFAULT_K = 11;
    private static final boolean ALWAYS_MISS = false;

    protected DecayingBloomFilter(int durationMs, int entryBytes, String name, I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(this.getClass());
        this._entryBytes = entryBytes;
        this._name = name;
        this._durationMs = durationMs;
        this._extenders = null;
        this._extended = null;
        this._longToEntry = null;
        this._longToEntryMask = 0L;
        context.addShutdownTask(new Shutdown());
        this._keepDecaying = true;
        if (this._durationMs == 3600000) {
            this._decayEvent = new DecayHourlyEvent();
        } else {
            this._decayEvent = new DecayEvent();
            this._decayEvent.schedule(this._durationMs);
        }
    }

    public DecayingBloomFilter(I2PAppContext context, int durationMs, int entryBytes) {
        this(context, durationMs, entryBytes, "DBF");
    }

    public DecayingBloomFilter(I2PAppContext context, int durationMs, int entryBytes, String name) {
        this(context, durationMs, entryBytes, name, context.getProperty("router.decayingBloomFilterM", 23));
    }

    public DecayingBloomFilter(I2PAppContext context, int durationMs, int entryBytes, String name, int m) {
        this._context = context;
        this._log = context.logManager().getLog(DecayingBloomFilter.class);
        this._entryBytes = entryBytes;
        this._name = name;
        int k = 11;
        if (m > 23) {
            --k;
            if (m > 26) {
                --k;
                if (m > 29) {
                    throw new IllegalArgumentException("Max m is 29");
                }
            }
        }
        this._current = new BloomSHA1(m, k);
        this._previous = new BloomSHA1(m, k);
        this._durationMs = durationMs;
        int numExtenders = (32 + (entryBytes - 1)) / entryBytes - 1;
        if (numExtenders < 0) {
            numExtenders = 0;
        }
        this._extenders = new byte[numExtenders][entryBytes];
        for (int i = 0; i < numExtenders; ++i) {
            this._context.random().nextBytes(this._extenders[i]);
        }
        if (numExtenders > 0) {
            this._extended = new byte[32];
            this._longToEntry = new byte[this._entryBytes];
            this._longToEntryMask = (1L << (int)((long)this._entryBytes * 8L)) - 1L;
        } else {
            this._extended = null;
            this._longToEntry = null;
            this._longToEntryMask = 0L;
        }
        this._keepDecaying = true;
        if (this._durationMs == 3600000) {
            this._decayEvent = new DecayHourlyEvent();
        } else {
            this._decayEvent = new DecayEvent();
            this._decayEvent.schedule(this._durationMs);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("New DBF " + name + " m = " + m + " k = " + k + " entryBytes = " + entryBytes + " numExtenders = " + numExtenders + " cycle (s) = " + durationMs / 1000);
        }
        context.statManager().createRateStat("router.decayingBloomFilter." + name + ".size", "Size", "Router", new long[]{10 * Math.max(60000, durationMs)});
        context.statManager().createRateStat("router.decayingBloomFilter." + name + ".dups", "1000000 * Duplicates/Size", "Router", new long[]{10 * Math.max(60000, durationMs)});
        context.statManager().createRateStat("router.decayingBloomFilter." + name + ".log10(falsePos)", "log10 of the false positive rate (must have net.i2p.util.DecayingBloomFilter=DEBUG)", "Router", new long[]{10 * Math.max(60000, durationMs)});
        context.addShutdownTask(new Shutdown());
    }

    public long getCurrentDuplicateCount() {
        return this._currentDuplicates;
    }

    public int getInsertedCount() {
        return this._current.size() + this._previous.size();
    }

    public double getFalsePositiveRate() {
        return this._current.falsePositives();
    }

    public boolean add(byte[] entry) {
        return this.add(entry, 0, entry.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(byte[] entry, int off, int len) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        if (len != this._entryBytes) {
            throw new IllegalArgumentException("Bad entry [" + len + ", expected " + this._entryBytes + "]");
        }
        this.getReadLock();
        try {
            boolean bl = this.locked_add(entry, off, len, true);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(long entry) {
        if (this._entryBytes <= 7) {
            entry = (entry ^ this._longToEntryMask) & Integer.MAX_VALUE | entry ^ this._longToEntryMask;
        }
        if (entry < 0L) {
            DataHelper.toLong(this._longToEntry, 0, this._entryBytes, 0L - entry);
            this._longToEntry[0] = (byte)(this._longToEntry[0] | 0x80);
        } else {
            DataHelper.toLong(this._longToEntry, 0, this._entryBytes, entry);
        }
        this.getReadLock();
        try {
            boolean bl = this.locked_add(this._longToEntry, 0, this._longToEntry.length, true);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnown(long entry) {
        if (this._entryBytes <= 7) {
            entry = (entry ^ this._longToEntryMask) & Integer.MAX_VALUE | entry ^ this._longToEntryMask;
        }
        if (entry < 0L) {
            DataHelper.toLong(this._longToEntry, 0, this._entryBytes, 0L - entry);
            this._longToEntry[0] = (byte)(this._longToEntry[0] | 0x80);
        } else {
            DataHelper.toLong(this._longToEntry, 0, this._entryBytes, entry);
        }
        this.getReadLock();
        try {
            boolean bl = this.locked_add(this._longToEntry, 0, this._longToEntry.length, false);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean locked_add(byte[] entry, int offset, int len, boolean addIfNew) {
        if (this._extended != null) {
            System.arraycopy(entry, offset, this._extended, 0, len);
            for (int i = 0; i < this._extenders.length; ++i) {
                DataHelper.xor(entry, offset, this._extenders[i], 0, this._extended, this._entryBytes * (i + 1), this._entryBytes);
            }
            BloomSHA1.FilterKey key = this._current.getFilterKey(this._extended, 0, 32);
            boolean seen = this._current.locked_member(key);
            if (!seen) {
                seen = this._previous.locked_member(key);
            }
            if (seen) {
                ++this._currentDuplicates;
                this._current.release(key);
                return true;
            }
            if (addIfNew) {
                this._current.locked_insert(key);
            }
            this._current.release(key);
            return false;
        }
        BloomSHA1.FilterKey key = this._current.getFilterKey(entry, offset, len);
        boolean seen = this._current.locked_member(key);
        if (!seen) {
            seen = this._previous.locked_member(key);
        }
        if (seen) {
            ++this._currentDuplicates;
            this._current.release(key);
            return true;
        }
        if (addIfNew) {
            this._current.locked_insert(key);
        }
        this._current.release(key);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.getWriteLock()) {
            return;
        }
        try {
            this._current.clear();
            this._previous.clear();
            this._currentDuplicates = 0L;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void stopDecaying() {
        this._keepDecaying = false;
        this._decayEvent.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decay() {
        int currentCount = 0;
        long dups = 0L;
        double fpr = 0.0;
        if (!this.getWriteLock()) {
            return;
        }
        try {
            BloomSHA1 tmp = this._previous;
            currentCount = this._current.size();
            if (this._log.shouldLog(10) && currentCount > 0) {
                fpr = this._current.falsePositives();
            }
            this._previous = this._current;
            this._current = tmp;
            this._current.clear();
            dups = this._currentDuplicates;
            this._currentDuplicates = 0L;
        }
        finally {
            this.releaseWriteLock();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Decaying the filter " + this._name + " after inserting " + currentCount + " elements and " + dups + " false positives with FPR = " + fpr);
        }
        this._context.statManager().addRateData("router.decayingBloomFilter." + this._name + ".size", currentCount);
        if (currentCount > 0) {
            this._context.statManager().addRateData("router.decayingBloomFilter." + this._name + ".dups", 1000000L * dups / (long)currentCount);
        }
        if (fpr > 0.0) {
            long exponent = (long)Math.log10(fpr);
            this._context.statManager().addRateData("router.decayingBloomFilter." + this._name + ".log10(falsePos)", exponent);
        }
    }

    protected void getReadLock() {
        this._reorganizeLock.readLock().lock();
    }

    protected void releaseReadLock() {
        this._reorganizeLock.readLock().unlock();
    }

    protected boolean getWriteLock() {
        try {
            boolean rv = this._reorganizeLock.writeLock().tryLock(5000L, TimeUnit.MILLISECONDS);
            if (!rv) {
                this._log.error("no lock, size is: " + this._reorganizeLock.getQueueLength(), new Exception("rats"));
            }
            return rv;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    protected void releaseWriteLock() {
        this._reorganizeLock.writeLock().unlock();
    }

    private class DecayEvent
    extends SimpleTimer2.TimedEvent {
        DecayEvent() {
            super(DecayingBloomFilter.this._context.simpleTimer2());
        }

        @Override
        public void timeReached() {
            if (DecayingBloomFilter.this._keepDecaying) {
                DecayingBloomFilter.this.decay();
                this.schedule(DecayingBloomFilter.this._durationMs);
            }
        }
    }

    private class DecayHourlyEvent
    extends SimpleTimer2.TimedEvent {
        private static final long HOUR = 3600000L;
        private static final long LAG = 300000L;
        private volatile long _currentHour;

        DecayHourlyEvent() {
            super(DecayingBloomFilter.this._context.simpleTimer2());
            this.schedule(this.getTimeTillNextHour());
        }

        @Override
        public void timeReached() {
            if (DecayingBloomFilter.this._keepDecaying) {
                long now = DecayingBloomFilter.this._context.clock().now();
                long currentHour = now / 3600000L;
                if (this._currentHour != currentHour) {
                    DecayingBloomFilter.this.decay();
                    this._currentHour = currentHour;
                }
                long next = (1L + currentHour) * 3600000L + 300000L;
                this.schedule(Math.max(5000L, next - now));
            }
        }

        private long getTimeTillNextHour() {
            long currentHour;
            long now = DecayingBloomFilter.this._context.clock().now();
            this._currentHour = currentHour = now / 3600000L;
            long next = (1L + currentHour) * 3600000L + 300000L;
            return Math.max(5000L, next - now);
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            DecayingBloomFilter.this.clear();
        }
    }
}

