/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

class GeoIPv6 {
    private static final String GEOIP_DIR_DEFAULT = "geoip";
    private static final String GEOIP_FILE_DEFAULT = "geoipv6.dat.gz";
    private static final String MAGIC = "I2PGeoIPv6\u0000\u0001\u0000\u0000\u0000\u0000";
    private static final String COMMENT = "I2P compressed geoipv6 file. See GeoIPv6.java for format.";
    private static final int HEADER_LEN = 256;

    GeoIPv6() {
    }

    public static String[] readGeoIPFile(I2PAppContext context, Long[] search, Map<String, String> codeCache) {
        Log log = context.logManager().getLog(GeoIPv6.class);
        File geoFile = new File(context.getBaseDir(), GEOIP_DIR_DEFAULT);
        if (!(geoFile = new File(geoFile, GEOIP_FILE_DEFAULT)).exists()) {
            if (log.shouldLog(30)) {
                log.warn("GeoIP file not found: " + geoFile.getAbsolutePath());
            }
            return new String[0];
        }
        return GeoIPv6.readGeoIPFile(geoFile, search, codeCache, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readGeoIPFile(File geoFile, Long[] search, Map<String, String> codeCache, Log log) {
        String[] rv = new String[search.length];
        int idx = 0;
        long start = System.currentTimeMillis();
        InputStream in = null;
        try {
            in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(geoFile)));
            byte[] magic = new byte[MAGIC.length()];
            DataHelper.read(in, magic);
            if (!DataHelper.eq(magic, DataHelper.getASCII(MAGIC))) {
                throw new IOException("Not a IPv6 geoip data file");
            }
            DataHelper.skip(in, 256 - MAGIC.length());
            byte[] buf = new byte[18];
            while (DataHelper.read(in, buf) == 18 && idx < search.length) {
                long ip1 = GeoIPv6.readLong(buf, 0);
                long ip2 = GeoIPv6.readLong(buf, 8);
                while (idx < search.length && search[idx] < ip1) {
                    ++idx;
                }
                while (idx < search.length && search[idx] >= ip1 && search[idx] <= ip2) {
                    String lc = new String(buf, 16, 2, "ISO-8859-1");
                    String cached = codeCache.get(lc);
                    if (cached == null) {
                        cached = lc;
                    }
                    rv[idx++] = cached;
                }
            }
        }
        catch (IOException ioe) {
            if (log.shouldLog(40)) {
                log.error("Error reading the geoFile", ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (log.shouldLog(20)) {
            log.info("GeoIPv6 processing finished, time: " + (System.currentTimeMillis() - start));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compressGeoIPv6CSVFiles(List<File> inFiles, File outFile) {
        boolean DEBUG = false;
        ArrayList<V6Entry> entries = new ArrayList<V6Entry>(20000);
        for (File geoFile : inFiles) {
            int count = 0;
            InputStream in = null;
            BufferedReader br = null;
            try {
                in = new BufferedInputStream(new FileInputStream(geoFile));
                if (geoFile.getName().endsWith(".gz")) {
                    in = new GZIPInputStream(in);
                }
                String buf = null;
                br = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
                while ((buf = br.readLine()) != null) {
                    try {
                        if (buf.charAt(0) == '#') continue;
                        String[] s = DataHelper.split(buf, ",");
                        String ips1 = s[0].replace("\"", "").trim();
                        String ips2 = s[1].replace("\"", "").trim();
                        byte[] ip1 = InetAddress.getByName(ips1).getAddress();
                        byte[] ip2 = InetAddress.getByName(ips2).getAddress();
                        String country = s[4].replace("\"", "").trim().toLowerCase(Locale.US);
                        entries.add(new V6Entry(ip1, ip2, country));
                        ++count;
                    }
                    catch (UnknownHostException uhe) {
                        uhe.printStackTrace();
                    }
                    catch (RuntimeException re) {
                        re.printStackTrace();
                    }
                }
                System.err.println("Read " + count + " entries from " + geoFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (br == null) continue;
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        Collections.sort(entries);
        V6Entry old = null;
        for (int i = 0; i < entries.size(); ++i) {
            V6Entry e = (V6Entry)entries.get(i);
            if (DEBUG) {
                System.out.println("proc " + e.toString());
            }
            if (old != null) {
                if (e.from == old.from && e.to == old.to) {
                    if (DEBUG) {
                        System.out.println("remove dup " + e);
                    }
                    entries.remove(i);
                    --i;
                    continue;
                }
                if (e.from <= old.to) {
                    if (e.from < old.to) {
                        V6Entry rewrite = new V6Entry(old.from, e.from - 1L, old.cc);
                        if (DEBUG) {
                            System.out.println("rewrite old to " + rewrite);
                        }
                        entries.set(i - 1, rewrite);
                    }
                    if (e.to < old.to) {
                        int j;
                        V6Entry insert = new V6Entry(e.to + 1L, old.to, old.cc);
                        if (DEBUG) {
                            System.out.println("insert " + insert);
                        }
                        for (j = i + 1; j < entries.size() && insert.compareTo((V6Entry)entries.get(j)) > 0; ++j) {
                        }
                        entries.add(j, insert);
                    }
                }
            }
            old = e;
        }
        OutputStream out = null;
        try {
            out = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            out.write(DataHelper.getASCII(MAGIC));
            GeoIPv6.writeLong(out, System.currentTimeMillis());
            byte[] comment = DataHelper.getUTF8(COMMENT);
            out.write(comment);
            out.write(new byte[256 - (24 + comment.length)]);
            for (V6Entry e : entries) {
                GeoIPv6.writeLong(out, e.from);
                GeoIPv6.writeLong(out, e.to);
                out.write(DataHelper.getASCII(e.cc));
            }
            System.err.println("Wrote " + entries.size() + " entries to " + outFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static long toLong(byte[] ip) {
        long rv = 0L;
        for (int i = 0; i < 8; ++i) {
            rv |= ((long)ip[i] & 0xFFL) << (7 - i) * 8;
        }
        return rv;
    }

    private static void writeLong(OutputStream rawStream, long value) throws IOException {
        for (int i = 56; i >= 0; i -= 8) {
            byte cur = (byte)(value >> i);
            rawStream.write(cur);
        }
    }

    private static long readLong(byte[] src, int offset) throws IOException {
        long rv = 0L;
        int limit = offset + 8;
        for (int i = offset; i < limit; ++i) {
            rv <<= 8;
            rv |= (long)(src[i] & 0xFF);
        }
        return rv;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: GeoIPv6 infile1.csv [infile2.csv...] outfile.dat.gz");
            System.exit(1);
        }
        ArrayList<File> infiles = new ArrayList<File>();
        for (int i = 0; i < args.length - 1; ++i) {
            infiles.add(new File(args[i]));
        }
        File outfile = new File(args[args.length - 1]);
        boolean success = GeoIPv6.compressGeoIPv6CSVFiles(infiles, outfile);
        if (!success) {
            System.err.println("Failed");
            System.exit(1);
        }
        GeoIPv6.readGeoIPFile(outfile, new Long[]{Long.MAX_VALUE}, Collections.<String, String>emptyMap(), new Log(GeoIPv6.class));
    }

    private static class V6Entry
    implements Comparable<V6Entry> {
        public final long from;
        public final long to;
        public final String cc;

        public V6Entry(byte[] f, byte[] t, String c) {
            if (f.length != 16 || t.length != 16 || c.length() != 2) {
                throw new IllegalArgumentException();
            }
            this.from = GeoIPv6.toLong(f);
            this.to = GeoIPv6.toLong(t);
            this.cc = c;
            if (this.to < this.from) {
                throw new IllegalArgumentException(this.toString());
            }
        }

        public V6Entry(long f, long t, String c) {
            this.from = f;
            this.to = t;
            this.cc = c;
            if (t < f) {
                throw new IllegalArgumentException(this.toString());
            }
        }

        @Override
        public int compareTo(V6Entry r) {
            if (this.from < r.from) {
                return -1;
            }
            if (r.from < this.from) {
                return 1;
            }
            if (this.to < r.to) {
                return -1;
            }
            if (r.to < this.to) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            return (int)this.from ^ (int)this.to;
        }

        public boolean equals(Object o) {
            return o instanceof V6Entry && this.compareTo((V6Entry)o) == 0;
        }

        public String toString() {
            return "0x" + Long.toHexString(this.from) + " -> 0x" + Long.toHexString(this.to) + " : " + this.cc;
        }
    }
}

