/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.time;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import net.i2p.router.time.NtpMessage;

class NtpClient {
    private static final double SECONDS_1900_TO_EPOCH = 2.2089888E9;
    private static final int NTP_PORT = 123;
    private static final int DEFAULT_TIMEOUT = 10000;

    NtpClient() {
    }

    public static long currentTime(String[] serverNames) {
        int i;
        if (serverNames == null) {
            throw new IllegalArgumentException("No NTP servers specified");
        }
        ArrayList<String> names = new ArrayList<String>(serverNames.length);
        for (i = 0; i < serverNames.length; ++i) {
            names.add(serverNames[i]);
        }
        Collections.shuffle(names);
        for (i = 0; i < names.size(); ++i) {
            long now = NtpClient.currentTime((String)names.get(i));
            if (now <= 0L) continue;
            return now;
        }
        throw new IllegalArgumentException("No reachable NTP servers specified");
    }

    public static long[] currentTimeAndStratum(String[] serverNames, int perServerTimeout) {
        int i;
        if (serverNames == null) {
            throw new IllegalArgumentException("No NTP servers specified");
        }
        ArrayList<String> names = new ArrayList<String>(serverNames.length);
        for (i = 0; i < serverNames.length; ++i) {
            names.add(serverNames[i]);
        }
        Collections.shuffle(names);
        for (i = 0; i < names.size(); ++i) {
            long[] rv = NtpClient.currentTimeAndStratum((String)names.get(i), perServerTimeout);
            if (rv == null || rv[0] <= 0L) continue;
            return rv;
        }
        throw new IllegalArgumentException("No reachable NTP servers specified");
    }

    public static long currentTime(String serverName) {
        long[] la = NtpClient.currentTimeAndStratum(serverName, 10000);
        if (la != null) {
            return la[0];
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] currentTimeAndStratum(String serverName, int timeout) {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            InetAddress address = InetAddress.getByName(serverName);
            byte[] buf = new NtpMessage().toByteArray();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, 123);
            NtpMessage.encodeTimestamp(packet.getData(), 40, (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9);
            socket.send(packet);
            packet = new DatagramPacket(buf, buf.length);
            socket.setSoTimeout(timeout);
            socket.receive(packet);
            double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
            NtpMessage msg = new NtpMessage(packet.getData());
            double localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
            if (msg.stratum < 1 || msg.stratum > 15) {
                long[] lArray = null;
                return lArray;
            }
            long[] rv = new long[]{(long)((double)System.currentTimeMillis() + localClockOffset * 1000.0), msg.stratum};
            long[] lArray = rv;
            return lArray;
        }
        catch (IOException ioe) {
            long[] lArray = null;
            return lArray;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }
}

