/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.data.DataHelper;
import net.i2p.util.BigPipedInputStream;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.SocketTimeout;

public class SSLEepGet
extends EepGet {
    private int _saveCerts;
    private boolean _bypassVerification;
    private boolean _commandLine;
    private final SSLContext _sslContext;
    private SavingTrustManager _stm;
    private static final String CERT_DIR = "certificates/ssl";

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url) {
        this(ctx, outputStream, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url, SSLState state) {
        this(ctx, null, outputStream, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, String outputFile, String url) {
        this(ctx, outputFile, url, null);
    }

    public SSLEepGet(I2PAppContext ctx, String outputFile, String url, SSLState state) {
        this(ctx, outputFile, null, url, null);
    }

    private SSLEepGet(I2PAppContext ctx, String outputFile, OutputStream outputStream, String url, SSLState state) {
        super(ctx, false, null, -1, 0, -1L, -1L, outputFile, outputStream, url, true, null, null);
        this._sslContext = state != null && state.context != null ? state.context : this.initSSLContext();
        if (this._sslContext == null) {
            this._log.error("Failed to initialize custom SSL context, using default context");
        }
    }

    public static void main(String[] args) {
        FileOutputStream out;
        int saveCerts = 0;
        boolean noVerify = false;
        boolean error = false;
        Getopt g = new Getopt("ssleepget", args, "sz");
        try {
            int c;
            block8: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 115: {
                        ++saveCerts;
                        continue block8;
                    }
                    case 122: {
                        noVerify = true;
                        continue block8;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            SSLEepGet.usage();
            System.exit(1);
        }
        String url = args[g.getOptind()];
        String saveAs = SSLEepGet.suggestName(url);
        try {
            out = new FileOutputStream(saveAs);
        }
        catch (IOException ioe) {
            System.err.println("Failed to create output file " + saveAs);
            return;
        }
        SSLEepGet get = new SSLEepGet(I2PAppContext.getGlobalContext(), out, url);
        if (saveCerts > 0) {
            get._saveCerts = saveCerts;
        }
        if (noVerify) {
            get._bypassVerification = true;
        }
        get._commandLine = true;
        SSLEepGet sSLEepGet = get;
        sSLEepGet.getClass();
        get.addStatusListener(sSLEepGet.new EepGet.CLIStatusListener(1024, 40));
        if (!get.fetch(45000L, -1L, 60000L)) {
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: SSLEepGet [-sz] https://url\n  -s save unknown certs\n  -s -s save all certs\n  -z bypass hostname verification");
    }

    private SSLContext initSSLContext() {
        int adds;
        KeyStore ks = KeyStoreUtil.loadSystemKeyStore();
        if (ks == null) {
            this._log.error("Key Store init error");
            return null;
        }
        if (this._log.shouldLog(20)) {
            int count = KeyStoreUtil.countCerts(ks);
            this._log.info("Loaded " + count + " default trusted certificates");
        }
        File dir = new File(this._context.getBaseDir(), CERT_DIR);
        int totalAdds = adds = KeyStoreUtil.addCerts(dir, ks);
        if (adds > 0 && this._log.shouldLog(20)) {
            this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
        }
        if (!this._context.getBaseDir().getAbsolutePath().equals(this._context.getConfigDir().getAbsolutePath())) {
            dir = new File(this._context.getConfigDir(), CERT_DIR);
            adds = KeyStoreUtil.addCerts(dir, ks);
            totalAdds += adds;
            if (adds > 0 && this._log.shouldLog(20)) {
                this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        dir = new File(System.getProperty("user.dir"));
        if (!this._context.getBaseDir().getAbsolutePath().equals(dir.getAbsolutePath())) {
            dir = new File(this._context.getConfigDir(), CERT_DIR);
            adds = KeyStoreUtil.addCerts(dir, ks);
            totalAdds += adds;
            if (adds > 0 && this._log.shouldLog(20)) {
                this._log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Loaded total of " + totalAdds + " new trusted certificates");
        }
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            this._stm = new SavingTrustManager(defaultTrustManager);
            sslc.init(null, new TrustManager[]{this._stm}, null);
            if (this._log.shouldLog(10)) {
                int i;
                SSLEngine eng = sslc.createSSLEngine();
                SSLParameters params = sslc.getDefaultSSLParameters();
                Object[] s = eng.getSupportedProtocols();
                Arrays.sort(s);
                this._log.debug("Supported protocols: " + s.length);
                for (i = 0; i < s.length; ++i) {
                    this._log.debug((String)s[i]);
                }
                s = eng.getEnabledProtocols();
                Arrays.sort(s);
                this._log.debug("Enabled protocols: " + s.length);
                for (i = 0; i < s.length; ++i) {
                    this._log.debug((String)s[i]);
                }
                s = params.getProtocols();
                if (s == null) {
                    s = new String[]{};
                }
                this._log.debug("Default protocols: " + s.length);
                Arrays.sort(s);
                for (i = 0; i < s.length; ++i) {
                    this._log.debug((String)s[i]);
                }
                s = eng.getSupportedCipherSuites();
                Arrays.sort(s);
                this._log.debug("Supported ciphers: " + s.length);
                for (i = 0; i < s.length; ++i) {
                    this._log.debug((String)s[i]);
                }
                s = eng.getEnabledCipherSuites();
                Arrays.sort(s);
                this._log.debug("Enabled ciphers: " + s.length);
                for (i = 0; i < s.length; ++i) {
                    this._log.debug((String)s[i]);
                }
                s = params.getCipherSuites();
                if (s == null) {
                    s = new String[]{};
                }
                this._log.debug("Default ciphers: " + s.length);
                Arrays.sort(s);
                for (i = 0; i < s.length; ++i) {
                    this._log.debug((String)s[i]);
                }
            }
            return sslc;
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Key Store update error", gse);
            return null;
        }
    }

    private static void saveCerts(String host, SavingTrustManager stm) {
        X509Certificate[] chain = stm.chain;
        if (chain == null) {
            System.out.println("Could not obtain server certificate chain");
            return;
        }
        for (int k = 0; k < chain.length; ++k) {
            X509Certificate cert = chain[k];
            String name = host + '-' + (k + 1) + ".crt";
            System.out.println("NOTE: Saving X509 certificate as " + name);
            System.out.println("      Issuer:     " + cert.getIssuerX500Principal());
            System.out.println("      Valid From: " + cert.getNotBefore());
            System.out.println("      Valid To:   " + cert.getNotAfter());
            try {
                cert.checkValidity();
            }
            catch (GeneralSecurityException e) {
                System.out.println("      WARNING: Certificate is not currently valid, it cannot be used");
            }
            CertUtil.saveCert(cert, new File(name));
        }
        System.out.println("NOTE: To trust them, copy the certificate file(s) to the certificates directory and rerun without the -s option");
    }

    public SSLState getSSLState() {
        return new SSLState(this._sslContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFetch(SocketTimeout timeout) throws IOException {
        this._headersRead = false;
        this._aborted = false;
        try {
            this.readHeaders();
        }
        finally {
            this._headersRead = true;
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        if (timeout != null) {
            timeout.resetTimer();
            if (this._fetchInactivityTimeout > 0) {
                timeout.setInactivityTimeout(this._fetchInactivityTimeout);
            } else {
                timeout.setInactivityTimeout(60000L);
            }
        }
        if (this._fetchInactivityTimeout > 0) {
            this._proxy.setSoTimeout(this._fetchInactivityTimeout);
        } else {
            this._proxy.setSoTimeout(60000);
        }
        if (this._redirectLocation != null) {
            throw new IOException("Server redirect to " + this._redirectLocation + " not allowed");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Headers read completely, reading " + this._bytesRemaining);
        }
        boolean strictSize = this._bytesRemaining >= 0L;
        I2PAppThread pusher = null;
        this._decompressException = null;
        if (this._isGzippedResponse) {
            PipedInputStream pi = BigPipedInputStream.getInstance();
            PipedOutputStream po = new PipedOutputStream(pi);
            pusher = new I2PAppThread(new EepGet.Gunzipper(pi, this._out), "EepGet Decompressor");
            this._out = po;
            ((Thread)pusher).start();
        }
        int remaining = (int)this._bytesRemaining;
        byte[] buf = new byte[16384];
        while (!(!this._keepFetching || remaining <= 0 && strictSize || this._aborted)) {
            int read;
            int toRead = buf.length;
            if (strictSize && toRead > remaining) {
                toRead = remaining;
            }
            if ((read = this._proxyIn.read(buf, 0, toRead)) == -1) break;
            if (timeout != null) {
                timeout.resetTimer();
            }
            this._out.write(buf, 0, read);
            this._bytesTransferred += (long)read;
            if ((remaining -= read) == 0 && this._encodingChunked) {
                int char1 = this._proxyIn.read();
                if (char1 == 13) {
                    int char2 = this._proxyIn.read();
                    if (char2 == 10) {
                        remaining = (int)this.readChunkLength();
                    } else {
                        this._out.write(char1);
                        this._out.write(char2);
                        this._bytesTransferred += 2L;
                        remaining -= 2;
                        read += 2;
                    }
                } else {
                    this._out.write(char1);
                    ++this._bytesTransferred;
                    --remaining;
                    ++read;
                }
            }
            if (timeout != null) {
                timeout.resetTimer();
            }
            if (this._bytesRemaining >= (long)read) {
                this._bytesRemaining -= (long)read;
            }
            if (read <= 0) continue;
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).bytesTransferred(this._alreadyTransferred, read, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url);
            }
            this._alreadyTransferred += (long)read;
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._isGzippedResponse) {
            try {
                pusher.join();
            }
            catch (InterruptedException toRead) {
                // empty catch block
            }
            pusher = null;
            if (this._decompressException != null) {
                this._keepFetching = false;
                throw this._decompressException;
            }
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        if (timeout != null) {
            timeout.cancel();
        }
        if (this._transferFailed) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, new Exception("Attempt failed"));
            }
        } else if (this._bytesRemaining == -1L || remaining == 0) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).transferComplete(this._alreadyTransferred, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url, this._outputFile, this._notModified);
            }
        } else {
            throw new IOException("Disconnection on attempt " + this._currentAttempt + " after " + this._bytesTransferred);
        }
    }

    @Override
    protected void sendRequest(SocketTimeout timeout) throws IOException {
        int port;
        String host;
        String req;
        block18: {
            File outFile;
            if (this._outputStream == null && (outFile = new File(this._outputFile)).exists()) {
                this._alreadyTransferred = outFile.length();
            }
            req = this.getRequest();
            try {
                URI url = new URI(this._actualURL);
                if ("https".equals(url.getScheme())) {
                    host = url.getHost();
                    if (host == null) {
                        throw new MalformedURLException("Bad URL");
                    }
                    if (host.toLowerCase(Locale.US).endsWith(".i2p")) {
                        throw new MalformedURLException("I2P addresses unsupported");
                    }
                    port = url.getPort();
                    if (port == -1) {
                        port = 443;
                    }
                    this._proxy = this._sslContext != null ? this._sslContext.getSocketFactory().createSocket(host, port) : SSLSocketFactory.getDefault().createSocket(host, port);
                    if (this._fetchHeaderTimeout > 0) {
                        this._proxy.setSoTimeout(this._fetchHeaderTimeout);
                    }
                    SSLSocket socket = (SSLSocket)this._proxy;
                    I2PSSLSocketFactory.setProtocolsAndCiphers(socket);
                    if (this._bypassVerification) break block18;
                    try {
                        I2PSSLSocketFactory.verifyHostname(this._context, socket, host);
                        break block18;
                    }
                    catch (SSLException ssle) {
                        if (this._saveCerts > 0 && this._stm != null) {
                            SSLEepGet.saveCerts(host, this._stm);
                        }
                        throw ssle;
                    }
                }
                throw new MalformedURLException("Only https supported: " + this._actualURL);
            }
            catch (URISyntaxException use) {
                MalformedURLException ioe = new MalformedURLException("Redirected to invalid URL");
                ioe.initCause(use);
                throw ioe;
            }
        }
        this._proxyIn = this._proxy.getInputStream();
        this._proxyOut = this._proxy.getOutputStream();
        try {
            this._proxyOut.write(DataHelper.getUTF8(req));
            this._proxyOut.flush();
            if (this._saveCerts > 1 && this._stm != null) {
                SSLEepGet.saveCerts(host, this._stm);
            }
        }
        catch (SSLException sslhe) {
            this._log.error("SSL negotiation error with " + host + ':' + port + " - self-signed certificate or untrusted certificate authority?", sslhe);
            if (this._saveCerts > 0 && this._stm != null) {
                SSLEepGet.saveCerts(host, this._stm);
            } else if (this._commandLine) {
                System.out.println("FAILED (probably due to untrusted certificates) - Run with -s option to save certificates");
            }
            throw sslhe;
        }
        this._proxyIn = new BufferedInputStream(this._proxyIn);
        if (this._log.shouldLog(10)) {
            this._log.debug("Request flushed");
        }
    }

    public static class SSLState {
        private final SSLContext context;

        private SSLState(SSLContext ctx) {
            this.context = ctx;
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

