/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import net.i2p.util.NativeBigInteger;

final class ECUtil {
    private static final BigInteger TWO = new BigInteger("2");
    private static final BigInteger THREE = new BigInteger("3");

    ECUtil() {
    }

    public static ECPoint scalarMult(ECPoint p, BigInteger kin, EllipticCurve curve) {
        int i;
        ECPoint r = ECPoint.POINT_INFINITY;
        BigInteger prime = ((ECFieldFp)curve.getField()).getP();
        BigInteger k = kin.mod(prime);
        int length = k.bitLength();
        byte[] binarray = new byte[length];
        for (i = 0; i <= length - 1; ++i) {
            binarray[i] = k.mod(TWO).byteValue();
            k = k.divide(TWO);
        }
        for (i = length - 1; i >= 0; --i) {
            r = ECUtil.doublePoint(r, curve);
            if (binarray[i] != 1) continue;
            r = ECUtil.addPoint(r, p, curve);
        }
        return r;
    }

    private static ECPoint addPoint(ECPoint r, ECPoint s, EllipticCurve curve) {
        if (r.equals(s)) {
            return ECUtil.doublePoint(r, curve);
        }
        if (r.equals(ECPoint.POINT_INFINITY)) {
            return s;
        }
        if (s.equals(ECPoint.POINT_INFINITY)) {
            return r;
        }
        BigInteger prime = ((ECFieldFp)curve.getField()).getP();
        BigInteger slope = r.getAffineY().subtract(s.getAffineY()).multiply(r.getAffineX().subtract(s.getAffineX()).modInverse(prime)).mod(prime);
        slope = new NativeBigInteger(slope);
        BigInteger xOut = slope.modPow(TWO, prime).subtract(r.getAffineX()).subtract(s.getAffineX()).mod(prime);
        BigInteger yOut = s.getAffineY().negate().mod(prime);
        yOut = yOut.add(slope.multiply(s.getAffineX().subtract(xOut))).mod(prime);
        ECPoint out = new ECPoint(xOut, yOut);
        return out;
    }

    private static ECPoint doublePoint(ECPoint r, EllipticCurve curve) {
        if (r.equals(ECPoint.POINT_INFINITY)) {
            return r;
        }
        BigInteger slope = r.getAffineX().pow(2).multiply(THREE);
        slope = slope.add(curve.getA());
        BigInteger prime = ((ECFieldFp)curve.getField()).getP();
        slope = slope.multiply(r.getAffineY().multiply(TWO).modInverse(prime));
        BigInteger xOut = slope.pow(2).subtract(r.getAffineX().multiply(TWO)).mod(prime);
        BigInteger yOut = r.getAffineY().negate().add(slope.multiply(r.getAffineX().subtract(xOut))).mod(prime);
        ECPoint out = new ECPoint(xOut, yOut);
        return out;
    }
}

