/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.X509Certificate;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.KeyRing;
import net.i2p.crypto.SigType;
import net.i2p.util.SystemVersion;

class DirKeyRing
implements KeyRing {
    private final File _base;

    public DirKeyRing(File baseDir) {
        this._base = baseDir;
    }

    @Override
    public PublicKey getKey(String keyName, String scope, SigType type) throws GeneralSecurityException, IOException {
        String cn;
        String fileName = keyName.replace("@", "_at_").replace("<", "_").replace(">", "_");
        File test = new File(fileName);
        if (test.getParent() != null) {
            throw new IOException("bad key name");
        }
        File sd = new File(this._base, scope);
        File kd = new File(sd, fileName + ".crt");
        if (!kd.exists()) {
            return null;
        }
        X509Certificate cert = CertUtil.loadCert(kd);
        if (CertUtil.isRevoked(cert)) {
            throw new CRLException("Certificate is revoked");
        }
        if (!SystemVersion.isAndroid() && !keyName.equals(cn = CertUtil.getSubjectValue(cert, "CN"))) {
            throw new GeneralSecurityException("CN mismatch: " + cn);
        }
        return cert.getPublicKey();
    }

    @Override
    public void setKey(String keyName, String scope, PublicKey key) {
    }
}

