/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.apps.systray;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.apps.systray.BrowserChooser;
import net.i2p.apps.systray.ConfigFile;
import net.i2p.apps.systray.UrlLauncher;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import snoozesoft.systray4j.SysTrayMenu;
import snoozesoft.systray4j.SysTrayMenuEvent;
import snoozesoft.systray4j.SysTrayMenuIcon;
import snoozesoft.systray4j.SysTrayMenuItem;
import snoozesoft.systray4j.SysTrayMenuListener;

public class SysTray
implements SysTrayMenuListener {
    private static BrowserChooser _browserChooser;
    private static String _browserString;
    private static ConfigFile _configFile;
    private static Frame _frame;
    private static SysTray _instance;
    private static String _portString;
    private static boolean _showIcon;
    private static final boolean _is64;
    private SysTrayMenuItem _itemOpenConsole = new SysTrayMenuItem("Open router console", "openconsole");
    private SysTrayMenuItem _itemSelectBrowser = new SysTrayMenuItem("Select browser...", "selectbrowser");
    private SysTrayMenuIcon _sysTrayMenuIcon = new SysTrayMenuIcon("icons/iggy");
    private SysTrayMenu _sysTrayMenu = new SysTrayMenu(this._sysTrayMenuIcon, "I2P Control");
    private static final long REFRESH_DISPLAY_FREQUENCY = 30000L;

    private SysTray() {
        this._sysTrayMenuIcon.addSysTrayMenuListener((SysTrayMenuListener)this);
        this.createSysTrayMenu();
        SimpleTimer2.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new RefreshDisplayEvent(), 30000L);
    }

    public static synchronized SysTray getInstance() {
        return _instance;
    }

    private static void openRouterConsole(String url) {
        String browser = null;
        UrlLauncher urlLauncher = new UrlLauncher();
        if (_browserString == null || _browserString.equals("default")) {
            try {
                if (urlLauncher.openUrl(url)) {
                    return;
                }
            }
            catch (IOException iOException) {}
        } else {
            try {
                if (urlLauncher.openUrl(url, _browserString)) {
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        browser = SysTray.promptForBrowser("Please select another browser");
        if (!browser.equals("nullnull")) {
            SysTray.setBrowser(browser);
        }
    }

    private static String promptForBrowser(String windowTitle) {
        String browser = null;
        _frame = new Frame();
        _browserChooser = new BrowserChooser(_frame, windowTitle);
        browser = _browserChooser.getDirectory() + _browserChooser.getFile();
        _browserChooser = null;
        _frame = null;
        return browser;
    }

    private static void setBrowser(String browser) {
        _browserString = browser;
        _configFile.setProperty("browser", browser);
    }

    public void refreshDisplay() {
        if (_showIcon) {
            this._sysTrayMenu.showIcon();
        } else {
            this._sysTrayMenu.hideIcon();
        }
    }

    public void hide() {
        _configFile.setProperty("visible", "false");
        _showIcon = false;
        this._sysTrayMenu.hideIcon();
    }

    public void iconLeftClicked(SysTrayMenuEvent e) {
    }

    public void iconLeftDoubleClicked(SysTrayMenuEvent e) {
        SysTray.openRouterConsole("http://127.0.0.1:" + _portString + "/index.jsp");
    }

    public void menuItemSelected(SysTrayMenuEvent e) {
        String browser = null;
        if (e.getActionCommand().equals("selectbrowser")) {
            browser = SysTray.promptForBrowser("Select browser");
            if (!browser.equals("nullnull")) {
                SysTray.setBrowser(browser);
            }
        } else if (e.getActionCommand().equals("openconsole")) {
            SysTray.openRouterConsole("http://127.0.0.1:" + _portString + "/index.jsp");
        }
    }

    public void show() {
        _configFile.setProperty("visible", "true");
        _showIcon = true;
        this._sysTrayMenu.showIcon();
    }

    private void createSysTrayMenu() {
        this._itemSelectBrowser.addSysTrayMenuListener((SysTrayMenuListener)this);
        this._itemOpenConsole.addSysTrayMenuListener((SysTrayMenuListener)this);
        this._sysTrayMenu.addItem(this._itemOpenConsole);
        this.refreshDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Thread t;
        System.err.println("SysTray4j version " + SysTrayMenu.VERSION);
        System.err.println("Hit ^C to exit");
        new SysTray();
        Thread thread = t = Thread.currentThread();
        synchronized (thread) {
            try {
                t.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        _configFile = new ConfigFile();
        _is64 = SystemVersion.is64Bit();
        File config = new File(I2PAppContext.getGlobalContext().getConfigDir(), "systray.config");
        if (!_configFile.init(config.getAbsolutePath())) {
            _configFile.setProperty("browser", "default");
            _configFile.setProperty("port", "7657");
        }
        _browserString = _configFile.getProperty("browser", "default");
        _portString = _configFile.getProperty("port", "7657");
        _showIcon = Boolean.parseBoolean(_configFile.getProperty("visible", "true"));
        if (SystemVersion.isWindows() && !Boolean.getBoolean("systray.disable") && !_is64) {
            _instance = new SysTray();
        }
    }

    private class RefreshDisplayEvent
    implements SimpleTimer.TimedEvent {
        private RefreshDisplayEvent() {
        }

        public void timeReached() {
            SysTray.this.refreshDisplay();
        }
    }
}

