/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import net.i2p.BOB.NamedDB;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class UDPIOthread
implements I2PSessionListener,
Runnable {
    private final NamedDB info;
    private final Log _log;
    private final Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private final I2PSession _session;
    private Destination _peerDestination;
    private boolean up;

    UDPIOthread(NamedDB info, Log _log, Socket socket, I2PSession _session) {
        this.info = info;
        this._log = _log;
        this.socket = socket;
        this._session = _session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        byte[] data = new byte[1024];
        this.up = true;
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = new DataOutputStream(this.socket.getOutputStream());
        while (this.up) {
            int c = this.in.read(data);
            boolean ok = this._session.sendMessage(this._peerDestination, data, 0, c);
            if (ok) continue;
            this.up = false;
        }
        Object var5_6 = null;
        if (this._session == null) return;
        try {
            this._session.destroySession();
            return;
        }
        catch (I2PSessionException i2PSessionException) {}
        return;
        {
            catch (IOException ioe) {
                this._log.error("Error running", (Throwable)ioe);
                Object var5_7 = null;
                if (this._session == null) return;
                try {
                    this._session.destroySession();
                    return;
                }
                catch (I2PSessionException i2PSessionException) {}
                return;
            }
            catch (I2PSessionException ise) {
                this._log.error("Error communicating", (Throwable)ise);
                Object var5_8 = null;
                if (this._session == null) return;
                try {
                    this._session.destroySession();
                    return;
                }
                catch (I2PSessionException i2PSessionException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (this._session == null) throw throwable;
            try {
                this._session.destroySession();
                throw throwable;
            }
            catch (I2PSessionException i2PSessionException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void messageAvailable(I2PSession session, int msgId, long size) {
        try {
            byte[] msg = session.receiveMessage(msgId);
            if (msg != null) {
                this.out.write(msg);
                this.out.flush();
            }
        }
        catch (I2PSessionException ise) {
            this.up = false;
        }
        catch (IOException ioe) {
            this.up = false;
        }
    }

    public void disconnected(I2PSession session) {
        this._log.debug("Disconnected");
    }

    public void errorOccurred(I2PSession session, String message, Throwable error) {
        this._log.debug("Error occurred: " + message, error);
    }

    public void reportAbuse(I2PSession session, int severity) {
        this._log.debug("Abuse reported of severity " + severity);
    }
}

