/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import org.klomp.snark.MagnetState;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerID;
import org.klomp.snark.PeerListener;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.BEncoder;

abstract class ExtensionHandler {
    public static final int ID_HANDSHAKE = 0;
    public static final int ID_METADATA = 1;
    public static final String TYPE_METADATA = "ut_metadata";
    public static final int ID_PEX = 2;
    public static final String TYPE_PEX = "i2p_pex";
    public static final int ID_DHT = 3;
    public static final String TYPE_DHT = "i2p_dht";
    private static final int MAX_METADATA_SIZE = 819200;
    private static final int PARALLEL_REQUESTS = 3;
    private static final int TYPE_REQUEST = 0;
    private static final int TYPE_DATA = 1;
    private static final int TYPE_REJECT = 2;
    private static final int HASH_LENGTH = 32;

    ExtensionHandler() {
    }

    public static byte[] getHandshake(int metasize, boolean pexAndMetadata, boolean dht, boolean uploadOnly) {
        HashMap<String, Object> handshake = new HashMap<String, Object>();
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        if (pexAndMetadata) {
            m.put(TYPE_METADATA, 1);
            m.put(TYPE_PEX, 2);
            if (metasize >= 0) {
                handshake.put("metadata_size", metasize);
            }
        }
        if (dht) {
            m.put(TYPE_DHT, 3);
        }
        handshake.put("m", m);
        handshake.put("p", 6881);
        handshake.put("v", "I2PSnark");
        handshake.put("reqq", 5);
        if (uploadOnly) {
            handshake.put("upload_only", 1);
        }
        return BEncoder.bencode(handshake);
    }

    public static void handleMessage(Peer peer, PeerListener listener, int id, byte[] bs) {
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(ExtensionHandler.class);
        if (log.shouldLog(20)) {
            log.info("Got extension msg " + id + " length " + bs.length + " from " + peer);
        }
        if (id == 0) {
            ExtensionHandler.handleHandshake(peer, listener, bs, log);
        } else if (id == 1) {
            ExtensionHandler.handleMetadata(peer, listener, bs, log);
        } else if (id == 2) {
            ExtensionHandler.handlePEX(peer, listener, bs, log);
        } else if (id == 3) {
            ExtensionHandler.handleDHT(peer, listener, bs, log);
        } else if (log.shouldLog(20)) {
            log.info("Unknown extension msg " + id + " from " + peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleHandshake(Peer peer, PeerListener listener, byte[] bs, Log log) {
        block35: {
            if (log.shouldLog(10)) {
                log.debug("Got handshake msg from " + peer);
            }
            try {
                int remaining;
                ByteArrayInputStream is = new ByteArrayInputStream(bs);
                BDecoder dec = new BDecoder(is);
                BEValue bev = dec.bdecodeMap();
                Map<String, BEValue> map = bev.getMap();
                peer.setHandshakeMap(map);
                Map<String, BEValue> msgmap = map.get("m").getMap();
                if (log.shouldLog(10)) {
                    log.debug("Peer " + peer + " supports extensions: " + msgmap.keySet());
                }
                MagnetState state = peer.getMagnetState();
                if (msgmap.get(TYPE_METADATA) == null) {
                    if (log.shouldLog(10)) {
                        log.debug("Peer does not support metadata extension: " + peer);
                    }
                    MagnetState magnetState = state;
                    synchronized (magnetState) {
                        if (!state.isInitialized()) {
                            if (log.shouldLog(10)) {
                                log.debug("Dropping peer, we need metadata! " + peer);
                            }
                            peer.disconnect();
                        }
                    }
                    return;
                }
                BEValue msize = map.get("metadata_size");
                if (msize == null) {
                    if (log.shouldLog(10)) {
                        log.debug("Peer does not have the metainfo size yet: " + peer);
                    }
                    MagnetState magnetState = state;
                    synchronized (magnetState) {
                        if (!state.isInitialized()) {
                            if (log.shouldLog(10)) {
                                log.debug("Dropping peer, we need metadata! " + peer);
                            }
                            peer.disconnect();
                        }
                    }
                    return;
                }
                int metaSize = msize.getInt();
                if (log.shouldLog(10)) {
                    log.debug("Got the metainfo size: " + metaSize);
                }
                MagnetState magnetState = state;
                synchronized (magnetState) {
                    if (state.isComplete()) {
                        return;
                    }
                    if (state.isInitialized()) {
                        if (state.getSize() != metaSize) {
                            if (log.shouldLog(10)) {
                                log.debug("Wrong metainfo size " + metaSize + " from: " + peer);
                            }
                            peer.disconnect();
                            return;
                        }
                    } else {
                        if (metaSize > 819200) {
                            if (log.shouldLog(10)) {
                                log.debug("Huge metainfo size " + metaSize + " from: " + peer);
                            }
                            peer.disconnect(false);
                            return;
                        }
                        if (log.shouldLog(20)) {
                            log.info("Initialized state, metadata size = " + metaSize + " from " + peer);
                        }
                        state.initialize(metaSize);
                    }
                    remaining = state.chunksRemaining();
                }
                int count = Math.min(remaining, 3);
                for (int i = 0; i < count; ++i) {
                    int chk;
                    MagnetState magnetState2 = state;
                    synchronized (magnetState2) {
                        chk = state.getNextRequest();
                    }
                    if (log.shouldLog(20)) {
                        log.info("Request chunk " + chk + " from " + peer);
                    }
                    ExtensionHandler.sendRequest(peer, chk);
                }
            }
            catch (Exception e) {
                if (!log.shouldLog(30)) break block35;
                log.warn("Handshake exception from " + peer, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMetadata(Peer peer, PeerListener listener, byte[] bs, Log log) {
        block24: {
            if (log.shouldLog(10)) {
                log.debug("Got metadata msg from " + peer);
            }
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(bs);
                BDecoder dec = new BDecoder(is);
                BEValue bev = dec.bdecodeMap();
                Map<String, BEValue> map = bev.getMap();
                int type = map.get("msg_type").getInt();
                int piece = map.get("piece").getInt();
                MagnetState state = peer.getMagnetState();
                if (type == 0) {
                    int totalSize;
                    byte[] pc;
                    if (log.shouldLog(10)) {
                        log.debug("Got request for " + piece + " from: " + peer);
                    }
                    MagnetState magnetState = state;
                    synchronized (magnetState) {
                        pc = state.getChunk(piece);
                        totalSize = state.getSize();
                    }
                    ExtensionHandler.sendPiece(peer, piece, pc, totalSize);
                    peer.uploaded(pc.length);
                    listener.uploaded(peer, pc.length);
                    break block24;
                }
                if (type == 1) {
                    boolean done;
                    int chk = -1;
                    MagnetState magnetState = state;
                    synchronized (magnetState) {
                        if (state.isComplete()) {
                            return;
                        }
                        int len = ((InputStream)is).available();
                        peer.downloaded(len);
                        listener.downloaded(peer, len);
                        done = state.saveChunk(piece, bs, bs.length - len, len);
                        if (log.shouldLog(20)) {
                            log.info("Got chunk " + piece + " from " + peer);
                        }
                        if (!done) {
                            chk = state.getNextRequest();
                        }
                    }
                    if (done) {
                        if (log.shouldLog(30)) {
                            log.warn("Got last chunk from " + peer);
                        }
                    } else {
                        if (log.shouldLog(20)) {
                            log.info("Request chunk " + chk + " from " + peer);
                        }
                        ExtensionHandler.sendRequest(peer, chk);
                    }
                    break block24;
                }
                if (type == 2) {
                    if (log.shouldLog(30)) {
                        log.warn("Got reject msg from " + peer);
                    }
                    peer.disconnect(false);
                } else {
                    if (log.shouldLog(30)) {
                        log.warn("Got unknown metadata msg from " + peer);
                    }
                    peer.disconnect(false);
                }
            }
            catch (Exception e) {
                if (log.shouldLog(20)) {
                    log.info("Metadata ext. msg. exception from " + peer, e);
                }
                peer.disconnect(false);
            }
        }
    }

    private static void sendRequest(Peer peer, int piece) {
        ExtensionHandler.sendMessage(peer, 0, piece);
    }

    private static void sendMessage(Peer peer, int type, int piece) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("msg_type", type);
        map.put("piece", piece);
        byte[] payload = BEncoder.bencode(map);
        try {
            int hisMsgCode = peer.getHandshakeMap().get("m").getMap().get(TYPE_METADATA).getInt();
            peer.sendExtension(hisMsgCode, payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendPiece(Peer peer, int piece, byte[] data, int totalSize) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("msg_type", 1);
        map.put("piece", piece);
        map.put("total_size", totalSize);
        byte[] dict = BEncoder.bencode(map);
        byte[] payload = new byte[dict.length + data.length];
        System.arraycopy(dict, 0, payload, 0, dict.length);
        System.arraycopy(data, 0, payload, dict.length, data.length);
        try {
            int hisMsgCode = peer.getHandshakeMap().get("m").getMap().get(TYPE_METADATA).getInt();
            peer.sendExtension(hisMsgCode, payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void handlePEX(Peer peer, PeerListener listener, byte[] bs, Log log) {
        block6: {
            if (log.shouldLog(10)) {
                log.debug("Got PEX msg from " + peer);
            }
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(bs);
                BDecoder dec = new BDecoder(is);
                BEValue bev = dec.bdecodeMap();
                Map<String, BEValue> map = bev.getMap();
                bev = map.get("added");
                if (bev == null) {
                    return;
                }
                byte[] ids = bev.getBytes();
                if (ids.length < 32) {
                    return;
                }
                int len = Math.min(ids.length, 736);
                ArrayList<PeerID> peers = new ArrayList<PeerID>(len / 32);
                for (int off = 0; off < len; off += 32) {
                    byte[] hash = new byte[32];
                    System.arraycopy(ids, off, hash, 0, 32);
                    if (DataHelper.eq(hash, peer.getPeerID().getDestHash())) continue;
                    PeerID pID = new PeerID(hash, listener.getUtil());
                    peers.add(pID);
                }
                listener.gotPeers(peer, peers);
            }
            catch (Exception e) {
                if (!log.shouldLog(20)) break block6;
                log.info("PEX msg exception from " + peer, e);
            }
        }
    }

    private static void handleDHT(Peer peer, PeerListener listener, byte[] bs, Log log) {
        block3: {
            if (log.shouldLog(10)) {
                log.debug("Got DHT msg from " + peer);
            }
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(bs);
                BDecoder dec = new BDecoder(is);
                BEValue bev = dec.bdecodeMap();
                Map<String, BEValue> map = bev.getMap();
                int qport = map.get("port").getInt();
                int rport = map.get("rport").getInt();
                listener.gotPort(peer, qport, rport);
            }
            catch (Exception e) {
                if (!log.shouldLog(20)) break block3;
                log.info("DHT msg exception from " + peer, e);
            }
        }
    }

    public static void sendPEX(Peer peer, List<Peer> pList) {
        if (pList.isEmpty()) {
            return;
        }
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        byte[] peers = new byte[32 * pList.size()];
        int off = 0;
        for (Peer p : pList) {
            System.arraycopy(p.getPeerID().getDestHash(), 0, peers, off, 32);
            off += 32;
        }
        map.put("added", peers);
        byte[] payload = BEncoder.bencode(map);
        try {
            int hisMsgCode = peer.getHandshakeMap().get("m").getMap().get(TYPE_PEX).getInt();
            peer.sendExtension(hisMsgCode, payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendDHT(Peer peer, int qport, int rport) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("port", qport);
        map.put("rport", rport);
        byte[] payload = BEncoder.bencode(map);
        try {
            int hisMsgCode = peer.getHandshakeMap().get("m").getMap().get(TYPE_DHT).getInt();
            peer.sendExtension(hisMsgCode, payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

