/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionManager;
import net.i2p.client.streaming.impl.I2PSocketManagerFull;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.Destination;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

class ConnectionHandler {
    private final I2PAppContext _context;
    private final Log _log;
    private final ConnectionManager _manager;
    private final LinkedBlockingQueue<Packet> _synQueue;
    private final SimpleTimer2 _timer;
    private volatile boolean _active;
    private int _acceptTimeout;
    private static final int DEFAULT_ACCEPT_TIMEOUT = 3000;
    private static final int MAX_QUEUE_SIZE = 64;

    public ConnectionHandler(I2PAppContext context, ConnectionManager mgr, SimpleTimer2 timer) {
        this._context = context;
        this._log = context.logManager().getLog(ConnectionHandler.class);
        this._manager = mgr;
        this._timer = timer;
        this._synQueue = new LinkedBlockingQueue(64);
        this._acceptTimeout = 3000;
    }

    public synchronized void setActive(boolean active) {
        if (this._log.shouldLog(30)) {
            this._log.warn("setActive(" + active + ") called, previously " + this._active, (Throwable)new Exception("I did it"));
        }
        if (active && !this._active) {
            this._synQueue.clear();
        }
        boolean wasActive = this._active;
        this._active = active;
        if (wasActive && !active) {
            try {
                this._synQueue.put(new PoisonPacket());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean getActive() {
        return this._active;
    }

    public void receiveNewSyn(Packet packet) {
        boolean success;
        if (!this._active) {
            if (packet.isFlagSet(1)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping new SYN request, as we're not listening");
                }
                this.sendReset(packet);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Dropping non-SYN packet - not listening");
            }
            return;
        }
        if (this._manager.wasRecentlyClosed(packet.getSendStreamId())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping packet for recently closed stream: " + packet);
            }
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive new SYN: " + packet + ": timeout in " + this._acceptTimeout);
        }
        if (success = this._synQueue.offer(packet)) {
            this._timer.addEvent((SimpleTimer.TimedEvent)new TimeoutSyn(packet), (long)this._acceptTimeout);
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping new SYN request, as the queue is full");
            }
            if (packet.isFlagSet(1)) {
                this.sendReset(packet);
            }
        }
    }

    public Connection accept(long timeoutMs) throws ConnectException, SocketTimeoutException {
        if (this._log.shouldLog(10)) {
            this._log.debug("Accept(" + timeoutMs + ") called");
        }
        long expiration = timeoutMs + this._context.clock().now();
        while (true) {
            if (timeoutMs > 0L && expiration < this._context.clock().now()) {
                throw new SocketTimeoutException("accept() timed out");
            }
            if (!this._active) {
                Packet packet;
                while ((packet = this._synQueue.poll()) != null && packet.getOptionalDelay() != 65536) {
                    this.sendReset(packet);
                }
                throw new ConnectException("ServerSocket closed");
            }
            Packet syn = null;
            while (this._active && syn == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Accept(" + timeoutMs + "): active=" + this._active + " queue: " + this._synQueue.size());
                }
                if (timeoutMs <= 0L) {
                    try {
                        syn = this._synQueue.take();
                        continue;
                    }
                    catch (InterruptedException ie) {
                        ConnectException ce = new ConnectException("Interrupted accept()");
                        ce.initCause(ie);
                        throw ce;
                    }
                }
                long remaining = expiration - this._context.clock().now();
                if (remaining < 1L) break;
                try {
                    syn = this._synQueue.poll(remaining, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (InterruptedException ie) {
                    ConnectException ce = new ConnectException("Interrupted accept()");
                    ce.initCause(ie);
                    throw ce;
                }
            }
            if (syn == null) continue;
            if (syn.getOptionalDelay() == 65536) {
                throw new ConnectException("ServerSocket closed");
            }
            if (syn.isFlagSet(1)) {
                Destination from = syn.getOptionalFrom();
                if (from == null) {
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("Dropping SYN packet with no FROM: " + syn);
                    continue;
                }
                Connection oldcon = this._manager.getConnectionByOutboundId(syn.getReceiveStreamId());
                if (oldcon != null && from.equals((Object)oldcon.getRemotePeer())) {
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("Dropping dup SYN: " + syn);
                    continue;
                }
                Connection con = this._manager.receiveConnection(syn);
                if (con == null) continue;
                return con;
            }
            this.reReceivePacket(syn);
        }
    }

    private void reReceivePacket(Packet packet) {
        Connection con = this._manager.getConnectionByOutboundId(packet.getReceiveStreamId());
        if (con != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Found con for queued non-syn packet: " + packet);
            }
            this._manager.getPacketHandler().receivePacketDirect(packet, false);
        } else {
            if (I2PSocketManagerFull.pcapWriter != null && this._context.getBooleanProperty("i2p.streaming.pcap")) {
                packet.logTCPDump(null);
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Did not find con for queued non-syn packet, dropping: " + packet);
            }
            packet.releasePayload();
        }
    }

    private void sendReset(Packet packet) {
        boolean ok = packet.verifySignature(this._context, packet.getOptionalFrom(), null);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Received a spoofed SYN packet: they said they were " + packet.getOptionalFrom());
            }
            return;
        }
        PacketLocal reply = new PacketLocal(this._context, packet.getOptionalFrom(), packet.getSession());
        reply.setFlag(4);
        reply.setFlag(8);
        reply.setAckThrough(packet.getSequenceNum());
        reply.setSendStreamId(packet.getReceiveStreamId());
        reply.setReceiveStreamId(0L);
        reply.setOptionalFrom();
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending RST: " + reply + " because of " + packet);
        }
        this._manager.getPacketQueue().enqueue(reply);
    }

    private static class PoisonPacket
    extends Packet {
        public static final int POISON_MAX_DELAY_REQUEST = 65536;

        public PoisonPacket() {
            super(null);
        }

        @Override
        public int getOptionalDelay() {
            return 65536;
        }

        @Override
        public String toString() {
            return "POISON";
        }
    }

    private class TimeoutSyn
    implements SimpleTimer.TimedEvent {
        private final Packet _synPacket;

        public TimeoutSyn(Packet packet) {
            this._synPacket = packet;
        }

        public void timeReached() {
            boolean removed = ConnectionHandler.this._synQueue.remove(this._synPacket);
            if (removed) {
                if (this._synPacket.isFlagSet(1)) {
                    if (ConnectionHandler.this._log.shouldLog(30)) {
                        ConnectionHandler.this._log.warn("Expired on the SYN queue: " + this._synPacket);
                    }
                    ConnectionHandler.this.sendReset(this._synPacket);
                } else {
                    ConnectionHandler.this.reReceivePacket(this._synPacket);
                }
            }
        }
    }
}

