/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EntropyHarvester;
import net.i2p.util.I2PThread;
import net.i2p.util.SecureFileOutputStream;

public class RandomSource
extends SecureRandom
implements EntropyHarvester {
    private static final long serialVersionUID = 1L;
    private final EntropyHarvester _entropyHarvester;
    protected final transient I2PAppContext _context;
    private static final String SEEDFILE = "prngseed.rnd";

    public RandomSource(I2PAppContext context) {
        this._context = context;
        this._entropyHarvester = this;
    }

    public static RandomSource getInstance() {
        return I2PAppContext.getGlobalContext().random();
    }

    @Override
    public int nextInt(int n) {
        if (n == 0) {
            return 0;
        }
        int val = super.nextInt(n);
        if (val < 0) {
            val = 0 - val;
        }
        if (val >= n) {
            val %= n;
        }
        return val;
    }

    @Override
    public long nextLong(long n) {
        long v = super.nextLong();
        if (v < 0L) {
            v = 0L - v;
        }
        if (v >= n) {
            v %= n;
        }
        return v;
    }

    public void nextBytes(byte[] buf, int offset, int length) {
        if (offset == 0 && buf.length == length) {
            this.nextBytes(buf);
        } else {
            byte[] tmp = new byte[length];
            this.nextBytes(tmp);
            System.arraycopy(tmp, 0, buf, offset, length);
        }
    }

    public EntropyHarvester harvester() {
        return this._entropyHarvester;
    }

    @Override
    public void feedEntropy(String source, long data, int bitoffset, int bits) {
        if (bitoffset == 0) {
            this.setSeed(data);
        }
    }

    @Override
    public void feedEntropy(String source, byte[] data, int offset, int len) {
        if (offset == 0 && len == data.length) {
            this.setSeed(data);
        } else {
            this.setSeed(this._context.sha().calculateHash(data, offset, len).getData());
        }
    }

    public void loadSeed() {
        byte[] buf = new byte[1024];
        if (this.initSeed(buf)) {
            this.setSeed(buf);
        }
    }

    public void saveSeed() {
        byte[] buf = new byte[1024];
        this.nextBytes(buf);
        RandomSource.writeSeed(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeSeed(byte[] buf) {
        File f = new File(I2PAppContext.getGlobalContext().getConfigDir(), SEEDFILE);
        SecureFileOutputStream fos = null;
        try {
            fos = new SecureFileOutputStream(f);
            fos.write(buf);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initSeed(byte[] buf) {
        boolean ok = false;
        byte[] tbuf = new byte[buf.length];
        I2PThread t = new I2PThread(new SecureRandomInit(tbuf), "SecureRandomInit", true);
        ((Thread)t).start();
        try {
            t.join(10000L);
            byte[] byArray = tbuf;
            synchronized (tbuf) {
                for (int i = 0; i < tbuf.length; ++i) {
                    if (tbuf[i] == 0) continue;
                    ok = true;
                    break;
                }
                if (ok) {
                    System.arraycopy(tbuf, 0, buf, 0, buf.length);
                } else {
                    System.out.println("INFO: SecureRandom init failed or took too long");
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        {
            ok = RandomSource.seedFromFile(new File("/dev/urandom"), buf) || ok;
            File localFile = new File(this._context.getConfigDir(), SEEDFILE);
            ok = RandomSource.seedFromFile(localFile, buf) || ok;
            return ok;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean seedFromFile(File f, byte[] buf) {
        if (f.exists()) {
            FileInputStream fis = null;
            try {
                int read;
                int curRead;
                fis = new FileInputStream(f);
                byte[] tbuf = new byte[buf.length];
                for (read = 0; read < buf.length && (curRead = fis.read(tbuf, read, tbuf.length - read)) >= 0; read += curRead) {
                }
                for (int i = 0; i < read; ++i) {
                    int n = i;
                    buf[n] = (byte)(buf[n] ^ tbuf[i]);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    private static class SecureRandomInit
    implements Runnable {
        private final byte[] buf;

        public SecureRandomInit(byte[] buf) {
            this.buf = buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buf2 = new byte[this.buf.length];
            try {
                SecureRandom.getInstance("SHA1PRNG").nextBytes(buf2);
                byte[] byArray = this.buf;
                synchronized (this.buf) {
                    System.arraycopy(buf2, 0, this.buf, 0, this.buf.length);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            {
                return;
            }
        }
    }
}

