/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageHandler;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class I2CPMessageReader {
    private InputStream _stream;
    protected I2CPMessageEventListener _listener;
    protected I2CPMessageReaderRunner _reader;
    protected Thread _readerThread;
    protected static final AtomicLong __readerId = new AtomicLong();

    public I2CPMessageReader(InputStream stream, I2CPMessageEventListener lsnr) {
        this._stream = stream;
        this.setListener(lsnr);
        this._reader = new I2CPMessageReaderRunner();
        this._readerThread = new I2PThread(this._reader);
        this._readerThread.setDaemon(true);
        this._readerThread.setName("I2CP Reader " + __readerId.incrementAndGet());
    }

    protected I2CPMessageReader(I2CPMessageEventListener lsnr) {
        this.setListener(lsnr);
    }

    public void setListener(I2CPMessageEventListener lsnr) {
        this._listener = lsnr;
    }

    public I2CPMessageEventListener getListener() {
        return this._listener;
    }

    public void startReading() {
        this._readerThread.start();
    }

    public void pauseReading() {
        this._reader.pauseRunner();
    }

    public void resumeReading() {
        this._reader.resumeRunner();
    }

    public void stopReading() {
        this._reader.cancelRunner();
    }

    public static interface I2CPMessageEventListener {
        public void messageReceived(I2CPMessageReader var1, I2CPMessage var2);

        public void readError(I2CPMessageReader var1, Exception var2);

        public void disconnected(I2CPMessageReader var1);
    }

    protected class I2CPMessageReaderRunner
    implements Runnable {
        protected volatile boolean _doRun = true;
        protected volatile boolean _stayAlive = true;
        private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(I2CPMessageReader.class);

        public void pauseRunner() {
            this._doRun = false;
        }

        public void resumeRunner() {
            this._doRun = true;
        }

        public void cancelRunner() {
            this._doRun = false;
            this._stayAlive = false;
            InputStream in = I2CPMessageReader.this._stream;
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    this._log.error("Error closing the stream", ioe);
                }
            }
        }

        @Override
        public void run() {
            try {
                this.run2();
            }
            catch (RuntimeException e) {
                this._log.log(50, "Uncaught I2CP error", e);
                I2CPMessageReader.this._listener.readError(I2CPMessageReader.this, e);
                this.cancelRunner();
            }
        }

        protected void run2() {
            while (this._stayAlive) {
                while (this._doRun) {
                    try {
                        I2CPMessage msg = I2CPMessageHandler.readMessage(I2CPMessageReader.this._stream);
                        if (msg == null) continue;
                        I2CPMessageReader.this._listener.messageReceived(I2CPMessageReader.this, msg);
                    }
                    catch (I2CPMessageException ime) {
                        this._log.warn("Error handling message", ime);
                        I2CPMessageReader.this._listener.readError(I2CPMessageReader.this, ime);
                        this.cancelRunner();
                    }
                    catch (IOException ioe) {
                        this._log.warn("IO Error handling message", ioe);
                        I2CPMessageReader.this._listener.disconnected(I2CPMessageReader.this);
                        this.cancelRunner();
                    }
                    catch (OutOfMemoryError oom) {
                        throw oom;
                    }
                    catch (RuntimeException e) {
                        this._log.log(50, "Unhandled error reading I2CP stream", e);
                        I2CPMessageReader.this._listener.disconnected(I2CPMessageReader.this);
                        this.cancelRunner();
                    }
                }
                if (!this._stayAlive || this._doRun) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    this._log.warn("Breaking away stream", ie);
                    I2CPMessageReader.this._listener.disconnected(I2CPMessageReader.this);
                    this.cancelRunner();
                }
            }
            I2CPMessageReader.this._stream = null;
        }
    }
}

