/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CertUtil;
import net.i2p.data.Base32;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;

public class KeyStoreUtil {
    public static boolean _blacklistLogged;
    public static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String DEFAULT_KEY_ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 2048;
    private static final int DEFAULT_KEY_VALID_DAYS = 3652;
    private static final BigInteger[] BLACKLIST_SERIAL;
    private static final String[] BLACKLIST_ISSUER_CN;
    private static final String[] BLACKLIST_ISSUER_OU;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore createKeyStore(File ksFile, String password) throws GeneralSecurityException, IOException {
        boolean exists = ksFile != null && ksFile.exists();
        char[] pwchars = password != null ? password.toCharArray() : null;
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        if (exists) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(ksFile);
                ks.load(fis, pwchars);
            }
            finally {
                if (fis != null) {
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (ksFile != null && !exists) {
            OutputStream fos = null;
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
                fos = new SecureFileOutputStream(ksFile);
                ks.store(fos, pwchars);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return ks;
    }

    public static KeyStore loadSystemKeyStore() {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Key Store init error", gse);
            return null;
        }
        boolean success = false;
        String override = System.getProperty("javax.net.ssl.keyStore");
        if (override != null) {
            success = KeyStoreUtil.loadCerts(new File(override), ks);
        }
        if (!success) {
            if (SystemVersion.isAndroid()) {
                if (SystemVersion.getAndroidVersion() >= 14) {
                    try {
                        ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
                        success = KeyStoreUtil.addCerts(new File(System.getProperty("java.home"), "etc/security/cacerts"), ks) > 0;
                    }
                    catch (IOException iOException) {
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                } else {
                    success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "etc/security/cacerts.bks"), ks);
                }
            } else {
                success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "lib/security/jssecacerts"), ks);
                if (!success) {
                    success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "lib/security/cacerts"), ks);
                }
            }
        }
        if (success) {
            KeyStoreUtil.removeBlacklistedCerts(ks);
        } else {
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            KeyStoreUtil.error("All key store loads failed, will only load local certificates", null);
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadCerts(File file, KeyStore ks) {
        if (!file.exists()) {
            return false;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ks.load(fis, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            KeyStoreUtil.info("Certs loaded from " + file);
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), gse);
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), ioe);
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static int countCerts(KeyStore ks) {
        int count = 0;
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                if (!ks.isCertificateEntry(alias)) continue;
                ++count;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return count;
    }

    private static int removeBlacklistedCerts(KeyStore ks) {
        if (SystemVersion.isAndroid()) {
            return 0;
        }
        int count = 0;
        try {
            Enumeration<String> e = ks.aliases();
            block2: while (e.hasMoreElements()) {
                Certificate c;
                String alias = e.nextElement();
                if (!ks.isCertificateEntry(alias) || (c = ks.getCertificate(alias)) == null || !(c instanceof X509Certificate)) continue;
                X509Certificate xc = (X509Certificate)c;
                BigInteger serial = xc.getSerialNumber();
                for (int i = 0; i < BLACKLIST_SERIAL.length; ++i) {
                    String name;
                    if (!BLACKLIST_SERIAL[i].equals(serial)) continue;
                    if (BLACKLIST_ISSUER_CN[i] != null && BLACKLIST_ISSUER_CN[i].equals(name = CertUtil.getIssuerValue(xc, "CN"))) {
                        ks.deleteEntry(alias);
                        ++count;
                        if (_blacklistLogged) continue block2;
                        KeyStoreUtil.warn("Ignoring blacklisted certificate \"" + alias + "\" CN: \"" + name + "\" s/n: " + serial.toString(16), null);
                        continue block2;
                    }
                    if (BLACKLIST_ISSUER_OU[i] == null || !BLACKLIST_ISSUER_OU[i].equals(name = CertUtil.getIssuerValue(xc, "OU"))) continue;
                    ks.deleteEntry(alias);
                    ++count;
                    if (_blacklistLogged) continue block2;
                    KeyStoreUtil.warn("Ignoring blacklisted certificate \"" + alias + "\" OU: \"" + name + "\" s/n: " + serial.toString(16), null);
                    continue block2;
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        if (count > 0) {
            _blacklistLogged = true;
        }
        return count;
    }

    public static int addCerts(File dir, KeyStore ks) {
        File[] files;
        KeyStoreUtil.info("Looking for X509 Certificates in " + dir.getAbsolutePath());
        int added = 0;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean success;
                File f = files[i];
                if (!f.isFile()) continue;
                String alias = f.getName().toLowerCase(Locale.US);
                if (alias.endsWith(".crt") || alias.endsWith(".pem") || alias.endsWith(".key") || alias.endsWith(".der") || alias.endsWith(".key") || alias.endsWith(".p7b") || alias.endsWith(".p7c") || alias.endsWith(".pfx") || alias.endsWith(".p12") || alias.endsWith(".cer")) {
                    alias = alias.substring(0, alias.length() - 4);
                }
                if (!(success = KeyStoreUtil.addCert(f, alias, ks))) continue;
                ++added;
            }
        }
        return added;
    }

    public static boolean addCert(File file, String alias, KeyStore ks) {
        try {
            X509Certificate cert = CertUtil.loadCert(file);
            KeyStoreUtil.info("Read X509 Certificate from " + file.getAbsolutePath() + " Issuer: " + cert.getIssuerX500Principal() + " Serial: " + cert.getSerialNumber().toString(16) + "; Valid From: " + cert.getNotBefore() + " To: " + cert.getNotAfter());
            ks.setCertificateEntry(alias, cert);
            KeyStoreUtil.info("Now trusting X509 Certificate, Issuer: " + cert.getIssuerX500Principal());
        }
        catch (CertificateExpiredException cee) {
            String s = "Rejecting expired X509 Certificate: " + file.getAbsolutePath();
            if (SystemVersion.isAndroid()) {
                KeyStoreUtil.warn(s, cee);
            } else {
                KeyStoreUtil.error(s, cee);
            }
            return false;
        }
        catch (CertificateNotYetValidException cnyve) {
            KeyStoreUtil.error("Rejecting X509 Certificate not yet valid: " + file.getAbsolutePath(), cnyve);
            return false;
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Error reading X509 Certificate: " + file.getAbsolutePath(), gse);
            return false;
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("Error reading X509 Certificate: " + file.getAbsolutePath(), ioe);
            return false;
        }
        return true;
    }

    public static String randomString() {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] rand = new byte[30];
        ctx.random().nextBytes(rand);
        return Base32.encode(rand);
    }

    public static boolean createKeys(File ks, String alias, String cname, String ou, String keyPW) {
        return KeyStoreUtil.createKeys(ks, DEFAULT_KEYSTORE_PASSWORD, alias, cname, ou, 3652, DEFAULT_KEY_ALGORITHM, 2048, keyPW);
    }

    public static boolean createKeys(File ks, String ksPW, String alias, String cname, String ou, int validDays, String keyAlg, int keySize, String keyPW) {
        String keytool;
        String[] args;
        boolean success;
        block16: {
            SecureDirectory sdir;
            if (ks.exists()) {
                try {
                    if (KeyStoreUtil.getCert(ks, ksPW, alias) != null) {
                        KeyStoreUtil.error("Not overwriting key " + alias + ", already exists in " + ks, null);
                        return false;
                    }
                    break block16;
                }
                catch (IOException e) {
                    KeyStoreUtil.error("Not overwriting key \"" + alias + "\", already exists in " + ks, e);
                    return false;
                }
                catch (GeneralSecurityException e) {
                    KeyStoreUtil.error("Not overwriting key \"" + alias + "\", already exists in " + ks, e);
                    return false;
                }
            }
            File dir = ks.getParentFile();
            if (dir != null && !dir.exists() && !((File)(sdir = new SecureDirectory(dir.getAbsolutePath()))).mkdir()) {
                KeyStoreUtil.error("Can't create directory " + dir, null);
                return false;
            }
        }
        if (success = new ShellCommand().executeSilentAndWaitTimed(args = new String[]{keytool = new File(System.getProperty("java.home"), "bin/keytool").getAbsolutePath(), "-genkey", "-storetype", KeyStore.getDefaultType(), "-keystore", ks.getAbsolutePath(), "-storepass", ksPW, "-alias", alias, "-dname", "CN=" + cname + ",OU=" + ou + ",O=I2P Anonymous Network,L=XX,ST=XX,C=XX", "-validity", Integer.toString(validDays), "-keyalg", keyAlg, "-sigalg", KeyStoreUtil.getSigAlg(keySize, keyAlg), "-keysize", Integer.toString(keySize), "-keypass", keyPW}, 240)) {
            success = ks.exists();
            if (success) {
                try {
                    boolean bl = success = KeyStoreUtil.getPrivateKey(ks, ksPW, alias, keyPW) != null;
                    if (!success) {
                        KeyStoreUtil.error("Key gen failed to get private key", null);
                    }
                }
                catch (IOException e) {
                    KeyStoreUtil.error("Key gen failed to get private key", e);
                    success = false;
                }
                catch (GeneralSecurityException e) {
                    KeyStoreUtil.error("Key gen failed to get private key", e);
                    success = false;
                }
            }
            if (!success) {
                KeyStoreUtil.error("Key gen failed for unknown reasons", null);
            }
        }
        if (success) {
            SecureFileOutputStream.setPerms(ks);
            KeyStoreUtil.info("Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath());
        } else {
            StringBuilder buf = new StringBuilder(256);
            for (int i = 0; i < args.length; ++i) {
                buf.append('\"').append(args[i]).append("\" ");
            }
            KeyStoreUtil.error("Failed to generate keys using command line: " + buf, null);
        }
        return success;
    }

    private static String getSigAlg(int size, String keyalg) {
        if (keyalg.equals("EC")) {
            keyalg = "ECDSA";
        }
        String hash = keyalg.equals("ECDSA") ? (size <= 256 ? "SHA256" : (size <= 384 ? "SHA384" : "SHA512")) : (size <= 1024 ? "SHA1" : (size <= 2048 ? "SHA256" : (size <= 3072 ? "SHA384" : "SHA512")));
        return hash + "with" + keyalg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKey(File ks, String ksPW, String alias, String keyPW) throws GeneralSecurityException, IOException {
        InputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
            keyStore.load(fis, pwchars);
            char[] keypwchars = keyPW.toCharArray();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keypwchars);
            return privateKey;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCert(File ks, String ksPW, String alias) throws GeneralSecurityException, IOException {
        InputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
            keyStore.load(fis, pwchars);
            Certificate certificate = keyStore.getCertificate(alias);
            return certificate;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean exportCert(File ks, String ksPW, String alias, File certFile) {
        Object fis = null;
        try {
            Certificate cert = KeyStoreUtil.getCert(ks, ksPW, alias);
            if (cert != null) {
                return CertUtil.saveCert(cert, certFile);
            }
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Error saving ASCII SSL keys", gse);
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("Error saving ASCII SSL keys", ioe);
        }
        return false;
    }

    private static void info(String msg) {
        KeyStoreUtil.log(I2PAppContext.getGlobalContext(), 20, msg, null);
    }

    private static void warn(String msg, Throwable t) {
        KeyStoreUtil.log(I2PAppContext.getGlobalContext(), 30, msg, t);
    }

    private static void error(String msg, Throwable t) {
        KeyStoreUtil.log(I2PAppContext.getGlobalContext(), 40, msg, t);
    }

    private static void log(I2PAppContext ctx, int level, String msg, Throwable t) {
        if (level >= 30 && !ctx.isRouterContext()) {
            System.out.println(msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
        Log l = ctx.logManager().getLog(KeyStoreUtil.class);
        l.log(level, msg, t);
    }

    static {
        BLACKLIST_SERIAL = new BigInteger[]{new BigInteger("49:33:00:01".replace(":", ""), 16), new BigInteger("48:9f:00:01".replace(":", ""), 16), new BigInteger("d2:fc:13:87:a9:44:dc:e7".replace(":", ""), 16), new BigInteger("6b:c5:7b:95:18:93:aa:97:4b:62:4a:c0:88:fc:3b:b6".replace(":", ""), 16), new BigInteger("-5b:b3:c7:b8:07:11:8e:7f:bc:b2:4e:7f:46:58:16:9e".replace(":", ""), 16), new BigInteger("3c:91:31:cb:1f:f6:d0:1b:0e:9a:b8:d0:44:bf:12:be".replace(":", ""), 16), new BigInteger("70:ba:e4:1d:10:d9:29:34:b6:38:ca:7b:03:cc:ba:bf".replace(":", ""), 16), new BigInteger("44:be:0c:8b:50:00:21:b4:11:d3:2a:68:06:a9:ad:69".replace(":", ""), 16)};
        BLACKLIST_ISSUER_CN = new String[]{"CNNIC ROOT", "China Internet Network Information Center EV Certificates Root", "Superfish, Inc.", "eDellRoot", "DSDTestProvider", null, null, "UTN - DATACorp SGC"};
        BLACKLIST_ISSUER_OU = new String[]{null, null, null, null, null, "Class 3 Public Primary Certification Authority", "Class 3 Public Primary Certification Authority", null};
    }
}

