/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.ECConstants;
import net.i2p.crypto.EncAlgo;

public enum EncType {
    ELGAMAL_2048(0, 256, 256, EncAlgo.ELGAMAL, "ElGamal/None/NoPadding", CryptoConstants.ELGAMAL_2048_SPEC, "0"),
    EC_P256(1, 64, 32, EncAlgo.EC, "EC/None/NoPadding", ECConstants.P256_SPEC, "0.9.20"),
    EC_P384(2, 96, 48, EncAlgo.EC, "EC/None/NoPadding", ECConstants.P384_SPEC, "0.9.20"),
    EC_P521(3, 132, 66, EncAlgo.EC, "EC/None/NoPadding", ECConstants.P521_SPEC, "0.9.20");

    private final int code;
    private final int pubkeyLen;
    private final int privkeyLen;
    private final EncAlgo base;
    private final String algoName;
    private final String since;
    private final AlgorithmParameterSpec params;
    private final boolean isAvail;
    private static final Map<Integer, EncType> BY_CODE;

    private EncType(int cod, int pubLen, int privLen, EncAlgo baseAlgo, String transformation, AlgorithmParameterSpec pSpec, String supportedSince) {
        this.code = cod;
        this.pubkeyLen = pubLen;
        this.privkeyLen = privLen;
        this.base = baseAlgo;
        this.algoName = transformation;
        this.params = pSpec;
        this.since = supportedSince;
        this.isAvail = this.x_isAvailable();
    }

    public int getCode() {
        return this.code;
    }

    public int getPubkeyLen() {
        return this.pubkeyLen;
    }

    public int getPrivkeyLen() {
        return this.privkeyLen;
    }

    public EncAlgo getBaseAlgorithm() {
        return this.base;
    }

    public String getAlgorithmName() {
        return this.algoName;
    }

    public AlgorithmParameterSpec getParams() throws InvalidParameterSpecException {
        if (this.params == null) {
            throw new InvalidParameterSpecException(this.toString() + " is not available in this JVM");
        }
        return this.params;
    }

    public String getSupportedSince() {
        return this.since;
    }

    public boolean isAvailable() {
        return this.isAvail;
    }

    private boolean x_isAvailable() {
        if (ELGAMAL_2048 == this) {
            return true;
        }
        try {
            this.getParams();
        }
        catch (InvalidParameterSpecException e) {
            return false;
        }
        return true;
    }

    public static boolean isAvailable(int code) {
        EncType type = EncType.getByCode(code);
        if (type == null) {
            return false;
        }
        return type.isAvailable();
    }

    public static boolean isAvailable(String stype) {
        EncType type = EncType.parseEncType(stype);
        if (type == null) {
            return false;
        }
        return type.isAvailable();
    }

    public static EncType getByCode(int code) {
        return BY_CODE.get(code);
    }

    public static EncType parseEncType(String stype) {
        try {
            String uc = stype.toUpperCase(Locale.US);
            return EncType.valueOf(uc);
        }
        catch (IllegalArgumentException iae) {
            try {
                int code = Integer.parseInt(stype);
                return EncType.getByCode(code);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    static {
        BY_CODE = new HashMap<Integer, EncType>();
        for (EncType type : EncType.values()) {
            if (BY_CODE.put(type.getCode(), type) == null) continue;
            throw new IllegalStateException("Duplicate EncType code");
        }
    }
}

