/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public class CertUtil {
    private static final int LINE_LENGTH = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveCert(Certificate cert, File file) {
        SecureFileOutputStream os = null;
        try {
            os = new SecureFileOutputStream(file);
            CertUtil.exportCert(cert, os);
            boolean bl = true;
            return bl;
        }
        catch (CertificateEncodingException cee) {
            CertUtil.error("Error writing X509 Certificate " + file.getAbsolutePath(), cee);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            CertUtil.error("Error writing X509 Certificate " + file.getAbsolutePath(), ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void exportPrivateKey(PrivateKey pk, Certificate[] certs, OutputStream out) throws IOException, GeneralSecurityException {
        CertUtil.exportPrivateKey(pk, out);
        if (certs == null) {
            return;
        }
        for (int i = 0; i < certs.length; ++i) {
            CertUtil.exportCert(certs[i], out);
        }
    }

    private static void exportCert(Certificate cert, OutputStream out) throws IOException, CertificateEncodingException {
        byte[] buf = cert.getEncoded();
        PrintWriter wr = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        wr.println("-----BEGIN CERTIFICATE-----");
        String b64 = Base64.encode(buf, true);
        for (int i = 0; i < b64.length(); i += 64) {
            wr.println(b64.substring(i, Math.min(i + 64, b64.length())));
        }
        wr.println("-----END CERTIFICATE-----");
        wr.flush();
        if (wr.checkError()) {
            throw new IOException("Failed write to " + out);
        }
    }

    private static void exportPrivateKey(PrivateKey pk, OutputStream out) throws IOException, InvalidKeyException {
        byte[] buf = pk.getEncoded();
        if (buf == null) {
            throw new InvalidKeyException("encoding unsupported for this key");
        }
        PrintWriter wr = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        wr.println("-----BEGIN PRIVATE KEY-----");
        String b64 = Base64.encode(buf, true);
        for (int i = 0; i < b64.length(); i += 64) {
            wr.println(b64.substring(i, Math.min(i + 64, b64.length())));
        }
        wr.println("-----END PRIVATE KEY-----");
        wr.flush();
        if (wr.checkError()) {
            throw new IOException("Failed write to " + out);
        }
    }

    public static String getSubjectValue(X509Certificate cert, String type) {
        X500Principal p = cert.getSubjectX500Principal();
        return CertUtil.getValue(p, type);
    }

    public static String getIssuerValue(X509Certificate cert, String type) {
        X500Principal p = cert.getIssuerX500Principal();
        return CertUtil.getValue(p, type);
    }

    private static String getValue(X500Principal p, String type) {
        if (SystemVersion.isAndroid()) {
            CertUtil.error("Don't call this in Android", new UnsupportedOperationException("I did it"));
            return null;
        }
        if (p == null) {
            return null;
        }
        type = type.toUpperCase(Locale.US);
        String subj = p.getName();
        try {
            LdapName name = new LdapName(subj);
            for (Rdn rdn : name.getRdns()) {
                if (!type.equals(rdn.getType().toUpperCase(Locale.US))) continue;
                return (String)rdn.getValue();
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return null;
    }

    private static void error(String msg, Throwable t) {
        CertUtil.log(I2PAppContext.getGlobalContext(), 40, msg, t);
    }

    private static void log(I2PAppContext ctx, int level, String msg, Throwable t) {
        Log l = ctx.logManager().getLog(CertUtil.class);
        l.log(level, msg, t);
    }

    public static PublicKey loadKey(File kd) throws IOException, GeneralSecurityException {
        return CertUtil.loadCert(kd).getPublicKey();
    }

    public static X509Certificate loadCert(File kd) throws IOException, GeneralSecurityException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(kd);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
            cert.checkValidity();
            X509Certificate x509Certificate = cert;
            return x509Certificate;
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException("cert error", iae);
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

