/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.CPUInformation;

import freenet.support.CPUInformation.AMDCPUInfo;
import freenet.support.CPUInformation.AMDInfoImpl;
import freenet.support.CPUInformation.CPUInfo;
import freenet.support.CPUInformation.IntelCPUInfo;
import freenet.support.CPUInformation.IntelInfoImpl;
import freenet.support.CPUInformation.UnknownCPUException;
import freenet.support.CPUInformation.VIAInfoImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.util.FileUtil;
import net.i2p.util.SystemVersion;

public class CPUID {
    private static boolean _nativeOk = false;
    private static boolean _doLog = System.getProperty("jcpuid.dontLog") == null && I2PAppContext.getGlobalContext().isRouterContext();
    private static final boolean isX86 = System.getProperty("os.arch").contains("86") || System.getProperty("os.arch").equals("amd64");
    private static final boolean isWindows = SystemVersion.isWindows();
    private static final String libPrefix = isWindows ? "" : "lib";
    private static final String libSuffix = isWindows ? ".dll" : ".so";
    private static final boolean isLinux = System.getProperty("os.name").toLowerCase(Locale.US).contains("linux");
    private static final boolean isKFreebsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("kfreebsd");
    private static final boolean isFreebsd = !isKFreebsd && System.getProperty("os.name").toLowerCase(Locale.US).contains("freebsd");
    private static final boolean isNetbsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("netbsd");
    private static final boolean isOpenbsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("openbsd");
    private static final boolean isSunos = System.getProperty("os.name").toLowerCase(Locale.US).contains("sunos");
    private static final boolean isMac = SystemVersion.isMac();
    private static final boolean is64 = SystemVersion.is64Bit();

    private static native CPUIDResult doCPUID(int var0);

    static String getCPUVendorID() {
        CPUIDResult c = CPUID.doCPUID(0);
        StringBuilder sb = new StringBuilder(13);
        sb.append((char)(c.EBX & 0xFF));
        sb.append((char)(c.EBX >> 8 & 0xFF));
        sb.append((char)(c.EBX >> 16 & 0xFF));
        sb.append((char)(c.EBX >> 24 & 0xFF));
        sb.append((char)(c.EDX & 0xFF));
        sb.append((char)(c.EDX >> 8 & 0xFF));
        sb.append((char)(c.EDX >> 16 & 0xFF));
        sb.append((char)(c.EDX >> 24 & 0xFF));
        sb.append((char)(c.ECX & 0xFF));
        sb.append((char)(c.ECX >> 8 & 0xFF));
        sb.append((char)(c.ECX >> 16 & 0xFF));
        sb.append((char)(c.ECX >> 24 & 0xFF));
        return sb.toString();
    }

    static int getCPUFamily() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 8 & 0xF;
    }

    static int getCPUModel() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 4 & 0xF;
    }

    static int getCPUExtendedModel() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 16 & 0xF;
    }

    static int getCPUType() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 12 & 0xF;
    }

    static int getCPUExtendedFamily() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 20 & 0xFF;
    }

    static int getCPUStepping() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX & 0xF;
    }

    static int getEDXCPUFlags() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EDX;
    }

    static int getECXCPUFlags() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.ECX;
    }

    static int getExtendedEBXCPUFlags() {
        CPUIDResult c = CPUID.doCPUID(-2147483647);
        return c.EBX;
    }

    static int getExtendedECXCPUFlags() {
        CPUIDResult c = CPUID.doCPUID(-2147483647);
        return c.ECX;
    }

    static int getExtendedEDXCPUFlags() {
        CPUIDResult c = CPUID.doCPUID(-2147483647);
        return c.EDX;
    }

    static String getCPUModelName() {
        CPUIDResult c = CPUID.doCPUID(Integer.MIN_VALUE);
        long maxSupported = (long)c.EAX & 0xFFFFFFFFL;
        if (maxSupported < 0x80000004L) {
            return null;
        }
        StringBuilder buf = new StringBuilder(48);
        int[] regs = new int[4];
        for (int fn = -2147483646; fn <= -2147483644; ++fn) {
            c = CPUID.doCPUID(fn);
            regs[0] = c.EAX;
            regs[1] = c.EBX;
            regs[2] = c.ECX;
            regs[3] = c.EDX;
            for (int i = 0; i < 4; ++i) {
                int reg = regs[i];
                for (int j = 0; j < 4; ++j) {
                    char ch = (char)(reg & 0xFF);
                    if (ch == '\u0000') {
                        return buf.toString().trim();
                    }
                    buf.append(ch);
                    reg >>= 8;
                }
            }
        }
        return buf.toString().trim();
    }

    public static CPUInfo getInfo() throws UnknownCPUException {
        if (!_nativeOk) {
            throw new UnknownCPUException("Failed to read CPU information from the system. Please verify the existence of the jcpuid dll/so.");
        }
        if (CPUID.getCPUVendorID().equals("CentaurHauls")) {
            return new VIAInfoImpl();
        }
        if (!isX86) {
            throw new UnknownCPUException("Failed to read CPU information from the system. The CPUID instruction exists on x86 CPU's only");
        }
        if (CPUID.getCPUVendorID().equals("AuthenticAMD")) {
            return new AMDInfoImpl();
        }
        if (CPUID.getCPUVendorID().equals("GenuineIntel")) {
            return new IntelInfoImpl();
        }
        throw new UnknownCPUException("Unknown CPU type: '" + CPUID.getCPUVendorID() + "'");
    }

    public static void main(String[] args) {
        _doLog = true;
        if (!_nativeOk) {
            System.out.println("**Failed to retrieve CPUInfo. Please verify the existence of jcpuid dll/so**");
        }
        System.out.println(" **CPUInfo**");
        String mname = CPUID.getCPUModelName();
        if (mname != null) {
            System.out.println("CPU Model Name: " + mname);
        }
        String vendor = CPUID.getCPUVendorID();
        System.out.println("CPU Vendor: " + vendor);
        int family = CPUID.getCPUFamily();
        int model = CPUID.getCPUModel();
        if (family == 15 || family == 6 && "GenuineIntel".equals(vendor)) {
            model += CPUID.getCPUExtendedModel() << 4;
        }
        if (family == 15) {
            family += CPUID.getCPUExtendedFamily();
        }
        System.out.println("CPU Family: " + family);
        System.out.println("CPU Model: " + model);
        System.out.println("CPU Stepping: " + CPUID.getCPUStepping());
        System.out.println("CPU Flags: 0x" + Integer.toHexString(CPUID.getEDXCPUFlags()));
        CPUInfo c = CPUID.getInfo();
        System.out.println("\n **More CPUInfo**");
        System.out.println("CPU model string: " + c.getCPUModelString());
        System.out.println("CPU has MMX: " + c.hasMMX());
        System.out.println("CPU has SSE: " + c.hasSSE());
        System.out.println("CPU has SSE2: " + c.hasSSE2());
        System.out.println("CPU has SSE3: " + c.hasSSE3());
        System.out.println("CPU has SSE4.1: " + c.hasSSE41());
        System.out.println("CPU has SSE4.2: " + c.hasSSE42());
        System.out.println("CPU has SSE4A: " + c.hasSSE4A());
        System.out.println("CPU has AES-NI: " + c.hasAES());
        if (c instanceof IntelCPUInfo) {
            System.out.println("\n **Intel-info**");
            System.out.println("Is PII-compatible: " + ((IntelCPUInfo)c).IsPentium2Compatible());
            System.out.println("Is PIII-compatible: " + ((IntelCPUInfo)c).IsPentium3Compatible());
            System.out.println("Is PIV-compatible: " + ((IntelCPUInfo)c).IsPentium4Compatible());
            System.out.println("Is Atom-compatible: " + ((IntelCPUInfo)c).IsAtomCompatible());
            System.out.println("Is Pentium M compatible: " + ((IntelCPUInfo)c).IsPentiumMCompatible());
            System.out.println("Is Core2-compatible: " + ((IntelCPUInfo)c).IsCore2Compatible());
            System.out.println("Is Corei-compatible: " + ((IntelCPUInfo)c).IsCoreiCompatible());
        }
        if (c instanceof AMDCPUInfo) {
            System.out.println("\n **AMD-info**");
            System.out.println("Is K6-compatible: " + ((AMDCPUInfo)c).IsK6Compatible());
            System.out.println("Is K6_2-compatible: " + ((AMDCPUInfo)c).IsK6_2_Compatible());
            System.out.println("Is K6_3-compatible: " + ((AMDCPUInfo)c).IsK6_3_Compatible());
            System.out.println("Is K6-compatible: " + ((AMDCPUInfo)c).IsGeodeCompatible());
            System.out.println("Is Athlon-compatible: " + ((AMDCPUInfo)c).IsAthlonCompatible());
            System.out.println("Is Athlon64-compatible: " + ((AMDCPUInfo)c).IsAthlon64Compatible());
            System.out.println("Is Bobcat-compatible: " + ((AMDCPUInfo)c).IsBobcatCompatible());
        }
    }

    private static final void loadNative() {
        block12: {
            try {
                String wantedProp = System.getProperty("jcpuid.enable", "true");
                boolean wantNative = Boolean.parseBoolean(wantedProp);
                if (wantNative) {
                    boolean loaded = CPUID.loadGeneric();
                    if (loaded) {
                        _nativeOk = true;
                        if (_doLog) {
                            System.err.println("INFO: Native CPUID library " + CPUID.getLibraryMiddlePart() + " loaded from file");
                        }
                    } else {
                        loaded = CPUID.loadFromResource();
                        if (loaded) {
                            _nativeOk = true;
                            if (_doLog) {
                                System.err.println("INFO: Native CPUID library " + CPUID.getResourceName() + " loaded from resource");
                            }
                        } else {
                            _nativeOk = false;
                            if (_doLog) {
                                System.err.println("WARNING: Native CPUID library jcpuid not loaded - will not be able to read CPU information using CPUID");
                            }
                        }
                    }
                } else if (_doLog) {
                    System.err.println("INFO: Native CPUID library jcpuid not loaded - will not be able to read CPU information using CPUID");
                }
            }
            catch (Exception e) {
                if (!_doLog) break block12;
                System.err.println("INFO: Native CPUID library jcpuid not loaded, reason: '" + e.getMessage() + "' - will not be able to read CPU information using CPUID");
            }
        }
    }

    private static final boolean loadGeneric() {
        try {
            System.loadLibrary("jcpuid");
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    private static final boolean loadFromResource() {
        boolean success;
        String resourceName = CPUID.getResourceName64();
        if (resourceName != null && (success = CPUID.extractLoadAndCopy(resourceName))) {
            return true;
        }
        resourceName = CPUID.getResourceName();
        success = CPUID.extractLoadAndCopy(resourceName);
        if (success) {
            return true;
        }
        if (_doLog) {
            System.err.println("WARNING: Resource name [" + resourceName + "] was not found");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean extractLoadAndCopy(String resourceName) {
        URL resource = CPUID.class.getClassLoader().getResource(resourceName);
        if (resource == null) {
            return false;
        }
        File outFile = null;
        FileOutputStream fos = null;
        String filename = libPrefix + "jcpuid" + libSuffix;
        try {
            int read;
            InputStream libStream = resource.openStream();
            outFile = new File(I2PAppContext.getGlobalContext().getTempDir(), filename);
            fos = new FileOutputStream(outFile);
            byte[] buf = new byte[4096];
            while ((read = libStream.read(buf)) >= 0) {
                fos.write(buf, 0, read);
            }
            fos.close();
            fos = null;
            System.load(outFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError ule) {
            if (_doLog) {
                System.err.println("WARNING: The resource " + resourceName + " was not a valid library for this platform " + ule);
            }
            if (outFile != null) {
                outFile.delete();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            if (_doLog) {
                System.err.println("ERROR: Problem writing out the temporary native library data");
                ioe.printStackTrace();
            }
            if (outFile != null) {
                outFile.delete();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        File newFile = new File(I2PAppContext.getGlobalContext().getBaseDir(), filename);
        FileUtil.copy(outFile, newFile, false, true);
        return true;
    }

    private static final String getResourceName() {
        return CPUID.getLibraryPrefix() + CPUID.getLibraryMiddlePart() + "." + CPUID.getLibrarySuffix();
    }

    private static final String getResourceName64() {
        if (!is64) {
            return null;
        }
        return CPUID.getLibraryPrefix() + CPUID.get64LibraryMiddlePart() + "." + CPUID.getLibrarySuffix();
    }

    private static final String getLibraryPrefix() {
        if (isWindows) {
            return "";
        }
        return "lib";
    }

    private static final String getLibraryMiddlePart() {
        if (isWindows) {
            return "jcpuid-x86-windows";
        }
        if (isMac && isX86) {
            return "jcpuid-x86-osx";
        }
        if (isKFreebsd) {
            return "jcpuid-x86-kfreebsd";
        }
        if (isFreebsd) {
            return "jcpuid-x86-freebsd";
        }
        if (isNetbsd) {
            return "jcpuid-x86-netbsd";
        }
        if (isOpenbsd) {
            return "jcpuid-x86-openbsd";
        }
        if (isSunos) {
            return "jcpuid-x86-solaris";
        }
        return "jcpuid-x86-linux";
    }

    private static final String get64LibraryMiddlePart() {
        if (isWindows) {
            return "jcpuid-x86_64-windows";
        }
        if (isKFreebsd) {
            return "jcpuid-x86_64-kfreebsd";
        }
        if (isFreebsd) {
            return "jcpuid-x86_64-freebsd";
        }
        if (isNetbsd) {
            return "jcpuid-x86_64-netbsd";
        }
        if (isOpenbsd) {
            return "jcpuid-x86_64-openbsd";
        }
        if (isMac && isX86) {
            return "jcpuid-x86_64-osx";
        }
        if (isSunos) {
            return "jcpuid-x86_64-solaris";
        }
        return "jcpuid-x86_64-linux";
    }

    private static final String getLibrarySuffix() {
        if (isWindows) {
            return "dll";
        }
        if (isMac) {
            return "jnilib";
        }
        return "so";
    }

    static {
        CPUID.loadNative();
    }

    protected static class CPUIDResult {
        final int EAX;
        final int EBX;
        final int ECX;
        final int EDX;

        CPUIDResult(int EAX, int EBX, int ECX, int EDX) {
            this.EAX = EAX;
            this.EBX = EBX;
            this.ECX = ECX;
            this.EDX = EDX;
        }
    }
}

