/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.concurrent.atomic.AtomicInteger;

public class ByteArrayPool {
    public static final int __POOL_SIZE = Integer.getInteger("org.mortbay.util.ByteArrayPool.pool_size", 8);
    public static final ThreadLocal<byte[][]> __pools = new BAThreadLocal();
    public static final AtomicInteger __slot = new AtomicInteger();

    public static byte[] getByteArray(int size) {
        byte[][] pool = __pools.get();
        boolean full = true;
        int i = pool.length;
        while (i-- > 0) {
            if (pool[i] != null && pool[i].length == size) {
                byte[] b = pool[i];
                pool[i] = null;
                return b;
            }
            full = false;
        }
        if (full) {
            i = pool.length;
            while (i-- > 0) {
                pool[i] = null;
            }
        }
        return new byte[size];
    }

    public static byte[] getByteArrayAtLeast(int minSize) {
        byte[][] pool = __pools.get();
        int i = pool.length;
        while (i-- > 0) {
            if (pool[i] == null || pool[i].length < minSize) continue;
            byte[] b = pool[i];
            pool[i] = null;
            return b;
        }
        return new byte[minSize];
    }

    public static void returnByteArray(byte[] b) {
        if (b == null) {
            return;
        }
        byte[][] pool = __pools.get();
        int i = pool.length;
        while (i-- > 0) {
            if (pool[i] != null) continue;
            pool[i] = b;
            return;
        }
        int s = __slot.getAndIncrement();
        if (s < 0) {
            s = -s;
        }
        pool[s % pool.length] = b;
    }

    private static final class BAThreadLocal
    extends ThreadLocal<byte[][]> {
        private BAThreadLocal() {
        }

        @Override
        protected byte[][] initialValue() {
            return new byte[__POOL_SIZE][];
        }
    }
}

