/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NetDbRenderer;
import net.i2p.router.web.SybilRenderer;

public class NetDbHelper
extends HelperBase {
    private String _routerPrefix;
    private String _version;
    private String _country;
    private int _full;
    private boolean _lease;
    private boolean _debug;
    private boolean _graphical;
    private static final String[] titles = new String[]{NetDbHelper._x("Summary"), NetDbHelper._x("Local Router"), NetDbHelper._x("Router Lookup"), NetDbHelper._x("All Routers"), NetDbHelper._x("All Routers with Full Stats"), "LeaseSet Debug", NetDbHelper._x("LeaseSets"), "Sybil"};
    private static final String[] links = new String[]{"", "?r=.", "", "?f=2", "?f=1", "?l=2", "?l=1", "?f=3"};

    public void setRouter(String r) {
        if (r != null) {
            this._routerPrefix = DataHelper.stripHTML(r);
        }
    }

    public void setVersion(String v) {
        if (v != null) {
            this._version = DataHelper.stripHTML(v);
        }
    }

    public void setCountry(String c) {
        if (c != null) {
            this._country = DataHelper.stripHTML(c);
        }
    }

    public void setFull(String f) {
        try {
            this._full = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setLease(String l) {
        this._debug = "2".equals(l);
        this._lease = this._debug || "1".equals(l);
    }

    public void allowGraphical() {
        this._graphical = true;
    }

    public String getNetDbSummary() {
        NetDbRenderer renderer = new NetDbRenderer(this._context);
        try {
            this.renderNavBar();
            if (this._routerPrefix != null || this._version != null || this._country != null) {
                renderer.renderRouterInfoHTML(this._out, this._routerPrefix, this._version, this._country);
            } else if (this._lease) {
                renderer.renderLeaseSetHTML(this._out, this._debug);
            } else if (this._full == 3) {
                new SybilRenderer(this._context).getNetDbSummary(this._out);
            } else {
                renderer.renderStatusHTML(this._out, this._full);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private int getTab() {
        if (this._debug) {
            return 5;
        }
        if (this._lease) {
            return 6;
        }
        if (".".equals(this._routerPrefix)) {
            return 1;
        }
        if (this._routerPrefix != null) {
            return 2;
        }
        if (this._full == 2) {
            return 3;
        }
        if (this._full == 1) {
            return 4;
        }
        if (this._full == 3) {
            return 7;
        }
        return 0;
    }

    private void renderNavBar() throws IOException {
        boolean span;
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<div class=\"confignav\" id=\"confignav\">");
        String theme = this._context.getProperty("routerconsole.theme");
        boolean bl = span = this._graphical && (theme == null || theme.equals("light"));
        if (!span) {
            buf.append("<center>");
        }
        int tab = this.getTab();
        for (int i = 0; i < titles.length; ++i) {
            if (i == 2 && tab != 2 || (i == 5 || i == 7) && !this._context.getBooleanProperty("routerconsole.advanced")) continue;
            if (i == tab) {
                if (span) {
                    buf.append("<span class=\"tab2\">");
                }
                buf.append(this._t(titles[i]));
            } else {
                if (span) {
                    buf.append("<span class=\"tab\">");
                }
                buf.append("<a href=\"netdb").append(links[i]).append("\">").append(this._t(titles[i])).append("</a>");
            }
            if (span) {
                buf.append(" </span>\n");
                continue;
            }
            if (i == titles.length - 1) continue;
            buf.append(" |\n");
        }
        if (!span) {
            buf.append("</center>");
        }
        buf.append("</div>");
        this._out.write(buf.toString());
    }
}

