/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SigType;
import net.i2p.router.web.HelperBase;
import net.i2p.util.FileUtil;
import net.i2p.util.VersionComparator;
import org.eclipse.jetty.server.Server;
import org.tanukisoftware.wrapper.WrapperManager;

public class LogsHelper
extends HelperBase {
    private static final String LOCATION_AVAILABLE = "3.3.7";
    private static final String NL = System.getProperty("line.separator");

    public String getJettyVersion() {
        return Server.getVersion();
    }

    public static String jettyVersion() {
        return Server.getVersion();
    }

    public String getUnavailableCrypto() {
        StringBuilder buf = new StringBuilder(128);
        for (SigType t : SigType.values()) {
            if (t.isAvailable()) continue;
            buf.append("<b>Crypto:</b> ").append(t.toString()).append(" unavailable<br>");
        }
        return buf.toString();
    }

    public String getLogs() {
        String str = this.formatMessages(this._context.logManager().getBuffer().getMostRecentMessages());
        return "<p>" + this._t("File location") + ": <b><code>" + this._context.logManager().currentFile() + "</code></b></p>" + str;
    }

    public String getCriticalLogs() {
        this._context.logManager().flush();
        return this.formatMessages(this._context.logManager().getBuffer().getMostRecentCriticalMessages());
    }

    static File wrapperLogFile(I2PAppContext ctx) {
        String wv;
        File f = null;
        if (ctx.hasWrapper() && (wv = System.getProperty("wrapper.version")) != null && VersionComparator.comp(wv, LOCATION_AVAILABLE) >= 0) {
            try {
                f = WrapperManager.getWrapperLogFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (f == null || !f.exists()) {
            String path = System.getProperty("wrapper.logfile");
            if (path != null) {
                f = new File(path);
            } else {
                f = new File(System.getProperty("java.io.tmpdir"), "wrapper.log");
                if (!f.exists()) {
                    f = new File(ctx.getBaseDir(), "wrapper.log");
                }
            }
        }
        return f;
    }

    public String getServiceLogs() {
        File f = LogsHelper.wrapperLogFile(this._context);
        String str = this._context.hasWrapper() ? LogsHelper.readTextFile(f, 250) : FileUtil.readTextFile(f.getAbsolutePath(), 250, false);
        if (str == null) {
            return "<p>" + this._t("File not found") + ": <b><code>" + f.getAbsolutePath() + "</code></b></p>";
        }
        str = str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        return "<p>" + this._t("File location") + ": <b><code>" + f.getAbsolutePath() + "</code></b></p><pre>" + str + "</pre>";
    }

    private String formatMessages(List<String> msgs) {
        if (msgs.isEmpty()) {
            return "<p><i>" + this._t("No log messages") + "</i></p>";
        }
        boolean colorize = this._context.getBooleanPropertyDefaultTrue("routerconsole.logs.color");
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<ul>");
        for (int i = msgs.size() - 1; i >= 0; --i) {
            String msg = msgs.get(i);
            if (i == 0 && msg.contains("&darr;")) break;
            msg = msg.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            if ((msg = msg.replace("&amp;darr;", "&darr;")).endsWith(NL)) {
                msg = msg.substring(0, msg.length() - NL.length());
            }
            msg = msg.replace("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;\n");
            buf.append("<li>");
            if (colorize) {
                String color = msg.contains(this._t("CRIT")) ? "#cc0000" : (msg.contains(this._t("ERROR")) ? "#ff3300" : (msg.contains(this._t("WARN")) ? "#ff00cc" : (msg.contains(this._t("INFO")) ? "#000099" : "#006600")));
                buf.append("<font color=\"").append(color).append("\">");
                buf.append(msg);
                buf.append("</font>");
            } else {
                buf.append(msg);
            }
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readTextFile(File f, int maxNumLines) {
        if (!f.exists()) {
            return null;
        }
        FileInputStream fis = null;
        BufferedReader in = null;
        try {
            fis = new FileInputStream(f);
            in = new BufferedReader(new InputStreamReader(fis));
            ArrayList<String> lines = new ArrayList<String>(maxNumLines);
            String line = null;
            while ((line = in.readLine()) != null) {
                lines.add(line);
                if (lines.size() < maxNumLines) continue;
                lines.remove(0);
            }
            StringBuilder buf = new StringBuilder(lines.size() * 80);
            for (int i = 0; i < lines.size(); ++i) {
                buf.append((String)lines.get(i)).append('\n');
            }
            String string = buf.toString();
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

