/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.i2p.data.DataHelper;
import net.i2p.router.Job;
import net.i2p.router.JobStats;
import net.i2p.router.web.HelperBase;
import net.i2p.util.ObjectCounter;

public class JobQueueHelper
extends HelperBase {
    private static final int MAX_JOBS = 50;

    public String getJobQueueSummary() {
        try {
            if (this._out != null) {
                this.renderStatusHTML(this._out);
                return "";
            }
            StringWriter sw = new StringWriter(32768);
            this.renderStatusHTML(sw);
            return sw.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }

    private void renderStatusHTML(Writer out) throws IOException {
        Job j;
        int i;
        ArrayList<Job> readyJobs = new ArrayList<Job>(8);
        ArrayList<Job> timedJobs = new ArrayList<Job>(128);
        ArrayList<Job> activeJobs = new ArrayList<Job>(8);
        ArrayList<Job> justFinishedJobs = new ArrayList<Job>(8);
        int numRunners = this._context.jobQueue().getJobs(readyJobs, timedJobs, activeJobs, justFinishedJobs);
        StringBuilder buf = new StringBuilder(32768);
        buf.append("<b><div class=\"joblog\"><h3>").append(this._t("I2P Job Queue")).append("</h3><br><div class=\"wideload\">").append(this._t("Job runners")).append(": ").append(numRunners).append("</b><br>\n");
        long now = this._context.clock().now();
        buf.append("<hr><b>").append(this._t("Active jobs")).append(": ").append(activeJobs.size()).append("</b><ol>\n");
        for (i = 0; i < activeJobs.size(); ++i) {
            j = (Job)activeJobs.get(i);
            buf.append("<li>(").append(this._t("started {0} ago", DataHelper.formatDuration2(now - j.getTiming().getStartAfter()))).append("): ");
            buf.append(j.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        buf.append("<hr><b>").append(this._t("Just finished jobs")).append(": ").append(justFinishedJobs.size()).append("</b><ol>\n");
        for (i = 0; i < justFinishedJobs.size(); ++i) {
            j = (Job)justFinishedJobs.get(i);
            buf.append("<li>(").append(this._t("finished {0} ago", DataHelper.formatDuration2(now - j.getTiming().getActualEnd()))).append("): ");
            buf.append(j.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        buf.append("<hr><b>").append(this._t("Ready/waiting jobs")).append(": ").append(readyJobs.size()).append("</b><ol>\n");
        ObjectCounter<String> counter = new ObjectCounter<String>();
        for (int i2 = 0; i2 < readyJobs.size(); ++i2) {
            Job j2 = (Job)readyJobs.get(i2);
            counter.increment(j2.getName());
            if (i2 >= 50) continue;
            buf.append("<li>[waiting ");
            buf.append(DataHelper.formatDuration2(now - j2.getTiming().getStartAfter()));
            buf.append("]: ");
            buf.append(j2.toString()).append("</li>\n");
        }
        buf.append("</ol>\n");
        this.getJobCounts(buf, counter);
        out.write(buf.toString());
        buf.setLength(0);
        buf.append("<hr><b>").append(this._t("Scheduled jobs")).append(": ").append(timedJobs.size()).append("</b><ol>\n");
        long prev = Long.MIN_VALUE;
        counter.clear();
        for (int i3 = 0; i3 < timedJobs.size(); ++i3) {
            Job j3 = (Job)timedJobs.get(i3);
            counter.increment(j3.getName());
            if (i3 >= 50) continue;
            long time = j3.getTiming().getStartAfter() - now;
            buf.append("<li>").append(this._t("{0} will start in {1}", j3.getName(), DataHelper.formatDuration2(time)));
            if (time < 0L) {
                buf.append(" <b>DELAYED</b>");
            }
            if (time < prev) {
                buf.append(" <b>** OUT OF ORDER **</b>");
            }
            prev = time;
            buf.append("</li>\n");
        }
        buf.append("</ol></div>\n");
        this.getJobCounts(buf, counter);
        out.write(buf.toString());
        buf.setLength(0);
        buf.append("<hr><b>").append(this._t("Total Job Statistics")).append("</b>\n");
        this.getJobStats(buf);
        out.write(buf.toString());
    }

    private void getJobCounts(StringBuilder buf, ObjectCounter<String> counter) {
        ArrayList<String> names = new ArrayList<String>(counter.objects());
        if (names.size() < 4) {
            return;
        }
        buf.append("<table style=\"width: 30%; margin-left: 100px;\">\n<tr><th>").append(this._t("Job")).append("</th><th>").append(this._t("Queued")).append("<th>");
        Collections.sort(names, new JobCountComparator(counter));
        for (String name : names) {
            buf.append("<tr><td>").append(name).append("</td><td align=\"center\">").append(counter.count(name)).append("</td></tr>\n");
        }
        buf.append("</table>\n");
    }

    private void getJobStats(StringBuilder buf) {
        buf.append("<table>\n<tr><th>").append(this._t("Job")).append("</th><th>").append(this._t("Runs")).append("</th><th>").append(this._t("Dropped")).append("</th><th>").append(this._t("Time")).append("</th><th><i>").append(this._t("Avg")).append("</i></th><th><i>").append(this._t("Max")).append("</i></th><th><i>").append(this._t("Min")).append("</i></th><th>").append(this._t("Pending")).append("</th><th><i>").append(this._t("Avg")).append("</i></th><th><i>").append(this._t("Max")).append("</i></th><th><i>").append(this._t("Min")).append("</i></th></tr>\n");
        long totRuns = 0L;
        long totDropped = 0L;
        long totExecTime = 0L;
        long avgExecTime = 0L;
        long maxExecTime = -1L;
        long minExecTime = -1L;
        long totPendingTime = 0L;
        long avgPendingTime = 0L;
        long maxPendingTime = -1L;
        long minPendingTime = -1L;
        ArrayList<JobStats> tstats = new ArrayList<JobStats>(this._context.jobQueue().getJobStats());
        Collections.sort(tstats, new JobStatsComparator());
        for (JobStats stats : tstats) {
            buf.append("<tr>");
            buf.append("<td><b>").append(stats.getName()).append("</b></td>");
            buf.append("<td align=\"right\">").append(stats.getRuns()).append("</td>");
            buf.append("<td align=\"right\">").append(stats.getDropped()).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getTotalTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getAvgTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getMaxTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getMinTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getTotalPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getAvgPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getMaxPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(stats.getMinPendingTime())).append("</td>");
            buf.append("</tr>\n");
            totRuns += stats.getRuns();
            totDropped += stats.getDropped();
            totExecTime += stats.getTotalTime();
            if (stats.getMaxTime() > maxExecTime) {
                maxExecTime = stats.getMaxTime();
            }
            if (minExecTime < 0L || minExecTime > stats.getMinTime()) {
                minExecTime = stats.getMinTime();
            }
            totPendingTime += stats.getTotalPendingTime();
            if (stats.getMaxPendingTime() > maxPendingTime) {
                maxPendingTime = stats.getMaxPendingTime();
            }
            if (minPendingTime >= 0L && minPendingTime <= stats.getMinPendingTime()) continue;
            minPendingTime = stats.getMinPendingTime();
        }
        if (totRuns != 0L) {
            if (totExecTime != 0L) {
                avgExecTime = totExecTime / totRuns;
            }
            if (totPendingTime != 0L) {
                avgPendingTime = totPendingTime / totRuns;
            }
        }
        buf.append("<tr class=\"tablefooter\">");
        buf.append("<td><b>").append(this._t("Summary")).append("</b></td>");
        buf.append("<td align=\"right\">").append(totRuns).append("</td>");
        buf.append("<td align=\"right\">").append(totDropped).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(totExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(avgExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(maxExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(minExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(totPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(avgPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(maxPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2(minPendingTime)).append("</td>");
        buf.append("</tr></table></div>\n");
    }

    private static class JobCountComparator
    implements Comparator<String>,
    Serializable {
        private final ObjectCounter<String> _counter;

        public JobCountComparator(ObjectCounter<String> counter) {
            this._counter = counter;
        }

        @Override
        public int compare(String l, String r) {
            int rc;
            int lc = this._counter.count(l);
            if (lc > (rc = this._counter.count(r))) {
                return -1;
            }
            if (lc < rc) {
                return 1;
            }
            return l.compareTo(r);
        }
    }

    private static class JobStatsComparator
    implements Comparator<JobStats>,
    Serializable {
        private JobStatsComparator() {
        }

        @Override
        public int compare(JobStats l, JobStats r) {
            return l.getName().compareTo(r.getName());
        }
    }
}

