/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.web.FormHandler;

public class ConfigAdvancedHandler
extends FormHandler {
    private boolean _shouldSave;
    private String _config;
    private String _ff;

    @Override
    protected void processForm() {
        if (this._shouldSave) {
            if ("ff".equals(this._action) && this._ff != null) {
                this.saveFF();
            } else if (this.isAdvanced()) {
                this.saveChanges();
            } else {
                this.addFormError("Save disabled, edit the router.config file to make changes");
            }
        }
    }

    public void setShouldsave(String moo) {
        this._shouldSave = true;
    }

    public void setFf(String ff) {
        this._ff = ff;
    }

    public void setNofilter_config(String val) {
        this._config = val;
    }

    private void saveChanges() {
        HashSet<String> unsetKeys = new HashSet<String>(this._context.router().getConfigSettings());
        if (this._config != null) {
            Properties props = new Properties();
            try {
                DataHelper.loadProps(props, new ByteArrayInputStream(DataHelper.getUTF8(this._config)));
            }
            catch (IOException ioe) {
                this._log.error("Config error", ioe);
                this.addFormError(ioe.toString());
                this.addFormError(this._t("Error updating the configuration - please see the error logs"));
                return;
            }
            for (String key : props.stringPropertyNames()) {
                unsetKeys.remove(key);
            }
            boolean saved = this._context.router().saveConfig(props, unsetKeys);
            if (saved) {
                this.addFormNotice(this._t("Configuration saved successfully"));
            } else {
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
            }
        }
    }

    private void saveFF() {
        boolean saved = this._context.router().saveConfig("router.floodfillParticipant", this._ff);
        if (this._ff.equals("false") || this._ff.equals("true")) {
            FloodfillNetworkDatabaseFacade fndf = (FloodfillNetworkDatabaseFacade)this._context.netDb();
            boolean wasFF = fndf.floodfillEnabled();
            boolean isFF = this._ff.equals("true");
            fndf.setFloodfillEnabled(isFF);
            if (wasFF != isFF) {
                this._context.router().rebuildRouterInfo();
            }
        }
        if (saved) {
            this.addFormNotice(this._t("Configuration saved successfully"));
        } else {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }
}

