/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.Properties;
import net.i2p.data.Hash;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TestJob;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.util.Log;

class PooledTunnelCreatorConfig
extends TunnelCreatorConfig {
    private TunnelPool _pool;
    private TestJob _testJob;

    public PooledTunnelCreatorConfig(RouterContext ctx, int length, boolean isInbound) {
        this(ctx, length, isInbound, null);
    }

    public PooledTunnelCreatorConfig(RouterContext ctx, int length, boolean isInbound, Hash destination) {
        super(ctx, length, isInbound, destination);
    }

    @Override
    public void testSuccessful(int ms) {
        if (this._testJob != null) {
            this._testJob.testSuccessful(ms);
        }
        super.testSuccessful(ms);
    }

    public void testJobSuccessful(int ms) {
        super.testSuccessful(ms);
    }

    @Override
    public boolean tunnelFailed() {
        boolean rv = super.tunnelFailed();
        if (!rv) {
            this._pool.tunnelFailed(this);
            if (this._testJob != null) {
                this._context.jobQueue().removeJob(this._testJob);
            }
        }
        return rv;
    }

    @Override
    public Properties getOptions() {
        if (this._pool == null) {
            return null;
        }
        return this._pool.getSettings().getUnknownOptions();
    }

    public void setTunnelPool(TunnelPool pool) {
        if (pool != null) {
            this._pool = pool;
        } else {
            Log log = this._context.logManager().getLog(this.getClass());
            log.error("Null tunnel pool?", (Throwable)new Exception("foo"));
        }
    }

    public TunnelPool getTunnelPool() {
        return this._pool;
    }

    void setTestJob(TestJob job) {
        this._testJob = job;
    }

    public void setExpireJob(Job job) {
    }

    public void setPairedTunnel(TunnelInfo tunnel) {
    }
}

