/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPSendFinisher;
import net.i2p.router.transport.ntcp.Reader;
import net.i2p.router.transport.ntcp.Writer;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public class NTCPTransport
extends TransportImpl {
    private final Log _log;
    private final SharedBid _fastBid;
    private final SharedBid _slowBid;
    private final SharedBid _slowCostBid;
    private final SharedBid _nearCapacityBid;
    private final SharedBid _nearCapacityCostBid;
    private final SharedBid _transientFail;
    private final Object _conLock;
    private final Map<Hash, NTCPConnection> _conByIdent;
    private final EventPumper _pumper;
    private final Reader _reader;
    private Writer _writer;
    private int _ssuPort;
    private final Set<InetSocketAddress> _endpoints;
    private final Set<NTCPConnection> _establishing;
    private final DecayingBloomFilter _replayFilter;
    private boolean _haveIPv6Address;
    private long _lastInboundIPv4;
    private long _lastInboundIPv6;
    public static final String PROP_I2NP_NTCP_HOSTNAME = "i2np.ntcp.hostname";
    public static final String PROP_I2NP_NTCP_PORT = "i2np.ntcp.port";
    public static final String PROP_I2NP_NTCP_AUTO_PORT = "i2np.ntcp.autoport";
    public static final String PROP_I2NP_NTCP_AUTO_IP = "i2np.ntcp.autoip";
    private static final String PROP_ADVANCED = "routerconsole.advanced";
    public static final int DEFAULT_COST = 10;
    public static final String PROP_BIND_INTERFACE = "i2np.ntcp.bindInterface";
    private final NTCPSendFinisher _finisher;
    private final DHSessionKeyBuilder.Factory _dhFactory;
    private long _lastBadSkew;
    private static final long[] RATES = new long[]{600000L};
    private static final String THINSP = " / ";
    public static final String MIN_SIGTYPE_VERSION = "0.9.16";
    private static final int MIN_CONCURRENT_READERS = 2;
    private static final int MIN_CONCURRENT_WRITERS = 2;
    private static final int MAX_CONCURRENT_READERS = 4;
    private static final int MAX_CONCURRENT_WRITERS = 4;
    public static final int ESTABLISH_TIMEOUT = 10000;
    public static final String STYLE = "NTCP";
    private static final NumberFormat _rateFmt = new DecimalFormat("#,##0.00");

    public NTCPTransport(RouterContext ctx, DHSessionKeyBuilder.Factory dh) {
        super(ctx);
        this._dhFactory = dh;
        this._log = ctx.logManager().getLog(this.getClass());
        this._context.statManager().createRateStat("ntcp.sendTime", "Total message lifetime when sent completely", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.sendQueueSize", "How many messages were ahead of the current one on the connection's queue when it was first added", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveTime", "How long it takes to receive an inbound message", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveSize", "How large the received message was", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.sendBacklogTime", "How long the head of the send queue has been waiting when we fail to add a new one to the queue (period is the number of messages queued)", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeWrites", "How many times do we need to proactively add in an extra nio write to a peer at any given failsafe pass?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeCloses", "How many times do we need to proactively close an idle connection to a peer at any given failsafe pass?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeInvalid", "How many times do we close a connection to a peer to work around a JVM bug?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeThrottle", "Delay event pumper", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.accept", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.attemptBanlistedPeer", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.attemptUnreachablePeer", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.closeOnBacklog", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedTimeout", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedTimeoutIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedUnresolved", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectSuccessful", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptDecryptedI2NP", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPCRC", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPIME", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptMetaCRC", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptTooLargeI2NP", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.dontSendOnBacklog", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundEstablished", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundEstablishedDuplicate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidDH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidHXY", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidHXxorBIH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundDFE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSignature", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSize", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidSignature", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.multipleCloseOnRemove", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.outboundEstablishFailed", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.outboundFailedIOEImmediate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidOutboundSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.noBidTooLargeI2NP", "send size", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.queuedRecv", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.read", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.readError", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveCorruptEstablishment", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveMeta", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.registerConnect", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.replayHXxorBIH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.throttledReadComplete", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.throttledWriteComplete", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.wantsQueuedWrite", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.writeError", "", "ntcp", RATES);
        this._endpoints = new HashSet<InetSocketAddress>(4);
        this._establishing = new ConcurrentHashSet(16);
        this._conLock = new Object();
        this._conByIdent = new ConcurrentHashMap<Hash, NTCPConnection>(64);
        this._replayFilter = new DecayingHashSet(ctx, 600000, 8, "NTCP-Hx^HI");
        this._finisher = new NTCPSendFinisher(ctx, this);
        this._pumper = new EventPumper(ctx, this);
        this._reader = new Reader(ctx);
        this._writer = new Writer(ctx);
        this._fastBid = new SharedBid(25);
        this._slowBid = new SharedBid(70);
        this._slowCostBid = new SharedBid(85);
        this._nearCapacityBid = new SharedBid(90);
        this._nearCapacityCostBid = new SharedBid(105);
        this._transientFail = new SharedBid(999999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTCPConnection inboundEstablished(NTCPConnection con) {
        NTCPConnection old;
        this._context.statManager().addRateData("ntcp.inboundEstablished", 1L);
        Hash peer = con.getRemotePeer().calculateHash();
        this.markReachable(peer, true);
        Object object = this._conLock;
        synchronized (object) {
            old = this._conByIdent.put(peer, con);
        }
        if (con.isIPv6()) {
            this._lastInboundIPv6 = con.getCreated();
        } else {
            this._lastInboundIPv4 = con.getCreated();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void outboundMessageReady() {
        OutNetMessage msg = this.getNextMessage();
        if (msg != null) {
            RouterInfo target = msg.getTarget();
            RouterIdentity ident = target.getIdentity();
            Hash ih = ident.calculateHash();
            NTCPConnection con = null;
            boolean isNew = false;
            boolean fail = false;
            Object object = this._conLock;
            synchronized (object) {
                con = this._conByIdent.get(ih);
                if (con == null) {
                    isNew = true;
                    RouterAddress addr = this.getTargetAddress(target);
                    if (addr != null) {
                        con = new NTCPConnection(this._context, this, ident, addr);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Send on a new con: " + con + " at " + (Object)((Object)addr) + " for " + ih);
                        }
                        this._conByIdent.put(ih, con);
                    } else {
                        fail = true;
                    }
                }
            }
            if (fail) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("we bid on a peer who doesn't have an ntcp address? " + (Object)((Object)target));
                }
                this.afterSend(msg, false);
                return;
            }
            if (isNew) {
                DatabaseStoreMessage dsm;
                con.send(msg);
                boolean shouldSkipInfo = false;
                I2NPMessage m = msg.getMessage();
                if (m.getType() == 1 && (dsm = (DatabaseStoreMessage)m).getKey().equals((Object)this._context.routerHash())) {
                    shouldSkipInfo = true;
                }
                if (!shouldSkipInfo) {
                    con.enqueueInfoMessage();
                } else if (this._log.shouldLog(20)) {
                    this._log.info("SKIPPING INFO message: " + con);
                }
                try {
                    SocketChannel channel = SocketChannel.open();
                    con.setChannel(channel);
                    channel.configureBlocking(false);
                    this._pumper.registerConnect(con);
                    con.getEstablishState().prepareOutbound();
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Error opening a channel", (Throwable)ioe);
                    }
                    this._context.statManager().addRateData("ntcp.outboundFailedIOEImmediate", 1L);
                    con.close();
                }
            } else {
                con.send(msg);
            }
        }
    }

    @Override
    public void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue, long msToSend) {
        super.afterSend(msg, sendSuccessful, allowRequeue, msToSend);
    }

    @Override
    public TransportBid bid(RouterInfo toAddress, long dataSize) {
        String v;
        RouterIdentity id;
        if (!this.isAlive()) {
            return null;
        }
        if (dataSize > 16378L) {
            this._context.statManager().addRateData("ntcp.noBidTooLargeI2NP", dataSize);
            return null;
        }
        Hash peer = toAddress.getIdentity().calculateHash();
        if (this._context.banlist().isBanlisted(peer, STYLE)) {
            this._context.statManager().addRateData("ntcp.attemptBanlistedPeer", 1L);
            return null;
        }
        if (this.isUnreachable(peer)) {
            this._context.statManager().addRateData("ntcp.attemptUnreachablePeer", 1L);
            return null;
        }
        boolean established = this.isEstablished(toAddress.getIdentity());
        if (established) {
            if (this._log.shouldLog(10)) {
                this._log.debug("fast bid when trying to send to " + peer + " as its already established");
            }
            return this._fastBid;
        }
        RouterAddress addr = this.getTargetAddress(toAddress);
        if (addr == null) {
            this.markUnreachable(peer);
            return null;
        }
        SigType type = toAddress.getIdentity().getSigType();
        if (type == null || !type.isAvailable()) {
            this.markUnreachable(peer);
            return null;
        }
        RouterInfo us = this._context.router().getRouterInfo();
        if (us != null && (id = us.getIdentity()).getSigType() != SigType.DSA_SHA1 && VersionComparator.comp((String)(v = toAddress.getVersion()), (String)MIN_SIGTYPE_VERSION) < 0) {
            this.markUnreachable(peer);
            return null;
        }
        if (!this.allowConnection()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("no bid when trying to send to " + peer + ", max connection limit reached");
            }
            return this._transientFail;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("slow bid when trying to send to " + peer);
        }
        if (this.haveCapacity()) {
            if (addr.getCost() > 10) {
                return this._slowCostBid;
            }
            return this._slowBid;
        }
        if (addr.getCost() > 10) {
            return this._nearCapacityCostBid;
        }
        return this._nearCapacityBid;
    }

    private RouterAddress getTargetAddress(RouterInfo target) {
        List<RouterAddress> addrs = this.getTargetAddresses(target);
        for (int i = 0; i < addrs.size(); ++i) {
            RouterAddress addr = addrs.get(i);
            byte[] ip = addr.getIP();
            if (!TransportUtil.isValidPort(addr.getPort()) || ip == null || !this.isValid(ip) && !this._context.getBooleanProperty("i2np.ntcp.allowLocal")) continue;
            return addr;
        }
        return null;
    }

    private boolean isValid(byte[] addr) {
        if (addr == null) {
            return false;
        }
        return this.isPubliclyRoutable(addr) && (addr.length != 16 || this._haveIPv6Address);
    }

    public boolean allowConnection() {
        return this.countActivePeers() < this.getMaxConnections();
    }

    void sendComplete(OutNetMessage msg) {
        this._finisher.add(msg);
    }

    private boolean isEstablished(RouterIdentity peer) {
        return this.isEstablished(peer.calculateHash());
    }

    @Override
    public boolean isEstablished(Hash dest) {
        NTCPConnection con = this._conByIdent.get(dest);
        return con != null && con.isEstablished() && !con.isClosed();
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        NTCPConnection con = this._conByIdent.get(dest);
        return con != null && con.isEstablished() && con.tooBacklogged();
    }

    @Override
    public void mayDisconnect(Hash peer) {
        NTCPConnection con = this._conByIdent.get(peer);
        if (con != null && con.isEstablished() && con.isInbound() && con.getMessagesReceived() <= 2 && con.getMessagesSent() <= 1) {
            con.setMayDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTCPConnection removeCon(NTCPConnection con) {
        NTCPConnection removed = null;
        RouterIdentity ident = con.getRemotePeer();
        if (ident != null) {
            Object object = this._conLock;
            synchronized (object) {
                removed = this._conByIdent.remove(ident.calculateHash());
            }
        }
        return removed;
    }

    @Override
    public int countPeers() {
        return this._conByIdent.size();
    }

    @Override
    public int countActivePeers() {
        int active = 0;
        for (NTCPConnection con : this._conByIdent.values()) {
            if ((con.getMessagesSent() <= 0 || con.getTimeSinceSend() > 300000L) && (con.getMessagesReceived() <= 0 || con.getTimeSinceReceive() > 300000L)) continue;
            ++active;
        }
        return active;
    }

    @Override
    public int countActiveSendPeers() {
        int active = 0;
        for (NTCPConnection con : this._conByIdent.values()) {
            if (con.getMessagesSent() <= 0 || con.getTimeSinceSend() > 60000L) continue;
            ++active;
        }
        return active;
    }

    void setLastBadSkew(long skew) {
        this._lastBadSkew = skew;
    }

    @Override
    public Vector<Long> getClockSkews() {
        Vector<Long> skews = new Vector<Long>();
        long tooOld = this._context.clock().now() - 600000L;
        for (NTCPConnection con : this._conByIdent.values()) {
            if (!con.isEstablished() || con.getCreated() <= tooOld) continue;
            skews.addElement(con.getClockSkew());
        }
        if (skews.size() < 5 && this._lastBadSkew != 0L) {
            skews.addElement(this._lastBadSkew);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("NTCP transport returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    boolean isHXHIValid(byte[] hxhi) {
        return !this._replayFilter.add(hxhi, 0, 8);
    }

    @Override
    public synchronized void startListening() {
        if (this._pumper.isAlive()) {
            return;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Starting NTCP transport listening");
        }
        this.startIt();
        RouterAddress addr = this.configureLocalAddress();
        int port = addr != null ? addr.getPort() : this._ssuPort;
        RouterAddress myAddress = this.bindAddress(port);
        if (myAddress != null) {
            this.replaceAddress(myAddress);
        } else if (addr != null) {
            this.replaceAddress(addr);
        } else if (port > 0) {
            for (InetAddress ia : this.getSavedLocalAddresses()) {
                OrderedProperties props = new OrderedProperties();
                props.setProperty("host", ia.getHostAddress());
                props.setProperty("port", Integer.toString(port));
                int cost = this.getDefaultCost(ia instanceof Inet6Address);
                myAddress = new RouterAddress(STYLE, props, cost);
                this.replaceAddress(myAddress);
            }
        }
    }

    private synchronized void restartListening(RouterAddress addr, boolean ipv6) {
        if (addr != null) {
            RouterAddress myAddress = this.bindAddress(addr.getPort());
            if (myAddress != null) {
                this.replaceAddress(myAddress);
            } else {
                this.replaceAddress(addr);
            }
        } else {
            this.removeAddress(ipv6);
            if (ipv6) {
                this._lastInboundIPv6 = 0L;
            } else {
                this._lastInboundIPv4 = 0L;
            }
        }
    }

    private void startIt() {
        int nr;
        int nw;
        this._finisher.start();
        this._pumper.startPumping();
        long maxMemory = SystemVersion.getMaxMemory();
        if (maxMemory < 0x2000000L) {
            nw = 1;
            nr = 1;
        } else if (maxMemory < 0x4000000L) {
            nw = 2;
            nr = 2;
        } else {
            nr = Math.max(2, Math.min(4, this._context.bandwidthLimiter().getInboundKBytesPerSecond() / 20));
            nw = Math.max(2, Math.min(4, this._context.bandwidthLimiter().getOutboundKBytesPerSecond() / 20));
        }
        this._reader.startReading(nr);
        this._writer.startWriting(nw);
    }

    public boolean isAlive() {
        return this._pumper.isAlive();
    }

    private RouterAddress bindAddress(int port) {
        RouterAddress myAddress = null;
        if (port > 0) {
            InetAddress bindToAddr = null;
            String bindTo = this._context.getProperty(PROP_BIND_INTERFACE);
            if (bindTo == null) {
                bindTo = this.getFixedHost();
            }
            if (bindTo != null) {
                try {
                    bindToAddr = InetAddress.getByName(bindTo);
                }
                catch (UnknownHostException uhe) {
                    this._log.error("Invalid NTCP bind interface specified [" + bindTo + "]", (Throwable)uhe);
                }
            }
            try {
                InetSocketAddress addr;
                if (bindToAddr == null) {
                    addr = new InetSocketAddress(port);
                } else {
                    addr = new InetSocketAddress(bindToAddr, port);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Binding only to " + bindToAddr);
                    }
                    OrderedProperties props = new OrderedProperties();
                    props.setProperty("host", bindTo);
                    props.setProperty("port", Integer.toString(port));
                    int cost = this.getDefaultCost(false);
                    myAddress = new RouterAddress(STYLE, props, cost);
                }
                if (!this._endpoints.isEmpty()) {
                    if (this._endpoints.contains(addr) || bindToAddr != null && this._endpoints.contains(new InetSocketAddress(port))) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Already listening on " + addr);
                        }
                        return null;
                    }
                    this.stopWaitAndRestart();
                }
                if (!TransportUtil.isValidPort(port)) {
                    this._log.error("Specified NTCP port is " + port + ", ports lower than 1024 not recommended");
                }
                ServerSocketChannel chan = ServerSocketChannel.open();
                chan.configureBlocking(false);
                chan.socket().bind(addr);
                this._endpoints.add(addr);
                if (this._log.shouldLog(20)) {
                    this._log.info("Listening on " + addr);
                }
                this._pumper.register(chan);
            }
            catch (IOException ioe) {
                this._log.error("Error listening", (Throwable)ioe);
                myAddress = null;
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Outbound NTCP connections only - no listener configured");
        }
        return myAddress;
    }

    private String getFixedHost() {
        boolean isFixed = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true").toLowerCase(Locale.US).equals("false");
        String fixedHost = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        if (isFixed && fixedHost != null) {
            try {
                String testAddr = InetAddress.getByName(fixedHost).getHostAddress();
                if (Addresses.getAddresses().contains(testAddr)) {
                    return testAddr;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    private void stopWaitAndRestart() {
        if (this._log.shouldLog(30)) {
            this._log.warn("Halting NTCP to change address");
        }
        this.stopListening();
        while (this.isAlive()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Restarting NTCP transport listening");
        }
        this.startIt();
    }

    Reader getReader() {
        return this._reader;
    }

    Writer getWriter() {
        return this._writer;
    }

    @Override
    public String getStyle() {
        return STYLE;
    }

    EventPumper getPumper() {
        return this._pumper;
    }

    DHSessionKeyBuilder getDHBuilder() {
        return this._dhFactory.getBuilder();
    }

    void returnUnused(DHSessionKeyBuilder builder) {
        this._dhFactory.returnUnused(builder);
    }

    void establishing(NTCPConnection con) {
        this._establishing.add(con);
    }

    void expireTimedOut() {
        int expired = 0;
        Iterator<NTCPConnection> iter = this._establishing.iterator();
        while (iter.hasNext()) {
            NTCPConnection con = iter.next();
            if (con.isClosed() || con.isEstablished()) {
                iter.remove();
                continue;
            }
            if (con.getTimeSinceCreated() <= 10000L) continue;
            iter.remove();
            con.close();
            ++expired;
        }
        if (expired > 0) {
            this._context.statManager().addRateData("ntcp.outboundEstablishFailed", (long)expired);
        }
    }

    private RouterAddress configureLocalAddress() {
        RouterAddress addr = this.createNTCPAddress();
        if (addr != null) {
            if (addr.getPort() <= 0) {
                addr = null;
                if (this._log.shouldLog(40)) {
                    this._log.error("NTCP address is outbound only, since the NTCP configuration is invalid");
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("NTCP address configured: " + (Object)((Object)addr));
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("NTCP address is outbound only");
        }
        return addr;
    }

    private RouterAddress createNTCPAddress() {
        String name = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        if (name == null || name.trim().length() <= 0 || "null".equals(name)) {
            return null;
        }
        int p = this._context.getProperty(PROP_I2NP_NTCP_PORT, -1);
        if (p <= 0 || p >= 65536) {
            return null;
        }
        OrderedProperties props = new OrderedProperties();
        props.setProperty("host", name);
        props.setProperty("port", Integer.toString(p));
        int cost = this.getDefaultCost(false);
        RouterAddress addr = new RouterAddress(STYLE, props, cost);
        return addr;
    }

    private int getDefaultCost(boolean isIPv6) {
        int rv = 10;
        if (isIPv6) {
            TransportUtil.IPv6Config config = this.getIPv6Config();
            if (config == TransportUtil.IPv6Config.IPV6_PREFERRED) {
                --rv;
            } else if (config == TransportUtil.IPv6Config.IPV6_NOT_PREFERRED) {
                ++rv;
            }
        }
        return rv;
    }

    @Override
    public void externalAddressReceived(Transport.AddressSource source, byte[] ip, int port) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Received address: " + Addresses.toString((byte[])ip, (int)port) + " from: " + (Object)((Object)source), (Throwable)new Exception());
        }
        if ((source == Transport.AddressSource.SOURCE_INTERFACE || source == Transport.AddressSource.SOURCE_SSU) && ip != null && ip.length == 16) {
            this._haveIPv6Address = true;
        }
        if (ip != null && !this.isValid(ip)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid address: " + Addresses.toString((byte[])ip, (int)port) + " from: " + (Object)((Object)source));
            }
            return;
        }
        if (!this.isAlive()) {
            if (source == Transport.AddressSource.SOURCE_INTERFACE || source == Transport.AddressSource.SOURCE_UPNP) {
                try {
                    InetAddress ia = InetAddress.getByAddress(ip);
                    this.saveLocalAddress(ia);
                }
                catch (UnknownHostException ia) {}
            } else if (source == Transport.AddressSource.SOURCE_CONFIG) {
                this._ssuPort = port;
            }
            return;
        }
        if (source != Transport.AddressSource.SOURCE_SSU) {
            return;
        }
        boolean isIPv6 = ip != null && ip.length == 16;
        this.externalAddressReceived(ip, isIPv6, port);
    }

    @Override
    public void externalAddressRemoved(Transport.AddressSource source, boolean ipv6) {
        if (this._log.shouldWarn()) {
            this._log.warn("Removing address, ipv6? " + ipv6 + " from: " + (Object)((Object)source), (Throwable)new Exception());
        }
        if (source != Transport.AddressSource.SOURCE_SSU) {
            return;
        }
        this.externalAddressReceived(null, ipv6, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized void externalAddressReceived(byte[] ip, boolean isIPv6, int port) {
        boolean ssuOK;
        int cost;
        RouterAddress oldAddr = this.getCurrentAddress(isIPv6);
        if (this._log.shouldLog(20)) {
            this._log.info("Changing NTCP Address? was " + (Object)((Object)oldAddr));
        }
        OrderedProperties newProps = new OrderedProperties();
        if (oldAddr == null) {
            cost = this.getDefaultCost(isIPv6);
        } else {
            cost = oldAddr.getCost();
            newProps.putAll(oldAddr.getOptionsMap());
        }
        RouterAddress newAddr = new RouterAddress(STYLE, newProps, cost);
        boolean changed = false;
        String oport = newProps.getProperty("port");
        String nport = null;
        String cport = this._context.getProperty(PROP_I2NP_NTCP_PORT);
        if (cport != null && cport.length() > 0) {
            nport = cport;
        } else if (this._context.getBooleanPropertyDefaultTrue(PROP_I2NP_NTCP_AUTO_PORT) && port > 0) {
            nport = Integer.toString(port);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("old port: " + oport + " config: " + cport + " new: " + nport);
        }
        if (oport == null && nport != null && nport.length() > 0) {
            newProps.setProperty("port", nport);
            changed = true;
        }
        String ohost = newProps.getProperty("host");
        String enabled = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true").toLowerCase(Locale.US);
        String name = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        if (name != null && name.length() > 0) {
            enabled = "false";
        }
        boolean bl = ssuOK = ip != null;
        if (this._log.shouldLog(20)) {
            this._log.info("old: " + ohost + " config: " + name + " auto: " + enabled + " ssuOK? " + ssuOK);
        }
        if (enabled.equals("always") || Boolean.parseBoolean(enabled) && ssuOK) {
            if (!ssuOK) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("null address with always config", (Throwable)new Exception());
                }
                return;
            }
            String nhost = Addresses.toString((byte[])ip);
            if (this._log.shouldLog(20)) {
                this._log.info("old: " + ohost + " config: " + name + " new: " + nhost);
            }
            if (nhost == null || nhost.length() <= 0) {
                return;
            }
            if (ohost == null || !ohost.equalsIgnoreCase(nhost)) {
                newProps.setProperty("host", nhost);
                changed = true;
            }
        } else if (enabled.equals("false") && name != null && name.length() > 0 && !name.equals(ohost)) {
            if (this._log.shouldLog(20)) {
                this._log.info("old host: " + ohost + " config: " + name + " new: " + name);
            }
            newProps.setProperty("host", name);
            changed = true;
        } else {
            if (ohost == null || ohost.length() <= 0) {
                return;
            }
            if (Boolean.parseBoolean(enabled) && !ssuOK) {
                if (this._log.shouldLog(20)) {
                    this._log.info("old host: " + ohost + " config: " + name + " new: null");
                }
                newAddr = null;
                changed = true;
            }
        }
        if (!changed) {
            if (oldAddr == null) {
                this._log.info("No change to NTCP Address");
                return;
            }
            int oldCost = oldAddr.getCost();
            int newCost = this.getDefaultCost(ohost != null && ohost.contains(":"));
            if (!this.haveCapacity()) {
                ++newCost;
            }
            if (newCost == oldCost) {
                this._log.info("No change to NTCP Address");
                return;
            }
            newAddr.setCost(newCost);
            if (this._log.shouldLog(30)) {
                this._log.warn("Changing NTCP cost from " + oldCost + " to " + newCost);
            }
        }
        this.restartListening(newAddr, isIPv6);
        if (this._log.shouldLog(30)) {
            this._log.warn("Updating NTCP Address (ipv6? " + isIPv6 + ") with " + (Object)((Object)newAddr));
        }
    }

    @Override
    public void forwardPortStatus(byte[] ip, int port, int externalPort, boolean success, String reason) {
        if (this._log.shouldLog(30)) {
            if (success) {
                this._log.warn("UPnP has opened the NTCP port: " + port + " via " + Addresses.toString((byte[])ip, (int)externalPort));
            } else {
                this._log.warn("UPnP has failed to open the NTCP port: " + port + " reason: " + reason);
            }
        }
    }

    @Override
    public int getRequestedPort() {
        int port;
        RouterAddress addr = this.getCurrentAddress(false);
        if (addr != null && (port = addr.getPort()) > 0) {
            return port;
        }
        return this._context.getProperty(PROP_I2NP_NTCP_PORT, -1);
    }

    @Override
    public CommSystemFacade.Status getReachabilityStatus() {
        boolean v6OK;
        boolean hasV6;
        boolean v6Disabled;
        boolean v4Disabled;
        if (!this.isAlive()) {
            return CommSystemFacade.Status.UNKNOWN;
        }
        TransportUtil.IPv6Config config = this.getIPv6Config();
        if (config == TransportUtil.IPv6Config.IPV6_DISABLED) {
            v4Disabled = false;
            v6Disabled = true;
        } else if (config == TransportUtil.IPv6Config.IPV6_ONLY) {
            v4Disabled = true;
            v6Disabled = false;
        } else {
            v4Disabled = false;
            v6Disabled = false;
        }
        boolean hasV4 = this.getCurrentAddress(false) != null;
        boolean bl = hasV6 = this.getCurrentAddress(true) != null;
        if (!hasV4 && !hasV6) {
            return CommSystemFacade.Status.UNKNOWN;
        }
        long now = this._context.clock().now();
        boolean v4OK = hasV4 && !v4Disabled && now - this._lastInboundIPv4 < 600000L;
        boolean bl2 = v6OK = hasV6 && !v6Disabled && now - this._lastInboundIPv6 < 1800000L;
        if (v4OK) {
            if (v6OK) {
                return CommSystemFacade.Status.OK;
            }
            if (v6Disabled) {
                return CommSystemFacade.Status.OK;
            }
            if (!hasV6) {
                return CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN;
            }
        }
        if (v6OK) {
            if (v4Disabled) {
                return CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK;
            }
            if (!hasV4) {
                return CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK;
            }
        }
        for (NTCPConnection con : this._conByIdent.values()) {
            if (!con.isInbound()) continue;
            if (con.isIPv6()) {
                if (hasV6) {
                    v6OK = true;
                }
            } else if (hasV4) {
                v4OK = true;
            }
            if (v4OK) {
                if (v6OK) {
                    return CommSystemFacade.Status.OK;
                }
                if (v6Disabled) {
                    return CommSystemFacade.Status.OK;
                }
                if (!hasV6) {
                    return CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN;
                }
            }
            if (!v6OK) continue;
            if (v4Disabled) {
                return CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK;
            }
            if (hasV4) continue;
            return CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK;
        }
        if (v4OK) {
            return CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN;
        }
        if (v6OK) {
            return CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK;
        }
        if (v4Disabled) {
            return CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN;
        }
        if (v6Disabled) {
            return CommSystemFacade.Status.UNKNOWN;
        }
        return CommSystemFacade.Status.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopListening() {
        ArrayList<NTCPConnection> cons;
        if (this._log.shouldLog(30)) {
            this._log.warn("Stopping ntcp transport");
        }
        this._pumper.stopPumping();
        this._writer.stopWriting();
        this._reader.stopReading();
        this._finisher.stop();
        Object object = this._conLock;
        synchronized (object) {
            cons = new ArrayList<NTCPConnection>(this._conByIdent.values());
            this._conByIdent.clear();
        }
        for (NTCPConnection con : cons) {
            con.close();
        }
        NTCPConnection.releaseResources();
        this.replaceAddress(null);
        this._endpoints.clear();
        this._lastInboundIPv4 = 0L;
        this._lastInboundIPv6 = 0L;
    }

    public void renderStatusHTML(java.io.Writer out, int sortFlags) throws IOException {
    }

    @Override
    public void renderStatusHTML(java.io.Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<NTCPConnection> peers = new TreeSet<NTCPConnection>(this.getComparator(sortFlags));
        peers.addAll(this._conByIdent.values());
        long offsetTotal = 0L;
        float bpsSend = 0.0f;
        float bpsRecv = 0.0f;
        long totalUptime = 0L;
        long totalSend = 0L;
        long totalRecv = 0L;
        if (!this._context.getBooleanProperty(PROP_ADVANCED)) {
            Iterator<NTCPConnection> iter = peers.iterator();
            while (iter.hasNext()) {
                if (iter.next().isEstablished()) continue;
                iter.remove();
            }
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"ntcpcon\">").append(this._t("NTCP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._t("Limit")).append(": ").append(this.getMaxConnections());
        buf.append(". ").append(this._t("Timeout")).append(": ").append(DataHelper.formatDuration2((long)this._pumper.getIdleTimeout()));
        if (this._context.getBooleanProperty(PROP_ADVANCED)) {
            buf.append(". ").append(this._t("Status")).append(": ").append(this._t(this.getReachabilityStatus().toStatusString()));
        }
        buf.append(".</h3>\n<table>\n<tr><th><a href=\"#def.peer\">").append(this._t("Peer")).append("</a></th><th>").append(this._t("Dir")).append("</th><th>").append(this._t("IPv6")).append("</th><th align=\"right\"><a href=\"#def.idle\">").append(this._t("Idle")).append("</a></th><th align=\"right\"><a href=\"#def.rate\">").append(this._t("In/Out")).append("</a></th><th align=\"right\"><a href=\"#def.up\">").append(this._t("Up")).append("</a></th><th align=\"right\"><a href=\"#def.skew\">").append(this._t("Skew")).append("</a></th><th align=\"right\"><a href=\"#def.send\">").append(this._t("TX")).append("</a></th><th align=\"right\"><a href=\"#def.recv\">").append(this._t("RX")).append("</a></th><th>").append(this._t("Out Queue")).append("</th><th>").append(this._t("Backlogged?")).append("</th> </tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        for (NTCPConnection con : peers) {
            float r;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(con.getRemotePeer().calculateHash()));
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._t("Inbound")).append("\"/>");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._t("Outbound")).append("\"/>");
            }
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isIPv6()) {
                buf.append("&#x2713;");
            } else {
                buf.append("&nbsp;");
            }
            buf.append("</td><td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2((long)con.getTimeSinceReceive()));
            buf.append(THINSP).append(DataHelper.formatDuration2((long)con.getTimeSinceSend()));
            buf.append("</td><td class=\"cells\" align=\"right\">");
            if (con.getTimeSinceReceive() < 120000L) {
                r = con.getRecvRate();
                buf.append(NTCPTransport.formatRate(r / 1024.0f));
                bpsRecv += r;
            } else {
                buf.append(NTCPTransport.formatRate(0.0f));
            }
            buf.append(THINSP);
            if (con.getTimeSinceSend() < 120000L) {
                r = con.getSendRate();
                buf.append(NTCPTransport.formatRate(r / 1024.0f));
                bpsSend += r;
            } else {
                buf.append(NTCPTransport.formatRate(0.0f));
            }
            buf.append("</td><td class=\"cells\" align=\"right\">").append(DataHelper.formatDuration2((long)con.getUptime()));
            totalUptime += con.getUptime();
            offsetTotal += con.getClockSkew();
            buf.append("</td><td class=\"cells\" align=\"right\">").append(DataHelper.formatDuration2((long)(1000L * con.getClockSkew())));
            buf.append("</td><td class=\"cells\" align=\"right\">").append(con.getMessagesSent());
            totalSend += (long)con.getMessagesSent();
            buf.append("</td><td class=\"cells\" align=\"right\">").append(con.getMessagesReceived());
            totalRecv += (long)con.getMessagesReceived();
            long outQueue = con.getOutboundQueueSize();
            buf.append("</td><td class=\"cells\" align=\"center\">").append(outQueue);
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isBacklogged()) {
                buf.append("&#x2713;");
            } else {
                buf.append("&nbsp;");
            }
            buf.append("</td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        if (!peers.isEmpty()) {
            buf.append("<tr class=\"tablefooter\"><td colspan=\"4\" align=\"left\"><b>").append(this.ngettext("{0} peer", "{0} peers", peers.size()));
            buf.append("</b></td><td align=\"center\"><b>").append(NTCPTransport.formatRate(bpsRecv / 1024.0f)).append(THINSP).append(NTCPTransport.formatRate(bpsSend / 1024.0f)).append("</b>");
            buf.append("</td><td align=\"center\"><b>").append(DataHelper.formatDuration2((long)(totalUptime / (long)peers.size())));
            buf.append("</b></td><td align=\"center\"><b>").append(DataHelper.formatDuration2((long)(offsetTotal * 1000L / (long)peers.size())));
            buf.append("</b></td><td align=\"center\"><b>").append(totalSend).append("</b></td><td align=\"center\"><b>").append(totalRecv);
            buf.append("</b></td><td>&nbsp;</td><td>&nbsp;</td></tr>\n");
        }
        buf.append("</table>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatRate(float rate) {
        NumberFormat numberFormat = _rateFmt;
        synchronized (numberFormat) {
            return _rateFmt.format(rate);
        }
    }

    private Comparator<NTCPConnection> getComparator(int sortFlags) {
        Comparator<NTCPConnection> rv = null;
        switch (Math.abs(sortFlags)) {
            default: 
        }
        rv = AlphaComparator.instance();
        if (sortFlags < 0) {
            rv = Collections.reverseOrder(rv);
        }
        return rv;
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }

    private static class PeerComparator
    implements Comparator<NTCPConnection>,
    Serializable {
        private PeerComparator() {
        }

        @Override
        public int compare(NTCPConnection l, NTCPConnection r) {
            if (l == null || r == null) {
                throw new IllegalArgumentException();
            }
            return l.getRemotePeer().calculateHash().toBase64().compareTo(r.getRemotePeer().calculateHash().toBase64());
        }
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        @Override
        public Transport getTransport() {
            return NTCPTransport.this;
        }

        public String toString() {
            return "NTCP bid @ " + this.getLatencyMs();
        }
    }
}

