/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportEventListener;

public interface Transport {
    public TransportBid bid(RouterInfo var1, long var2);

    public void send(OutNetMessage var1);

    public void startListening();

    public void stopListening();

    public List<RouterAddress> getCurrentAddresses();

    public boolean hasCurrentAddress();

    public List<RouterAddress> updateAddress();

    public void externalAddressReceived(AddressSource var1, byte[] var2, int var3);

    public void externalAddressRemoved(AddressSource var1, boolean var2);

    public void forwardPortStatus(byte[] var1, int var2, int var3, boolean var4, String var5);

    public int getRequestedPort();

    public void setListener(TransportEventListener var1);

    public String getStyle();

    public int countPeers();

    public int countActivePeers();

    public int countActiveSendPeers();

    public boolean haveCapacity();

    public boolean haveCapacity(int var1);

    public Vector<Long> getClockSkews();

    public List<String> getMostRecentErrorMessages();

    public void renderStatusHTML(Writer var1, String var2, int var3) throws IOException;

    public CommSystemFacade.Status getReachabilityStatus();

    public void recheckReachability();

    public boolean isBacklogged(Hash var1);

    public boolean wasUnreachable(Hash var1);

    public boolean isUnreachable(Hash var1);

    public boolean isEstablished(Hash var1);

    public void mayDisconnect(Hash var1);

    public static enum AddressSource {
        SOURCE_UPNP("upnp"),
        SOURCE_INTERFACE("local"),
        SOURCE_CONFIG("config"),
        SOURCE_SSU("ssu");

        private final String cfgstr;

        private AddressSource(String cfgstr) {
            this.cfgstr = cfgstr;
        }

        public String toConfigString() {
            return this.cfgstr;
        }
    }
}

