/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Properties;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.KeyCertificate;
import net.i2p.data.PrivateKey;
import net.i2p.data.PrivateKeyFile;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public class CreateRouterInfoJob
extends JobImpl {
    private final Log _log;
    private final Job _next;
    public static final String INFO_FILENAME = "router.info";
    public static final String KEYS_FILENAME = "router.keys";
    public static final String KEYS2_FILENAME = "router.keys.dat";
    static final String PROP_ROUTER_SIGTYPE = "router.sigType";
    private static final SigType DEFAULT_SIGTYPE = SystemVersion.isARM() || SystemVersion.isAndroid() ? SigType.DSA_SHA1 : SigType.EdDSA_SHA512_Ed25519;

    CreateRouterInfoJob(RouterContext ctx, Job next) {
        super(ctx);
        this._next = next;
        this._log = ctx.logManager().getLog(CreateRouterInfoJob.class);
    }

    @Override
    public String getName() {
        return "Create New Router Info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        this._log.debug("Creating the new router info");
        Object object = this.getContext().router().routerInfoFileLock;
        synchronized (object) {
            this.createRouterInfo();
        }
        this.getContext().jobQueue().addJob(this._next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RouterInfo createRouterInfo() {
        SigType type = CreateRouterInfoJob.getSigTypeConfig(this.getContext());
        RouterInfo info = new RouterInfo();
        OutputStream fos1 = null;
        try {
            byte[] padding;
            info.setAddresses(this.getContext().commSystem().createAddresses());
            info.setPublished(CreateRouterInfoJob.getCurrentPublishDate(this.getContext()));
            Object[] keypair = this.getContext().keyGenerator().generatePKIKeypair();
            PublicKey pubkey = (PublicKey)keypair[0];
            PrivateKey privkey = (PrivateKey)keypair[1];
            SimpleDataStructure[] signingKeypair = this.getContext().keyGenerator().generateSigningKeys(type);
            SigningPublicKey signingPubKey = (SigningPublicKey)signingKeypair[0];
            SigningPrivateKey signingPrivKey = (SigningPrivateKey)signingKeypair[1];
            RouterIdentity ident = new RouterIdentity();
            Certificate cert = CreateRouterInfoJob.createCertificate(this.getContext(), signingPubKey);
            ident.setCertificate(cert);
            ident.setPublicKey(pubkey);
            ident.setSigningPublicKey(signingPubKey);
            int padLen = SigningPublicKey.KEYSIZE_BYTES - signingPubKey.length();
            if (padLen > 0) {
                padding = new byte[padLen];
                this.getContext().random().nextBytes(padding);
                ident.setPadding(padding);
            } else {
                padding = null;
            }
            info.setIdentity(ident);
            Properties stats = this.getContext().statPublisher().publishStatistics(ident.getHash());
            info.setOptions(stats);
            info.sign(signingPrivKey);
            if (!info.isValid()) {
                throw new DataFormatException("RouterInfo we just built is invalid: " + (Object)((Object)info));
            }
            new File(this.getContext().getRouterDir(), KEYS_FILENAME).delete();
            File ifile = new File(this.getContext().getRouterDir(), INFO_FILENAME);
            fos1 = new BufferedOutputStream((OutputStream)new SecureFileOutputStream(ifile));
            info.writeBytes(fos1);
            File kfile = new File(this.getContext().getRouterDir(), KEYS2_FILENAME);
            PrivateKeyFile pkf = new PrivateKeyFile(kfile, pubkey, signingPubKey, cert, privkey, signingPrivKey, padding);
            pkf.write();
            this.getContext().keyManager().setKeys(pubkey, privkey, signingPubKey, signingPrivKey);
            if (this._log.shouldLog(20)) {
                this._log.info("Router info created and stored at " + ifile.getAbsolutePath() + " with private keys stored at " + kfile.getAbsolutePath() + " [" + (Object)((Object)info) + "]");
            }
            this.getContext().router().eventLog().addEvent("rekeyed", ident.calculateHash().toBase64());
        }
        catch (GeneralSecurityException gse) {
            this._log.log(50, "Error building the new router information", (Throwable)gse);
        }
        catch (DataFormatException dfe) {
            this._log.log(50, "Error building the new router information", (Throwable)dfe);
        }
        catch (IOException ioe) {
            this._log.log(50, "Error writing out the new router information", (Throwable)ioe);
        }
        finally {
            if (fos1 != null) {
                try {
                    fos1.close();
                }
                catch (IOException gse) {}
            }
        }
        return info;
    }

    public static SigType getSigTypeConfig(RouterContext ctx) {
        SigType ntype;
        SigType cstype = DEFAULT_SIGTYPE;
        String sstype = ctx.getProperty(PROP_ROUTER_SIGTYPE);
        if (sstype != null && (ntype = SigType.parseSigType((String)sstype)) != null) {
            cstype = ntype;
        }
        if (cstype != SigType.DSA_SHA1 && !cstype.isAvailable()) {
            cstype = SigType.DSA_SHA1;
        }
        return cstype;
    }

    static long getCurrentPublishDate(RouterContext context) {
        return context.clock().now();
    }

    static Certificate createCertificate(RouterContext ctx, SigningPublicKey spk) {
        if (spk.getType() != SigType.DSA_SHA1) {
            return new KeyCertificate(spk);
        }
        if (ctx.getBooleanProperty("router.hiddenMode")) {
            return new Certificate(2, null);
        }
        return Certificate.NULL_CERT;
    }
}

