/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.kademlia.KBucketSet;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupMatchJob;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupSelector;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupTimeoutJob;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;

class FloodOnlySearchJob
extends FloodSearchJob {
    private boolean _shouldProcessDSRM;
    private final HashSet<Hash> _unheardFrom;
    private OutNetMessage _out;
    protected final MessageSelector _replySelector;
    protected final ReplyJob _onReply;
    protected final Job _onTimeout;
    private static final int MIN_FOR_NO_DSRM = 4;
    private static final long SINGLE_SEARCH_MSG_TIME = 10000L;

    public FloodOnlySearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease) {
        super(ctx, facade, key, onFind, onFailed, timeoutMs, isLease);
        this._timeoutMs = Math.min(timeoutMs, 10000);
        this._expiration = (long)this._timeoutMs + ctx.clock().now();
        this._unheardFrom = new HashSet(2);
        this._replySelector = new FloodOnlyLookupSelector(this.getContext(), this);
        this._onReply = new FloodOnlyLookupMatchJob(this.getContext(), this);
        this._onTimeout = new FloodOnlyLookupTimeoutJob(this.getContext(), this);
    }

    public boolean shouldProcessDSRM() {
        return this._shouldProcessDSRM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        List<Object> floodfillPeers;
        KBucketSet<Hash> ks = this._facade.getKBuckets();
        if (ks != null) {
            Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(this._key);
            floodfillPeers = ((FloodfillPeerSelector)this._facade.getPeerSelector()).selectFloodfillParticipants(rkey, 4, ks);
        } else {
            floodfillPeers = Collections.emptyList();
        }
        boolean bl = this._shouldProcessDSRM = floodfillPeers.size() < 4 || this.getContext().routingKeyGenerator().getLastChanged() > this.getContext().clock().now() - 3600000L;
        if (floodfillPeers.isEmpty()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Running netDb searches against the floodfill peers, but we don't know any");
            }
            if ((floodfillPeers = new ArrayList<Hash>(this._facade.getAllRouters())).isEmpty()) {
                if (this._log.shouldLog(40)) {
                    this._log.error("We don't know any peers at all");
                }
                this.failed();
                return;
            }
            Collections.shuffle(floodfillPeers, (Random)this.getContext().random());
        }
        this._out = this.getContext().messageRegistry().registerPending(this._replySelector, this._onReply, this._onTimeout);
        int count = 0;
        for (int i = 0; this._lookupsRemaining.get() < 2 && i < floodfillPeers.size(); ++i) {
            Hash peer = (Hash)floodfillPeers.get(i);
            if (peer.equals((Object)this.getContext().routerHash())) continue;
            DatabaseLookupMessage dlm = new DatabaseLookupMessage(this.getContext(), true);
            TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundTunnel();
            TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundTunnel();
            if (replyTunnel == null || outTunnel == null) {
                this.failed();
                return;
            }
            if (outTunnel.getLength() <= 1 && peer.equals((Object)this._key) && floodfillPeers.size() > 1) continue;
            HashSet<Hash> hashSet = this._unheardFrom;
            synchronized (hashSet) {
                this._unheardFrom.add(peer);
            }
            dlm.setFrom(replyTunnel.getPeer(0));
            dlm.setMessageExpiration(this.getContext().clock().now() + 10000L);
            dlm.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
            dlm.setSearchKey(this._key);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Floodfill search for " + this._key + " to " + peer);
            }
            this.getContext().tunnelDispatcher().dispatchOutbound(dlm, outTunnel.getSendTunnelId(0), peer);
            ++count;
            this._lookupsRemaining.incrementAndGet();
        }
        if (count <= 0) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Floodfill search for " + this._key + " had no peers to send to");
            }
            this.failed();
        }
    }

    @Override
    public String getName() {
        return "NetDb flood search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int decrementRemaining(Hash peer) {
        HashSet<Hash> hashSet = this._unheardFrom;
        synchronized (hashSet) {
            this._unheardFrom.remove(peer);
            return this.decrementRemaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void failed() {
        FloodOnlySearchJob floodOnlySearchJob = this;
        synchronized (floodOnlySearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        this.getContext().messageRegistry().unregisterPending(this._out);
        long time = System.currentTimeMillis() - this._created;
        if (this._log.shouldLog(20)) {
            int timeRemaining = (int)(this._expiration - this.getContext().clock().now());
            this._log.info(this.getJobId() + ": Floodfill search for " + this._key + " failed with " + timeRemaining + " remaining after " + time);
        }
        HashSet<Hash> timeRemaining = this._unheardFrom;
        synchronized (timeRemaining) {
            for (Hash h : this._unheardFrom) {
                this.getContext().profileManager().dbLookupFailed(h);
            }
        }
        this._facade.complete(this._key);
        this.getContext().statManager().addRateData("netDb.failedTime", time);
        for (Job j : this._onFailed) {
            this.getContext().jobQueue().addJob(j);
        }
        this._onFailed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void success() {
        FloodOnlySearchJob floodOnlySearchJob = this;
        synchronized (floodOnlySearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Floodfill search for " + this._key + " successful");
        }
        long time = System.currentTimeMillis() - this._created;
        HashSet<Hash> hashSet = this._unheardFrom;
        synchronized (hashSet) {
            if (this._unheardFrom.size() == 1) {
                Hash peer = this._unheardFrom.iterator().next();
                this.getContext().profileManager().dbLookupSuccessful(peer, time);
            }
        }
        this._facade.complete(this._key);
        this.getContext().statManager().addRateData("netDb.successTime", time);
        for (Job j : this._onFind) {
            this.getContext().jobQueue().addJob(j);
        }
    }
}

