/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;

public class FamilyKeyCrypto {
    private final RouterContext _context;
    private final Log _log;
    private final Map<Hash, String> _verified;
    private final Set<Hash> _negativeCache;
    private final String _fname;
    private final SigningPrivateKey _privkey;
    private final SigningPublicKey _pubkey;
    private static final String PROP_KEYSTORE_PASSWORD = "netdb.family.keystorePassword";
    public static final String PROP_FAMILY_NAME = "netdb.family.name";
    private static final String PROP_KEY_PASSWORD = "netdb.family.keyPassword";
    private static final String CERT_SUFFIX = ".crt";
    private static final String KEYSTORE_PREFIX = "family-";
    private static final String KEYSTORE_SUFFIX = ".ks";
    private static final int DEFAULT_KEY_VALID_DAYS = 3652;
    private static final String DEFAULT_KEY_ALGORITHM = SigType.ECDSA_SHA256_P256.isAvailable() ? "EC" : "DSA";
    private static final int DEFAULT_KEY_SIZE = SigType.ECDSA_SHA256_P256.isAvailable() ? 256 : 1024;
    private static final String KS_DIR = "keystore";
    private static final String CERT_DIR = "certificates/family";
    public static final String OPT_NAME = "family";
    public static final String OPT_SIG = "family.sig";
    public static final String OPT_KEY = "family.key";

    public FamilyKeyCrypto(RouterContext context) throws GeneralSecurityException {
        this._context = context;
        this._log = this._context.logManager().getLog(FamilyKeyCrypto.class);
        this._fname = this._context.getProperty(PROP_FAMILY_NAME);
        if (this._fname != null && (this._fname.contains("/") || this._fname.contains("\\") || this._fname.contains("..") || new File(this._fname).isAbsolute())) {
            throw new GeneralSecurityException("Illegal family name");
        }
        this._privkey = this._fname != null ? this.initialize() : null;
        this._pubkey = this._privkey != null ? this._privkey.toPublic() : null;
        this._verified = new ConcurrentHashMap<Hash, String>(4);
        this._negativeCache = new ConcurrentHashSet(4);
    }

    private SigningPrivateKey initialize() throws GeneralSecurityException {
        SecureDirectory dir = new SecureDirectory(this._context.getConfigDir(), KS_DIR);
        File keyStore = new File((File)dir, KEYSTORE_PREFIX + this._fname + KEYSTORE_SUFFIX);
        this.verifyKeyStore(keyStore);
        return this.getPrivKey(keyStore);
    }

    public void shutdown() {
        this._verified.clear();
        this._negativeCache.clear();
    }

    public Map<String, String> sign(String family, Hash h) throws GeneralSecurityException {
        if (this._privkey == null) {
            this._log.logAlways(30, "family name now set, must restart router to generate or load keys");
            throw new GeneralSecurityException("family name now set, must restart router to generate or load keys");
        }
        if (h == null) {
            throw new GeneralSecurityException("null router hash");
        }
        if (!this._fname.equals(family)) {
            this._log.logAlways(30, "family name changed, must restart router to generate or load new keys");
            throw new GeneralSecurityException("family name changed, must restart router to generate or load new keys");
        }
        byte[] nb = DataHelper.getUTF8((String)this._fname);
        int len = nb.length + 32;
        byte[] b = new byte[len];
        System.arraycopy(nb, 0, b, 0, nb.length);
        System.arraycopy(h.getData(), 0, b, nb.length, 32);
        Signature sig = this._context.dsa().sign(b, this._privkey);
        if (sig == null) {
            throw new GeneralSecurityException("sig failed");
        }
        HashMap<String, String> rv = new HashMap<String, String>(3);
        rv.put(OPT_NAME, family);
        rv.put(OPT_KEY, this._pubkey.getType().getCode() + ":" + this._pubkey.toBase64());
        rv.put(OPT_SIG, sig.toBase64());
        return rv;
    }

    public boolean verify(RouterInfo ri) {
        Signature sig;
        SigningPublicKey spk;
        String name = ri.getOption(OPT_NAME);
        if (name == null) {
            return true;
        }
        Hash h = ri.getHash();
        String ssig = ri.getOption(OPT_SIG);
        if (ssig == null) {
            if (this._log.shouldInfo()) {
                this._log.info("No sig for " + h + ' ' + name);
            }
            return false;
        }
        String nameAndSig = this._verified.get(h);
        String riNameAndSig = name + ssig;
        if (nameAndSig != null) {
            if (nameAndSig.equals(riNameAndSig)) {
                return true;
            }
            this._verified.remove(h);
        }
        if (name.equals(this._fname)) {
            spk = this._pubkey;
        } else {
            if (this._negativeCache.contains(h)) {
                return false;
            }
            spk = this.loadCert(name);
            if (spk == null) {
                block31: {
                    String skey = ri.getOption(OPT_KEY);
                    if (skey != null) {
                        int colon = skey.indexOf(58);
                        if (colon < 0) {
                            colon = skey.indexOf(59);
                        }
                        if (colon > 0) {
                            try {
                                byte[] bkey;
                                int code = Integer.parseInt(skey.substring(0, colon));
                                SigType type = SigType.getByCode((int)code);
                                if (type != null && (bkey = Base64.decode((String)skey.substring(colon + 1))) != null) {
                                    spk = new SigningPublicKey(type, bkey);
                                }
                            }
                            catch (NumberFormatException e) {
                                if (this._log.shouldInfo()) {
                                    this._log.info("Bad b64 family key: " + (Object)((Object)ri), (Throwable)e);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                if (this._log.shouldInfo()) {
                                    this._log.info("Bad b64 family key: " + (Object)((Object)ri), (Throwable)e);
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                if (!this._log.shouldInfo()) break block31;
                                this._log.info("Bad b64 family key: " + (Object)((Object)ri), (Throwable)e);
                            }
                        }
                    }
                }
                if (spk == null) {
                    this._negativeCache.add(h);
                    if (this._log.shouldInfo()) {
                        this._log.info("No cert or valid key for " + h + ' ' + name);
                    }
                    return false;
                }
            }
        }
        if (!spk.getType().isAvailable()) {
            this._negativeCache.add(h);
            if (this._log.shouldInfo()) {
                this._log.info("Unsupported crypto for sig for " + h);
            }
            return false;
        }
        byte[] bsig = Base64.decode((String)ssig);
        if (bsig == null) {
            this._negativeCache.add(h);
            if (this._log.shouldInfo()) {
                this._log.info("Bad sig for " + h + ' ' + name + ' ' + ssig);
            }
            return false;
        }
        try {
            sig = new Signature(spk.getType(), bsig);
        }
        catch (IllegalArgumentException iae) {
            this._negativeCache.add(h);
            if (this._log.shouldInfo()) {
                this._log.info("Bad sig for " + (Object)((Object)ri), (Throwable)iae);
            }
            return false;
        }
        byte[] nb = DataHelper.getUTF8((String)name);
        byte[] b = new byte[nb.length + 32];
        System.arraycopy(nb, 0, b, 0, nb.length);
        System.arraycopy(ri.getHash().getData(), 0, b, nb.length, 32);
        boolean rv = this._context.dsa().verifySignature(sig, b, spk);
        if (rv) {
            this._verified.put(h, riNameAndSig);
        } else {
            this._negativeCache.add(h);
        }
        if (this._log.shouldInfo()) {
            this._log.info("Verified? " + rv + " for " + h + ' ' + name + ' ' + ssig);
        }
        return rv;
    }

    private void verifyKeyStore(File ks) throws GeneralSecurityException {
        SecureDirectory sdir;
        if (ks.exists()) {
            if (this._context.getProperty(PROP_KEY_PASSWORD) == null) {
                String s = "Family key error, must set netdb.family.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath();
                this._log.error(s);
                throw new GeneralSecurityException(s);
            }
            return;
        }
        File dir = ks.getParentFile();
        if (!dir.exists() && !(sdir = new SecureDirectory(dir.getAbsolutePath())).mkdirs()) {
            String s = "Family key error, must set netdb.family.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath();
            this._log.error(s);
            throw new GeneralSecurityException(s);
        }
        this.createKeyStore(ks);
        this.exportCert(ks);
    }

    private void createKeyStore(File ks) throws GeneralSecurityException {
        String keyPassword = KeyStoreUtil.randomString();
        String cname = this._fname + ".family.i2p.net";
        boolean success = KeyStoreUtil.createKeys((File)ks, (String)"changeit", (String)this._fname, (String)cname, (String)OPT_NAME, (int)3652, (String)DEFAULT_KEY_ALGORITHM, (int)DEFAULT_KEY_SIZE, (String)keyPassword);
        if (success && (success = ks.exists())) {
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_KEYSTORE_PASSWORD, "changeit");
            changes.put(PROP_KEY_PASSWORD, keyPassword);
            changes.put(PROP_FAMILY_NAME, this._fname);
            this._context.router().saveConfig(changes, null);
        }
        if (!success) {
            String s = "Failed to create NetDb family keystore.\nThis is for the Sun/Oracle keytool, others may be incompatible.\nIf you create the keystore manually, you must add netdb.family.keystorePassword and netdb.family.keyPassword to " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath();
            this._log.error(s);
            throw new GeneralSecurityException(s);
        }
        this._log.logAlways(20, "Created new private key for netdb family \"" + this._fname + "\" in keystore: " + ks.getAbsolutePath() + "\n" + "Copy the keystore to the other routers in the family,\n" + "and add the following entries to their router.config file:\n" + PROP_FAMILY_NAME + '=' + this._fname + '\n' + PROP_KEYSTORE_PASSWORD + '=' + "changeit" + '\n' + PROP_KEY_PASSWORD + '=' + keyPassword);
    }

    private void exportCert(File ks) {
        SecureDirectory sdir = new SecureDirectory(this._context.getConfigDir(), CERT_DIR);
        if (sdir.exists() || sdir.mkdirs()) {
            String name;
            File out;
            String ksPass = this._context.getProperty(PROP_KEYSTORE_PASSWORD, "changeit");
            boolean success = KeyStoreUtil.exportCert((File)ks, (String)ksPass, (String)this._fname, (File)(out = new File((File)sdir, name = this._fname.replace("@", "_at_") + CERT_SUFFIX)));
            if (success) {
                this._log.logAlways(20, "Created new public key certificate for netdb family \"" + this._fname + "\" in file: " + out.getAbsolutePath() + "\n" + "The certificate will be associated with your router identity.\n" + "Copy the certificate to the directory $I2P/" + CERT_DIR + " for each of the other routers in the family.\n" + "Give this certificate to an I2P developer for inclusion in the next I2P release.");
            } else {
                this._log.error("Error getting SSL cert to save as ASCII");
            }
        } else {
            this._log.error("Error saving ASCII SSL keys");
        }
    }

    private SigningPublicKey loadCert(String familyName) {
        if (familyName.contains("/") || familyName.contains("\\") || familyName.contains("..") || new File(familyName).isAbsolute()) {
            return null;
        }
        familyName = familyName.replace("@", "_at_");
        File dir = new File(this._context.getBaseDir(), CERT_DIR);
        File file = new File(dir, familyName + CERT_SUFFIX);
        if (!file.exists()) {
            return null;
        }
        try {
            PublicKey pk = CertUtil.loadKey((File)file);
            return SigUtil.fromJavaKey((PublicKey)pk);
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Error loading family key " + familyName, (Throwable)gse);
        }
        catch (IOException ioe) {
            this._log.error("Error loading family key " + familyName, (Throwable)ioe);
        }
        return null;
    }

    private SigningPrivateKey getPrivKey(File ks) throws GeneralSecurityException {
        String ksPass = this._context.getProperty(PROP_KEYSTORE_PASSWORD, "changeit");
        String keyPass = this._context.getProperty(PROP_KEY_PASSWORD);
        if (keyPass == null) {
            throw new GeneralSecurityException("No key password, set netdb.family.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
        }
        try {
            PrivateKey pk = KeyStoreUtil.getPrivateKey((File)ks, (String)ksPass, (String)this._fname, (String)keyPass);
            if (pk == null) {
                throw new GeneralSecurityException("Family key not found: " + this._fname);
            }
            return SigUtil.fromJavaKey((PrivateKey)pk);
        }
        catch (IOException ioe) {
            throw new GeneralSecurityException("Error loading family key " + this._fname, ioe);
        }
    }
}

