/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.router.RouterContext;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class I2NPMessageReader {
    private Log _log;
    private RouterContext _context;
    private InputStream _stream;
    private I2NPMessageEventListener _listener;
    private I2NPMessageReaderRunner _reader;
    private Thread _readerThread;

    public I2NPMessageReader(RouterContext context, InputStream stream, I2NPMessageEventListener lsnr) {
        this(context, stream, lsnr, "I2NP Reader");
    }

    public I2NPMessageReader(RouterContext context, InputStream stream, I2NPMessageEventListener lsnr, String name) {
        this._context = context;
        this._log = context.logManager().getLog(I2NPMessageReader.class);
        this._stream = stream;
        this.setListener(lsnr);
        this._reader = new I2NPMessageReaderRunner();
        this._readerThread = new I2PThread((Runnable)this._reader);
        this._readerThread.setName(name);
        this._readerThread.setDaemon(true);
    }

    public void setListener(I2NPMessageEventListener lsnr) {
        this._listener = lsnr;
    }

    public I2NPMessageEventListener getListener() {
        return this._listener;
    }

    public void startReading() {
        this._readerThread.start();
    }

    public void pauseReading() {
        this._reader.pauseRunner();
    }

    public void resumeReading() {
        this._reader.resumeRunner();
    }

    public void stopReading() {
        this._reader.cancelRunner();
    }

    public static interface I2NPMessageEventListener {
        public void messageReceived(I2NPMessageReader var1, I2NPMessage var2, long var3, int var5);

        public void readError(I2NPMessageReader var1, Exception var2);

        public void disconnected(I2NPMessageReader var1);
    }

    private class I2NPMessageReaderRunner
    implements Runnable {
        private boolean _doRun = true;
        private boolean _stayAlive = true;
        private I2NPMessageHandler _handler;

        public I2NPMessageReaderRunner() {
            this._handler = new I2NPMessageHandler(I2NPMessageReader.this._context);
        }

        public void pauseRunner() {
            this._doRun = false;
        }

        public void resumeRunner() {
            this._doRun = true;
        }

        public void cancelRunner() {
            this._doRun = false;
            this._stayAlive = false;
        }

        @Override
        public void run() {
            while (this._stayAlive) {
                while (this._doRun) {
                    while (!I2NPMessageReader.this._context.throttle().acceptNetworkMessage()) {
                        try {
                            Thread.sleep(500 + I2NPMessageReader.this._context.random().nextInt(512));
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        I2NPMessage msg = this._handler.readMessage(I2NPMessageReader.this._stream);
                        if (msg == null) continue;
                        long msToRead = this._handler.getLastReadTime();
                        int bytesRead = this._handler.getLastSize();
                        I2NPMessageReader.this._listener.messageReceived(I2NPMessageReader.this, msg, msToRead, bytesRead);
                    }
                    catch (I2NPMessageException ime) {
                        if (I2NPMessageReader.this._log.shouldLog(30)) {
                            I2NPMessageReader.this._log.warn("Error handling message", (Throwable)((Object)ime));
                        }
                        I2NPMessageReader.this._listener.readError(I2NPMessageReader.this, (Exception)((Object)ime));
                        I2NPMessageReader.this._listener.disconnected(I2NPMessageReader.this);
                        this.cancelRunner();
                    }
                    catch (InterruptedIOException iioe) {
                        if (I2NPMessageReader.this._log.shouldLog(20)) {
                            I2NPMessageReader.this._log.info("Disconnecting due to inactivity", (Throwable)iioe);
                        }
                        I2NPMessageReader.this._listener.disconnected(I2NPMessageReader.this);
                        this.cancelRunner();
                    }
                    catch (IOException ioe) {
                        if (I2NPMessageReader.this._log.shouldLog(30)) {
                            I2NPMessageReader.this._log.warn("IO Error handling message", (Throwable)ioe);
                        }
                        I2NPMessageReader.this._listener.disconnected(I2NPMessageReader.this);
                        this.cancelRunner();
                    }
                    catch (RuntimeException e) {
                        I2NPMessageReader.this._log.log(50, "error reading msg!", (Throwable)e);
                        I2NPMessageReader.this._listener.readError(I2NPMessageReader.this, e);
                        I2NPMessageReader.this._listener.disconnected(I2NPMessageReader.this);
                        this.cancelRunner();
                    }
                }
                if (!this._stayAlive || this._doRun) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

