/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSimpleClient;
import net.i2p.client.naming.NamingService;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnelClient;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelConnectClient;
import net.i2p.i2ptunnel.I2PTunnelHTTPBidirServer;
import net.i2p.i2ptunnel.I2PTunnelHTTPClient;
import net.i2p.i2ptunnel.I2PTunnelHTTPServer;
import net.i2p.i2ptunnel.I2PTunnelIRCClient;
import net.i2p.i2ptunnel.I2PTunnelIRCServer;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.I2Ping;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.socks.I2PSOCKSIRCTunnel;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.streamr.StreamrConsumer;
import net.i2p.i2ptunnel.streamr.StreamrProducer;
import net.i2p.util.EventDispatcher;
import net.i2p.util.EventDispatcherImpl;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;

public class I2PTunnel
extends EventDispatcherImpl
implements Logging {
    private final Log _log;
    private final I2PAppContext _context;
    private static final AtomicLong __tunnelId = new AtomicLong();
    private final long _tunnelId;
    private final Properties _clientOptions;
    private final Set<I2PSession> _sessions;
    public static final int PACKET_DELAY = 100;
    public boolean ownDest = false;
    public String port = System.getProperty("i2cp.tcp.port", "7654");
    public String host;
    public String listenHost = this.host = System.getProperty("i2cp.tcp.host", "127.0.0.1");
    public long readTimeout = -1L;
    private static final String[] nocli_args = new String[]{"-nocli", "-die"};
    private final List<I2PTunnelTask> tasks = new CopyOnWriteArrayList<I2PTunnelTask>();
    private int next_task_id = 1;
    private final Set<ConnectionEventListener> listeners = new CopyOnWriteArraySet<ConnectionEventListener>();
    private static final int NOGUI = 99999;
    private static final LongOpt[] longopts = new LongOpt[]{new LongOpt("cli", 0, null, 99), new LongOpt("die", 0, null, 100), new LongOpt("gui", 0, null, 103), new LongOpt("help", 0, null, 104), new LongOpt("nocli", 0, null, 119), new LongOpt("nogui", 0, null, 99999), new LongOpt("wait", 0, null, 119)};

    public static void main(String[] args) {
        try {
            new I2PTunnel(args);
        }
        catch (IllegalArgumentException iae) {
            System.err.println(iae.toString());
            System.exit(1);
        }
    }

    public I2PTunnel() {
        this(nocli_args);
    }

    public I2PTunnel(String[] args) {
        this(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PTunnel(String[] args, ConnectionEventListener lsnr) {
        int c;
        Properties p;
        this._context = I2PAppContext.getGlobalContext();
        this._tunnelId = __tunnelId.incrementAndGet();
        this._log = this._context.logManager().getLog(I2PTunnel.class);
        this._clientOptions = p = this._context.getProperties();
        this._sessions = new CopyOnWriteArraySet<I2PSession>();
        this.addConnectionEventListener(lsnr);
        boolean gui = true;
        boolean checkRunByE = true;
        boolean cli = true;
        boolean dontDie = true;
        boolean error = false;
        ArrayList<String> eargs = null;
        Getopt g = new Getopt("i2ptunnel", args, "d::n:c::w::e:h::", longopts);
        block19: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 100: {
                    dontDie = false;
                    gui = false;
                    cli = false;
                    checkRunByE = false;
                    continue block19;
                }
                case 110: {
                    String a = g.getOptarg();
                    if (a.startsWith("oc")) {
                        gui = false;
                        cli = false;
                        checkRunByE = false;
                        continue block19;
                    }
                    if (!a.startsWith("og")) {
                        error = true;
                        continue block19;
                    }
                }
                case 99999: {
                    gui = false;
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this.getPrefix() + "The `-nogui' option of I2PTunnel is deprecated.\n" + "Use `-cli', `-nocli' (aka `-wait') or `-die' instead.");
                    }
                }
                case 99: {
                    gui = false;
                    cli = true;
                    checkRunByE = false;
                    continue block19;
                }
                case 119: {
                    gui = false;
                    cli = false;
                    checkRunByE = false;
                    continue block19;
                }
                case 101: {
                    if (eargs == null) {
                        eargs = new ArrayList<String>(4);
                    }
                    eargs.add(g.getOptarg());
                    if (!checkRunByE) continue block19;
                    checkRunByE = false;
                    cli = false;
                    continue block19;
                }
            }
            error = true;
        }
        int remaining = args.length - g.getOptind();
        if (error || remaining > 1) {
            System.err.println(I2PTunnel.usage());
            throw new IllegalArgumentException();
        }
        if (eargs != null) {
            for (String arg : eargs) {
                this.runCommand(arg, this);
            }
        }
        if (remaining == 1) {
            String f = args[g.getOptind()];
            File file = new File(f);
            if (!file.exists()) {
                System.err.println(I2PTunnel.usage());
                throw new IllegalArgumentException("Command file does not exist: " + f);
            }
            this.runCommand("run " + f, this);
        }
        if (gui) {
            try {
                Class<?> cls = Class.forName("net.i2p.i2ptunnel.I2PTunnelGUI");
                Constructor<?> con = cls.getConstructor(I2PTunnel.class);
                con.newInstance(this);
            }
            catch (Throwable t) {
                throw new UnsupportedOperationException("GUI is not available, try -cli", t);
            }
        } else if (cli) {
            try {
                System.out.println("Enter 'help' for help.");
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                while (true) {
                    System.out.print("I2PTunnel> ");
                    String cmd = r.readLine();
                    if (cmd == null) break;
                    if (cmd.length() <= 0) continue;
                    try {
                        this.runCommand(cmd, this);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (eargs == null && remaining == 0 && dontDie) {
            System.err.println(I2PTunnel.usage());
            throw new IllegalArgumentException("Waiting for nothing! Specify gui, cli, command, command file, or die");
        }
        while (dontDie) {
            I2PTunnel i2PTunnel = this;
            synchronized (i2PTunnel) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private static String usage() {
        return "Usage: i2ptunnel [options] [commandFile]\n  Default is to run the GUI.\n  commandFile: run all commands in this file\n  Options:\n    -c, -cli, --cli     :  run the command line interface\n    -d, -die, --die     :  exit immediately, do not wait for commands to finish\n    -e 'command [args]' :  run the command\n    -h, --help          :  display this help\n    -nocli, --nocli     :  do not run the command line interface or GUI\n    -nogui, --nogui     :  do not run the GUI\n    -w, -wait, --wait   :  do not run the command line interface or GUI";
    }

    List<I2PSession> getSessions() {
        if (this._sessions.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<I2PSession>(this._sessions);
    }

    void addSession(I2PSession session) {
        if (session == null) {
            return;
        }
        boolean added = this._sessions.add(session);
        if (added && this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + " session added: " + session, new Exception());
        }
    }

    void removeSession(I2PSession session) {
        if (session == null) {
            return;
        }
        boolean removed = this._sessions.remove(session);
        if (removed && this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + " session removed: " + session, new Exception());
        }
    }

    public Properties getClientOptions() {
        return this._clientOptions;
    }

    private void addtask(I2PTunnelTask tsk) {
        tsk.setTunnel(this);
        if (tsk.isOpen()) {
            tsk.setId(this.next_task_id);
            ++this.next_task_id;
            this.tasks.add(tsk);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + " adding task: " + tsk);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + " not adding task that isn't open: " + tsk);
        }
    }

    private static String[] split(String src, String delim) {
        StringTokenizer tok = new StringTokenizer(src, delim);
        String[] vals = new String[tok.countTokens()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = tok.nextToken();
        }
        return vals;
    }

    public void runCommand(String cmd, Logging l) {
        if (cmd.indexOf(" ") == -1) {
            cmd = cmd + " ";
        }
        int iii = cmd.indexOf(" ");
        String cmdname = cmd.substring(0, iii).toLowerCase(Locale.US);
        String allargs = cmd.substring(iii + 1);
        String[] args = I2PTunnel.split(allargs, " ");
        if ("help".equals(cmdname)) {
            I2PTunnel.runHelp(l);
        } else if ("clientoptions".equals(cmdname)) {
            this.runClientOptions(args, l);
        } else if ("server".equals(cmdname)) {
            this.runServer(args, l);
        } else if ("httpserver".equals(cmdname)) {
            this.runHttpServer(args, l);
        } else if ("httpbidirserver".equals(cmdname)) {
            this.runHttpBidirServer(args, l);
        } else if ("ircserver".equals(cmdname)) {
            this.runIrcServer(args, l);
        } else if ("textserver".equals(cmdname)) {
            this.runTextServer(args, l);
        } else if ("client".equals(cmdname)) {
            this.runClient(args, l);
        } else if ("httpclient".equals(cmdname)) {
            this.runHttpClient(args, l);
        } else if ("ircclient".equals(cmdname)) {
            this.runIrcClient(args, l);
        } else if ("sockstunnel".equals(cmdname)) {
            this.runSOCKSTunnel(args, l);
        } else if ("connectclient".equals(cmdname)) {
            this.runConnectClient(args, l);
        } else if ("streamrclient".equals(cmdname)) {
            this.runStreamrClient(args, l);
        } else if ("streamrserver".equals(cmdname)) {
            this.runStreamrServer(args, l);
        } else if ("config".equals(cmdname)) {
            this.runConfig(args, l);
        } else if ("listen_on".equals(cmdname)) {
            this.runListenOn(args, l);
        } else if ("read_timeout".equals(cmdname)) {
            this.runReadTimeout(args, l);
        } else if ("genkeys".equals(cmdname)) {
            I2PTunnel.runGenKeys(args, l);
        } else if ("gentextkeys".equals(cmdname)) {
            I2PTunnel.runGenTextKeys(l);
        } else if (cmdname.equals("quit")) {
            this.runQuit(l);
        } else if (cmdname.equals("list")) {
            this.runList(l);
        } else if (cmdname.equals("close")) {
            this.runClose(args, l);
        } else if (cmdname.equals("run")) {
            this.runRun(args, l);
        } else if (cmdname.equals("lookup")) {
            this.runLookup(args, l);
        } else if (cmdname.equals("ping")) {
            this.runPing(allargs, l);
        } else if (cmdname.equals("owndest")) {
            this.runOwnDest(args, l);
        } else if (cmdname.equals("auth")) {
            this.runAuth(args, l);
        } else {
            l.log("Unknown command [" + cmdname + "]");
        }
    }

    private static void runHelp(Logging l) {
        l.log("Command list:\n  auth <username> <password>\n  client <port> <pubkey>[,<pubkey,...]|file:<pubkeyfile> [<sharedClient>]\n  clientoptions [-acx] [key=value ]*\n  close [forced|destroy] <jobnumber>|all\n  config [-s] <i2phost> <i2pport>\n  connectclient <port> [<sharedClient>] [<proxy>]\n  genkeys <privkeyfile> [<pubkeyfile>]\n  gentextkeys\n  httpbidirserver <host> <port> <proxyport> <spoofedhost> <privkeyfile>\n  httpclient <port> [<sharedClient>] [<proxy>]\n  httpserver <host> <port> <spoofedhost> <privkeyfile>\n  ircclient <port> <pubkey>[,<pubkey,...]|file:<pubkeyfile> [<sharedClient>]\n  list\n  listen_on <ip>\n  lookup <name>\n  owndest yes|no\n  ping <args>\n  quit\n  read_timeout <msecs>\n  run <commandfile>\n  server <host> <port> <privkeyfile>\n  textserver <host> <port> <privkey>\n");
    }

    public void runClientOptions(String[] args, Logging l) {
        if (args != null && args.length > 0) {
            int i = 0;
            if (args[0].equals("-a")) {
                ++i;
            } else {
                if (args[0].equals("-c")) {
                    this._clientOptions.clear();
                    l.log("Client options cleared");
                    return;
                }
                if (args[0].equals("-x")) {
                    ++i;
                    while (i < args.length) {
                        if (this._clientOptions.remove(args[i]) != null) {
                            l.log("Removed " + args[i]);
                        }
                        ++i;
                    }
                    return;
                }
                this._clientOptions.clear();
            }
            while (i < args.length) {
                int index = args[i].indexOf(61);
                if (index > 0) {
                    String key = args[i].substring(0, index);
                    String val = args[i].substring(index + 1);
                    this._clientOptions.setProperty(key, val);
                }
                ++i;
            }
        } else {
            l.log("Usage:\n  clientoptions [key=value ]*     // sets current options\n  clientoptions -a [key=value ]*  // adds to current options\n  clientoptions -c                // clears current options\n  clientoptions -x [key ]*        // removes listed options\nCurrent options:\n");
            OrderedProperties p = new OrderedProperties();
            p.putAll((Map<?, ?>)this._clientOptions);
            for (Map.Entry<Object, Object> e : ((Properties)p).entrySet()) {
                l.log("  [" + e.getKey() + "] = [" + e.getValue() + ']');
            }
        }
        this.notifyEvent("clientoptions_onResult", "ok");
    }

    public void setClientOptions(Properties opts) {
        Iterator<Object> iter = this._clientOptions.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (opts.containsKey(key)) continue;
            iter.remove();
        }
        this._clientOptions.putAll((Map<?, ?>)opts);
        for (I2PTunnelTask task : this.tasks) {
            task.optionsUpdated(this);
        }
        this.notifyEvent("clientoptions_onResult", "ok");
    }

    public void runServer(String[] args, Logging l) {
        if (args.length == 3) {
            InetAddress serverHost = null;
            int portNum = -1;
            File privKeyFile = null;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Error resolving " + args[0] + uhe.getMessage());
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
            }
            if (portNum <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[1]);
            }
            privKeyFile = new File(args[2]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[2]);
            }
            if (!privKeyFile.canRead()) {
                l.log(this.getPrefix() + "Private key file does not exist or is not readable: " + args[2]);
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[2]);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Cannot open private key file " + args[2]);
            }
            I2PTunnelServer serv = new I2PTunnelServer(serverHost, portNum, privKeyFile, args[2], l, (EventDispatcher)this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
            return;
        }
        l.log("server <host> <port> <privkeyfile>\n  creates a server that sends all incoming data\n  of its destination to host:port.");
        this.notifyEvent("serverTaskId", -1);
    }

    public void runIrcServer(String[] args, Logging l) {
        if (args.length == 3) {
            InetAddress serverHost = null;
            int portNum = -1;
            File privKeyFile = null;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Error resolving " + args[0] + uhe.getMessage());
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
            }
            if (portNum <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[1]);
            }
            privKeyFile = new File(args[2]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[2]);
            }
            if (!privKeyFile.canRead()) {
                l.log(this.getPrefix() + "Private key file does not exist or is not readable: " + args[2]);
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[2]);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Cannot open private key file " + args[2]);
            }
            I2PTunnelIRCServer serv = new I2PTunnelIRCServer(serverHost, portNum, privKeyFile, args[2], l, (EventDispatcher)this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
            return;
        }
        l.log("server <host> <port> <privkeyfile>\n  creates a server that sends all incoming data\n  of its destination to host:port.");
        this.notifyEvent("serverTaskId", -1);
    }

    public void runHttpServer(String[] args, Logging l) {
        if (args.length == 4) {
            InetAddress serverHost = null;
            int portNum = -1;
            File privKeyFile = null;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Error resolving " + args[0] + uhe.getMessage());
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
            }
            if (portNum <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[1]);
            }
            String spoofedHost = args[2];
            privKeyFile = new File(args[3]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[3]);
            }
            if (!privKeyFile.canRead()) {
                l.log(this.getPrefix() + "Private key file does not exist or is not readable: " + args[3]);
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[3]);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Cannot open private key file " + args[3]);
            }
            I2PTunnelHTTPServer serv = new I2PTunnelHTTPServer(serverHost, portNum, privKeyFile, args[3], spoofedHost, l, (EventDispatcher)this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
            return;
        }
        l.log("httpserver <host> <port> <spoofedhost> <privkeyfile>\n  creates an HTTP server that sends all incoming data\n  of its destination to host:port., filtering the HTTP\n  headers so it looks like the request is to the spoofed host.");
        this.notifyEvent("serverTaskId", -1);
    }

    public void runHttpBidirServer(String[] args, Logging l) {
        if (args.length == 5) {
            InetAddress serverHost = null;
            int portNum = -1;
            int port2Num = -1;
            File privKeyFile = null;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Error resolving " + args[0] + uhe.getMessage());
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
            }
            try {
                port2Num = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[2], nfe);
                this.notifyEvent("serverTaskId", -1);
            }
            if (portNum <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[1]);
            }
            if (port2Num <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[2]);
            }
            String spoofedHost = args[3];
            privKeyFile = new File(args[4]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[4]);
            }
            if (!privKeyFile.canRead()) {
                l.log(this.getPrefix() + "Private key file does not exist or is not readable: " + args[4]);
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[4]);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Cannot open private key file " + args[4]);
            }
            I2PTunnelHTTPBidirServer serv = new I2PTunnelHTTPBidirServer(serverHost, portNum, port2Num, privKeyFile, args[3], spoofedHost, l, (EventDispatcher)this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
            return;
        }
        l.log("httpserver <host> <port> <proxyport> <spoofedhost> <privkeyfile>\n  creates a bidirectional HTTP server that sends all incoming data\n  of its destination to host:port., filtering the HTTP\n  headers so it looks like the request is to the spoofed host,  and listens to host:proxyport to proxy HTTP requests.");
        this.notifyEvent("serverTaskId", -1);
    }

    public void runTextServer(String[] args, Logging l) {
        if (args.length == 3) {
            InetAddress serverHost = null;
            int portNum = -1;
            try {
                serverHost = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("serverTaskId", -1);
                throw new IllegalArgumentException(this.getPrefix() + "Error resolving " + args[0] + uhe.getMessage());
            }
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[1], nfe);
                this.notifyEvent("serverTaskId", -1);
            }
            if (portNum <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[1]);
            }
            I2PTunnelServer serv = new I2PTunnelServer(serverHost, portNum, args[2], l, (EventDispatcher)this, this);
            serv.setReadTimeout(this.readTimeout);
            serv.startRunning();
            this.addtask(serv);
            this.notifyEvent("serverTaskId", serv.getId());
        } else {
            l.log("textserver <host> <port> <privkey>\n  creates a server that sends all incoming data\n  of its destination to host:port.");
            this.notifyEvent("textserverTaskId", -1);
        }
    }

    public void runClient(String[] args, Logging l) {
        boolean isShared = true;
        if (args.length >= 3) {
            isShared = Boolean.parseBoolean(args[2].trim());
        }
        if (args.length >= 2) {
            int portNum = -1;
            try {
                portNum = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("clientTaskId", -1);
            }
            if (portNum <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[0]);
            }
            this.ownDest = !isShared;
            try {
                String privateKeyFile = null;
                if (args.length >= 4) {
                    privateKeyFile = args[3];
                }
                I2PTunnelClient task = new I2PTunnelClient(portNum, args[1], l, this.ownDest, this, this, privateKeyFile);
                task.startRunning();
                this.addtask(task);
                this.notifyEvent("clientTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid I2PTunnel configuration to create a standard client tunnel connecting to the router at " + this.host + ':' + this.port + " and listening on " + this.listenHost + ':' + portNum;
                this._log.error(this.getPrefix() + msg, iae);
                l.log(msg);
                this.notifyEvent("clientTaskId", -1);
                throw iae;
            }
        }
        l.log("client <port> <pubkey>[,<pubkey>]|file:<pubkeyfile>[ <sharedClient>] [<privKeyFile>]\n  creates a client that forwards port to the pubkey.\n  use 0 as port to get a free port assigned.  If you specify\n  a comma delimited list of pubkeys, it will rotate among them\n  randomlyl. sharedClient indicates if this client shares \n   with other clients (true of false)");
        this.notifyEvent("clientTaskId", -1);
    }

    public void runHttpClient(String[] args, Logging l) {
        if (args.length >= 1 && args.length <= 3) {
            int clientPort = -1;
            try {
                clientPort = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("httpclientTaskId", -1);
            }
            if (clientPort <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[0]);
            }
            String proxy = "";
            boolean isShared = true;
            if (args.length > 1) {
                if (Boolean.parseBoolean(args[1].trim())) {
                    isShared = true;
                    if (args.length == 3) {
                        proxy = args[2];
                    }
                } else if ("false".equalsIgnoreCase(args[1].trim())) {
                    this._log.warn("args[1] == [" + args[1] + "] and rejected explicitly");
                    isShared = false;
                    if (args.length == 3) {
                        proxy = args[2];
                    }
                } else if (args.length == 3) {
                    isShared = false;
                    proxy = args[2];
                    this._log.warn("args[1] == [" + args[1] + "] but rejected");
                } else {
                    isShared = true;
                    proxy = args[1];
                }
            }
            this.ownDest = !isShared;
            try {
                I2PTunnelHTTPClient task = new I2PTunnelHTTPClient(clientPort, l, this.ownDest, proxy, (EventDispatcher)this, this);
                ((I2PTunnelClientBase)task).startRunning();
                this.addtask(task);
                this.notifyEvent("httpclientTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid I2PTunnel configuration to create an HTTP Proxy connecting to the router at " + this.host + ':' + this.port + " and listening on " + this.listenHost + ':' + clientPort;
                this._log.error(this.getPrefix() + msg, iae);
                l.log(msg);
                this.notifyEvent("httpclientTaskId", -1);
                throw iae;
            }
        }
        l.log("httpclient <port> [<sharedClient>] [<proxy>]\n  creates a client that distributes HTTP requests.\n  <sharedClient> (optional) indicates if this client shares tunnels with other clients (true of false)\n  <proxy> (optional) indicates a proxy server to be used\n  when trying to access an address out of the .i2p domain");
        this.notifyEvent("httpclientTaskId", -1);
    }

    public void runConnectClient(String[] args, Logging l) {
        if (args.length >= 1 && args.length <= 3) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
            }
            if (_port <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[0]);
            }
            String proxy = "";
            boolean isShared = true;
            if (args.length > 1) {
                if (Boolean.parseBoolean(args[1].trim())) {
                    isShared = true;
                    if (args.length == 3) {
                        proxy = args[2];
                    }
                } else if ("false".equalsIgnoreCase(args[1].trim())) {
                    this._log.warn("args[1] == [" + args[1] + "] and rejected explicitly");
                    isShared = false;
                    if (args.length == 3) {
                        proxy = args[2];
                    }
                } else if (args.length == 3) {
                    isShared = false;
                    proxy = args[2];
                    this._log.warn("args[1] == [" + args[1] + "] but rejected");
                } else {
                    isShared = true;
                    proxy = args[1];
                }
            }
            this.ownDest = !isShared;
            try {
                I2PTunnelConnectClient task = new I2PTunnelConnectClient(_port, l, this.ownDest, proxy, (EventDispatcher)this, this);
                ((I2PTunnelClientBase)task).startRunning();
                this.addtask(task);
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid I2PTunnel configuration to create a CONNECT client connecting to the router at " + this.host + ':' + this.port + " and listening on " + this.listenHost + ':' + _port;
                this._log.error(this.getPrefix() + msg, iae);
                l.log(msg);
                throw iae;
            }
        }
        l.log("connectclient <port> [<sharedClient>] [<proxy>]\n  creates a client that for SSL/HTTPS requests.\n  <sharedClient> (optional) indicates if this client shares tunnels with other clients (true of false)\n  <proxy> (optional) indicates a proxy server to be used\n  when trying to access an address out of the .i2p domain\n");
    }

    public void runIrcClient(String[] args, Logging l) {
        if (args.length >= 2) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("ircclientTaskId", -1);
            }
            if (_port <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[0]);
            }
            boolean isShared = true;
            if (args.length > 2) {
                if (Boolean.parseBoolean(args[2].trim())) {
                    isShared = true;
                } else if ("false".equalsIgnoreCase(args[2].trim())) {
                    this._log.warn("args[2] == [" + args[2] + "] and rejected explicitly");
                    isShared = false;
                } else {
                    isShared = true;
                }
            }
            this.ownDest = !isShared;
            try {
                String privateKeyFile = null;
                if (args.length >= 4) {
                    privateKeyFile = args[3];
                }
                I2PTunnelIRCClient task = new I2PTunnelIRCClient(_port, args[1], l, this.ownDest, this, this, privateKeyFile);
                ((I2PTunnelClientBase)task).startRunning();
                this.addtask(task);
                this.notifyEvent("ircclientTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid I2PTunnel configuration to create an IRC client connecting to the router at " + this.host + ':' + this.port + " and listening on " + this.listenHost + ':' + _port;
                this._log.error(this.getPrefix() + msg, iae);
                l.log(msg);
                this.notifyEvent("ircclientTaskId", -1);
                throw iae;
            }
        }
        l.log("ircclient <port> [<sharedClient> [<privKeyFile>]]\n  creates a client that filter IRC protocol.\n  <sharedClient> (optional) indicates if this client shares tunnels with other clients (true of false)\n");
        this.notifyEvent("ircclientTaskId", -1);
    }

    public void runSOCKSTunnel(String[] args, Logging l) {
        if (args.length >= 1 && args.length <= 3) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("sockstunnelTaskId", -1);
            }
            if (_port <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[0]);
            }
            boolean isShared = false;
            if (args.length == 2) {
                isShared = Boolean.parseBoolean(args[1].trim());
            }
            this.ownDest = !isShared;
            String privateKeyFile = null;
            if (args.length == 3) {
                privateKeyFile = args[2];
            }
            try {
                I2PSOCKSTunnel task = new I2PSOCKSTunnel(_port, l, this.ownDest, (EventDispatcher)this, this, privateKeyFile);
                task.startRunning();
                this.addtask(task);
                this.notifyEvent("sockstunnelTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid I2PTunnel configuration to create a SOCKS Proxy connecting to the router at " + this.host + ':' + this.port + " and listening on " + this.listenHost + ':' + _port;
                this._log.error(this.getPrefix() + msg, iae);
                l.log(msg);
                this.notifyEvent("sockstunnelTaskId", -1);
                throw iae;
            }
        }
        l.log("sockstunnel <port>\n  creates a tunnel that distributes SOCKS requests.");
        this.notifyEvent("sockstunnelTaskId", -1);
    }

    public void runSOCKSIRCTunnel(String[] args, Logging l) {
        if (args.length >= 1 && args.length <= 3) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("sockstunnelTaskId", -1);
            }
            if (_port <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[0]);
            }
            boolean isShared = false;
            if (args.length == 2) {
                isShared = Boolean.parseBoolean(args[1].trim());
            }
            this.ownDest = !isShared;
            String privateKeyFile = null;
            if (args.length == 3) {
                privateKeyFile = args[2];
            }
            try {
                I2PSOCKSIRCTunnel task = new I2PSOCKSIRCTunnel(_port, l, this.ownDest, (EventDispatcher)this, this, privateKeyFile);
                task.startRunning();
                this.addtask(task);
                this.notifyEvent("sockstunnelTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid I2PTunnel configuration to create a SOCKS IRC Proxy connecting to the router at " + this.host + ':' + this.port + " and listening on " + this.listenHost + ':' + _port;
                this._log.error(this.getPrefix() + msg, iae);
                l.log(msg);
                this.notifyEvent("sockstunnelTaskId", -1);
                throw iae;
            }
        }
        l.log("socksirctunnel <port> [<sharedClient> [<privKeyFile>]]\n  creates a tunnel for SOCKS IRC.");
        this.notifyEvent("sockstunnelTaskId", -1);
    }

    public void runStreamrClient(String[] args, Logging l) {
        if (args.length == 3) {
            InetAddress _host;
            try {
                _host = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException uhe) {
                l.log("unknown host");
                this._log.error(this.getPrefix() + "Error resolving " + args[0], uhe);
                this.notifyEvent("streamrtunnelTaskId", -1);
                return;
            }
            int _port = -1;
            try {
                _port = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("streamrtunnelTaskId", -1);
            }
            if (_port <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[0]);
            }
            try {
                StreamrConsumer task = new StreamrConsumer(_host, _port, args[2], l, this, this);
                task.startRunning();
                this.addtask(task);
                this.notifyEvent("streamrtunnelTaskId", task.getId());
            }
            catch (IllegalArgumentException iae) {
                String msg = "Invalid I2PTunnel configuration to create a Streamr Client connecting to the router at " + this.host + ':' + this.port + " and sending to " + _host + ':' + _port;
                this._log.error(this.getPrefix() + msg, iae);
                l.log(msg);
                this.notifyEvent("streamrtunnnelTaskId", -1);
                throw iae;
            }
        }
        l.log("streamrclient <host> <port> <destination>\n  creates a tunnel that receives streaming data.");
        this.notifyEvent("streamrtunnelTaskId", -1);
    }

    public void runStreamrServer(String[] args, Logging l) {
        if (args.length == 2) {
            int _port = -1;
            try {
                _port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                l.log("invalid port");
                this._log.error(this.getPrefix() + "Port specified is not valid: " + args[0], nfe);
                this.notifyEvent("streamrtunnelTaskId", -1);
            }
            if (_port <= 0) {
                throw new IllegalArgumentException(this.getPrefix() + "Bad port " + args[0]);
            }
            File privKeyFile = new File(args[1]);
            if (!privKeyFile.isAbsolute()) {
                privKeyFile = new File(this._context.getConfigDir(), args[1]);
            }
            if (!privKeyFile.canRead()) {
                l.log("private key file does not exist");
                this._log.error(this.getPrefix() + "Private key file does not exist or is not readable: " + args[3]);
                this.notifyEvent("serverTaskId", -1);
                return;
            }
            StreamrProducer task = new StreamrProducer(_port, privKeyFile, args[1], l, (EventDispatcher)this, this);
            task.startRunning();
            this.addtask(task);
            this.notifyEvent("streamrtunnelTaskId", task.getId());
        } else {
            l.log("streamrserver <port> <privkeyfile>\n  creates a tunnel that sends streaming data.");
            this.notifyEvent("streamrtunnelTaskId", -1);
        }
    }

    private void runConfig(String[] args, Logging l) {
        if (args.length >= 1) {
            int i = 0;
            boolean ssl = args[0].equals("-s");
            if (ssl) {
                this._clientOptions.setProperty("i2cp.SSL", "true");
                ++i;
            } else {
                this._clientOptions.remove("i2cp.SSL");
            }
            if (i < args.length) {
                this.listenHost = this.host = args[i++];
            }
            if (i < args.length) {
                this.port = args[i];
            }
            l.log("New setting: " + this.host + ' ' + this.port + (ssl ? " SSL" : " non-SSL"));
            this.notifyEvent("configResult", "ok");
        } else {
            boolean ssl = Boolean.parseBoolean(this._clientOptions.getProperty("i2cp.SSL"));
            l.log("Usage:\n  config [-s] [<i2phost>] [<i2pport>]\n  Sets the address and port of the I2P router.\n  Use -s for SSL.\nCurrent setting: " + this.host + ' ' + this.port + (ssl ? " SSL" : " non-SSL"));
            this.notifyEvent("configResult", "error");
        }
    }

    private void runAuth(String[] args, Logging l) {
        if (args.length == 2) {
            this._clientOptions.setProperty("i2cp.username", args[0]);
            this._clientOptions.setProperty("i2cp.password", args[1]);
        } else {
            l.log("Usage:\n  auth <username> <password>\n  Sets the i2cp credentials");
        }
    }

    private void runOwnDest(String[] args, Logging l) {
        if (args.length == 1 && (args[0].equalsIgnoreCase("yes") || args[0].equalsIgnoreCase("no"))) {
            this.ownDest = args[0].equalsIgnoreCase("yes");
            this.notifyEvent("owndestResult", "ok");
        } else {
            l.log("owndest yes|no\n  Specifies whether to use its own destination \n  for each outgoing tunnel");
            this.notifyEvent("owndestResult", "error");
        }
    }

    public void runListenOn(String[] args, Logging l) {
        if (args.length == 1) {
            this.listenHost = args[0];
            this.notifyEvent("listen_onResult", "ok");
        } else {
            l.log("listen_on <ip>\n  sets the interface to listen for the I2PClient.");
            this.notifyEvent("listen_onResult", "error");
        }
    }

    public void runReadTimeout(String[] args, Logging l) {
        if (args.length == 1) {
            try {
                this.readTimeout = Long.parseLong(args[0]);
            }
            catch (NumberFormatException e) {
                this.notifyEvent("read_timeoutResult", "error");
            }
            this.notifyEvent("read_timeoutResult", "ok");
        } else {
            l.log("read_timeout <msecs>\n  sets the read timeout (in milliseconds) for I2P connections\n  Negative values will make the connections wait forever");
            this.notifyEvent("read_timeoutResult", "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runGenKeys(String[] args, Logging l) {
        FileOutputStream pubdest = null;
        if (args.length == 2) {
            try {
                pubdest = new FileOutputStream(args[1]);
            }
            catch (IOException ioe) {
                l.log("Error opening output stream");
                return;
            }
        } else if (args.length != 1) {
            l.log("genkeys <privkeyfile> [<pubkeyfile>]\n   creates a new keypair and prints the public key.\n   if pubkeyfile is given, saves the public key there.\n   if the privkeyfile already exists, just print/savethe pubkey.");
        }
        try {
            File privKeyFile = new File(args[0]);
            if (privKeyFile.exists()) {
                l.log("File already exists.");
                I2PTunnel.showKey(new FileInputStream(privKeyFile), pubdest, l);
            } else {
                I2PTunnel.makeKey(new FileOutputStream(privKeyFile), pubdest, l);
            }
        }
        catch (IOException ioe) {
            l.log("Error generating keys - " + ioe.getMessage());
        }
        finally {
            if (pubdest != null) {
                try {
                    ((OutputStream)pubdest).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void runGenTextKeys(Logging l) {
        ByteArrayOutputStream privkey = new ByteArrayOutputStream(1024);
        ByteArrayOutputStream pubkey = new ByteArrayOutputStream(512);
        I2PTunnel.makeKey(privkey, pubkey, l);
        l.log("Private key: " + Base64.encode(privkey.toByteArray()));
    }

    private void runQuit(Logging l) {
        this.purgetasks(l);
        if (this.tasks.isEmpty()) {
            System.exit(0);
        }
        l.log("There are running tasks. Try 'list' or 'close all'.");
    }

    private void runList(Logging l) {
        this.purgetasks(l);
        for (I2PTunnelTask t : this.tasks) {
            l.log("[" + t.getId() + "] " + t.toString());
        }
        this.notifyEvent("listDone", "done");
    }

    public void runClose(String[] args, Logging l) {
        if (args.length == 0 || args.length > 2) {
            l.log("close [forced|destroy] <jobnumber>|all\n   stop running tasks. either only one or all.\n   use 'forced' to also stop tasks with active connections.\n   use the 'list' command to show the job numbers");
            this.notifyEvent("closeResult", "error");
        } else {
            int argindex = 0;
            CloseMode mode = CloseMode.NORMAL;
            if (args[argindex].equalsIgnoreCase("forced")) {
                mode = CloseMode.FORCED;
                ++argindex;
            } else if (args[argindex].equalsIgnoreCase("destroy")) {
                mode = CloseMode.DESTROY;
                ++argindex;
            }
            if (args[argindex].equalsIgnoreCase("all")) {
                boolean error = false;
                if (this.tasks.isEmpty() && this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + " runClose(all) no tasks");
                }
                for (I2PTunnelTask t : this.tasks) {
                    if (!this.closetask(t, mode, l)) {
                        this.notifyEvent("closeResult", "error");
                        error = true;
                        continue;
                    }
                    if (error) continue;
                    this.notifyEvent("closeResult", "ok");
                }
            } else {
                try {
                    if (!this.closetask(Integer.parseInt(args[argindex]), mode, l)) {
                        this.notifyEvent("closeResult", "error");
                    }
                    this.notifyEvent("closeResult", "ok");
                }
                catch (NumberFormatException ex) {
                    l.log("Incorrect job number: " + args[argindex]);
                    this.notifyEvent("closeResult", "error");
                }
            }
        }
    }

    private void runRun(String[] args, Logging l) {
        if (args.length == 1) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    this.runCommand(line, l);
                }
                br.close();
                this.notifyEvent("runResult", "ok");
            }
            catch (IOException ioe) {
                l.log("IO error running the file");
                this._log.error(this.getPrefix() + "Error running the file", ioe);
                this.notifyEvent("runResult", "error");
            }
        } else {
            l.log("run <commandfile>\n   loads commandfile and runs each line in it. \n   You can also give the filename on the commandline.");
            this.notifyEvent("runResult", "error");
        }
    }

    private void runLookup(String[] args, Logging l) {
        if (args.length != 1) {
            l.log("lookup <name>\n   try to resolve the name into a destination key");
            this.notifyEvent("lookupResult", "invalidUsage");
        } else {
            try {
                boolean ssl = Boolean.parseBoolean(this._clientOptions.getProperty("i2cp.SSL"));
                String user = this._clientOptions.getProperty("i2cp.username");
                String pw = this._clientOptions.getProperty("i2cp.password");
                Destination dest = I2PTunnel.destFromName(args[0], this.host, this.port, ssl, user, pw);
                if (dest == null) {
                    l.log("Unknown host: " + args[0]);
                    this.notifyEvent("lookupResult", "unkown host");
                } else {
                    l.log(dest.toBase64());
                    this.notifyEvent("lookupResult", dest.toBase64());
                }
            }
            catch (DataFormatException dfe) {
                l.log("Unknown or invalid host: " + args[0]);
                this.notifyEvent("lookupResult", "invalid host");
            }
        }
    }

    private void runPing(String allargs, Logging l) {
        if (allargs.length() != 0) {
            this._clientOptions.setProperty("command", allargs);
            if (this.ownDest) {
                if (!this._clientOptions.containsKey("inbound.nickname")) {
                    this._clientOptions.setProperty("inbound.nickname", "I2Ping");
                }
                if (!this._clientOptions.containsKey("outbound.nickname")) {
                    this._clientOptions.setProperty("outbound.nickname", "I2Ping");
                }
            }
            I2Ping task = new I2Ping(l, this.ownDest, this, this);
            task.startRunning();
            this.addtask(task);
            this.notifyEvent("pingTaskId", task.getId());
        } else {
            l.log(I2Ping.usage());
            this.notifyEvent("pingTaskId", -1);
        }
    }

    private boolean closetask(int num, CloseMode mode, Logging l) {
        boolean closed = false;
        this._log.debug(this.getPrefix() + "closetask(): looking for task " + num);
        for (I2PTunnelTask t : this.tasks) {
            int id = t.getId();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "closetask(): parsing task " + id + " (" + t.toString() + ")");
            }
            if (id == num) {
                closed = this.closetask(t, mode, l);
                break;
            }
            if (id <= num) continue;
            break;
        }
        return closed;
    }

    private boolean closetask(I2PTunnelTask t, CloseMode mode, Logging l) {
        boolean success;
        if (this._log.shouldLog(20)) {
            this._log.info("Closing task " + t.getId() + " mode: " + (Object)((Object)mode));
        }
        if ((success = mode == CloseMode.NORMAL ? t.close(false) : (mode == CloseMode.FORCED ? t.close(true) : t.destroy())) && this._log.shouldLog(20)) {
            this._log.info("Task " + t.getId() + " closed.");
        }
        return success;
    }

    private void purgetasks(Logging l) {
        ArrayList<I2PTunnelTask> removed = new ArrayList<I2PTunnelTask>();
        for (I2PTunnelTask t : this.tasks) {
            if (t.isOpen()) continue;
            this._log.debug(this.getPrefix() + "Purging inactive tunnel: [" + t.getId() + "] " + t.toString());
            removed.add(t);
        }
        this.tasks.removeAll(removed);
    }

    @Override
    public void log(String s) {
        System.out.println(s);
    }

    private static void makeKey(OutputStream writeTo, OutputStream pubDest, Logging l) {
        try {
            l.log("Generating new keys...");
            I2PClient client = I2PClientFactory.createClient();
            Destination d = client.createDestination(writeTo);
            l.log("New destination: " + d.toBase32());
            writeTo.flush();
            writeTo.close();
            I2PTunnel.writePubKey(d, pubDest, l);
        }
        catch (I2PException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void showKey(InputStream readFrom, OutputStream pubDest, Logging l) {
        try {
            Destination d = new Destination();
            d.readBytes(readFrom);
            l.log("Destination: " + d.toBase32());
            readFrom.close();
            I2PTunnel.writePubKey(d, pubDest, l);
        }
        catch (I2PException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void writePubKey(Destination d, OutputStream o, Logging l) throws I2PException, IOException {
        if (o == null) {
            return;
        }
        d.writeBytes(o);
        l.log("Public key saved.");
    }

    public static Destination destFromName(String name) throws DataFormatException {
        return I2PTunnel.destFromName(name, null, null, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Destination destFromName(String name, String i2cpHost, String i2cpPort, boolean isSSL, String user, String pw) throws DataFormatException {
        if (name == null || name.trim().length() <= 0) {
            throw new DataFormatException("Empty destination provided");
        }
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        Log log = ctx.logManager().getLog(I2PTunnel.class);
        if (name.startsWith("file:")) {
            Destination result = new Destination();
            byte[] content = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(name.substring("file:".length()));
                byte[] buf = new byte[1024];
                int read = DataHelper.read(in, buf);
                content = new byte[read];
                System.arraycopy(buf, 0, content, 0, read);
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                Destination read = null;
                return read;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                result.fromByteArray(content);
                return result;
            }
            catch (RuntimeException ex) {
                if (log.shouldLog(20)) {
                    log.info("File is not a binary destination - trying base64");
                }
                try {
                    byte[] decoded = Base64.decode(new String(content));
                    result.fromByteArray(decoded);
                    return result;
                }
                catch (DataFormatException dfe) {
                    if (log.shouldLog(30)) {
                        log.warn("File is not a base64 destination either - failing!");
                    }
                    return null;
                }
            }
        }
        name = name.trim();
        NamingService inst = ctx.namingService();
        boolean b32 = name.length() == 60 && name.toLowerCase(Locale.US).endsWith(".b32.i2p");
        Destination d = null;
        if (!(!ctx.isRouterContext() && b32 || (d = inst.lookup(name)) == null && !ctx.isRouterContext() && name.length() < 516)) {
            return d;
        }
        I2PSimpleClient client = new I2PSimpleClient();
        Properties opts = new Properties();
        if (i2cpHost != null) {
            opts.put("i2cp.tcp.host", i2cpHost);
        }
        if (i2cpPort != null) {
            opts.put("i2cp.tcp.port", i2cpPort);
        }
        opts.put("i2cp.SSL", Boolean.toString(isSSL));
        if (user != null) {
            opts.put("i2cp.username", user);
        }
        if (pw != null) {
            opts.put("i2cp.password", pw);
        }
        I2PSession session = null;
        try {
            session = client.createSession((InputStream)null, opts);
            session.connect();
            d = session.lookupDest(name);
        }
        catch (I2PSessionException ise) {
            if (log.shouldLog(30)) {
                log.warn("Lookup via router failed", ise);
            }
        }
        finally {
            if (session != null) {
                try {
                    session.destroySession();
                }
                catch (I2PSessionException i2PSessionException) {}
            }
        }
        return d;
    }

    public void addConnectionEventListener(ConnectionEventListener lsnr) {
        if (lsnr == null) {
            return;
        }
        this.listeners.add(lsnr);
    }

    public void removeConnectionEventListener(ConnectionEventListener lsnr) {
        if (lsnr == null) {
            return;
        }
        this.listeners.remove(lsnr);
    }

    private String getPrefix() {
        return "[" + this._tunnelId + "]: ";
    }

    public I2PAppContext getContext() {
        return this._context;
    }

    void routerDisconnected() {
        this._log.error(this.getPrefix() + "Router disconnected - firing notification events");
        for (ConnectionEventListener lsnr : this.listeners) {
            if (lsnr == null) continue;
            lsnr.routerDisconnected();
        }
    }

    private static enum CloseMode {
        NORMAL,
        FORCED,
        DESTROY;

    }

    public static interface ConnectionEventListener {
        public void routerDisconnected();
    }
}

