/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSocket;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.Handler;
import net.i2p.sam.SAMBridge;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMStreamReceiver;
import net.i2p.sam.SAMStreamSession;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv3Handler;
import net.i2p.sam.SSLSocketChannel;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.Log;

class SAMv3StreamSession
extends SAMStreamSession
implements SAMv3Handler.Session {
    private static final int BUFFER_SIZE = 1024;
    private final Object socketServerLock = new Object();
    private I2PServerSocket socketServer;
    private final AtomicInteger _acceptors = new AtomicInteger();
    private static I2PSSLSocketFactory _sslSocketFactory;
    private final String nick;

    @Override
    public String getNick() {
        return this.nick;
    }

    public SAMv3StreamSession(String login) throws IOException, DataFormatException, SAMException {
        super(SAMv3StreamSession.getDB().get(login).getDest(), "__v3__", SAMv3StreamSession.getDB().get(login).getProps(), (SAMStreamReceiver)SAMv3StreamSession.getDB().get(login).getHandler());
        this.nick = login;
    }

    public static SAMv3Handler.SessionsDB getDB() {
        return SAMv3Handler.sSessionsHash;
    }

    public void connect(SAMv3Handler handler, String dest, Properties props) throws I2PException, ConnectException, NoRouteToHostException, DataFormatException, InterruptedIOException, IOException {
        String toPort;
        String fromPort;
        boolean verbose = !Boolean.parseBoolean(props.getProperty("SILENT"));
        Destination d = SAMUtils.getDest(dest);
        I2PSocketOptions opts = this.socketMgr.buildOptions(props);
        if (props.getProperty("i2p.streaming.connectTimeout") == null) {
            opts.setConnectTimeout(60000L);
        }
        if ((fromPort = props.getProperty("FROM_PORT")) != null) {
            try {
                opts.setLocalPort(Integer.parseInt(fromPort));
            }
            catch (NumberFormatException nfe) {
                throw new I2PException("Bad port " + fromPort);
            }
        }
        if ((toPort = props.getProperty("TO_PORT")) != null) {
            try {
                opts.setPort(Integer.parseInt(toPort));
            }
            catch (NumberFormatException nfe) {
                throw new I2PException("Bad port " + toPort);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Connecting new I2PSocket...");
        }
        I2PSocket i2ps = this.socketMgr.connect(d, opts);
        SAMv3Handler.SessionRecord rec = SAMv3Handler.sSessionsHash.get(this.nick);
        if (rec == null) {
            throw new InterruptedIOException();
        }
        handler.notifyStreamResult(verbose, "OK", null);
        handler.stealSocket();
        SocketChannel fromClient = handler.getClientSocket();
        ReadableByteChannel fromI2P = Channels.newChannel(i2ps.getInputStream());
        SocketChannel toClient = handler.getClientSocket();
        WritableByteChannel toI2P = Channels.newChannel(i2ps.getOutputStream());
        SAMBridge bridge = handler.getBridge();
        new I2PAppThread(rec.getThreadGroup(), new Pipe(fromClient, toI2P, bridge), "ConnectV3 SAMPipeClientToI2P").start();
        new I2PAppThread(rec.getThreadGroup(), new Pipe(fromI2P, toClient, bridge), "ConnectV3 SAMPipeI2PToClient").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SAMv3Handler handler, boolean verbose) throws I2PException, InterruptedIOException, IOException, SAMException {
        I2PSocket i2ps;
        Object object = this.socketServerLock;
        synchronized (object) {
            if (this.socketServer != null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("a forwarding server is already defined for this destination");
                }
                throw new SAMException("a forwarding server is already defined for this destination");
            }
        }
        this._acceptors.incrementAndGet();
        try {
            i2ps = this.socketMgr.getServerSocket().accept();
        }
        finally {
            this._acceptors.decrementAndGet();
        }
        SAMv3Handler.SessionRecord rec = SAMv3Handler.sSessionsHash.get(this.nick);
        if (rec == null || i2ps == null) {
            throw new InterruptedIOException();
        }
        if (verbose) {
            handler.notifyStreamIncomingConnection(i2ps.getPeerDestination(), i2ps.getPort(), i2ps.getLocalPort());
        }
        handler.stealSocket();
        SocketChannel fromClient = handler.getClientSocket();
        ReadableByteChannel fromI2P = Channels.newChannel(i2ps.getInputStream());
        SocketChannel toClient = handler.getClientSocket();
        WritableByteChannel toI2P = Channels.newChannel(i2ps.getOutputStream());
        SAMBridge bridge = handler.getBridge();
        new I2PAppThread(rec.getThreadGroup(), new Pipe(fromClient, toI2P, bridge), "AcceptV3 SAMPipeClientToI2P").start();
        new I2PAppThread(rec.getThreadGroup(), new Pipe(fromI2P, toClient, bridge), "AcceptV3 SAMPipeI2PToClient").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startForwardingIncoming(Properties props, boolean sendPorts) throws SAMException, InterruptedIOException {
        boolean verbose;
        SAMv3Handler.SessionRecord rec = SAMv3Handler.sSessionsHash.get(this.nick);
        boolean bl = verbose = !Boolean.parseBoolean(props.getProperty("SILENT"));
        if (rec == null) {
            throw new InterruptedIOException();
        }
        String portStr = props.getProperty("PORT");
        if (portStr == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("receiver port not specified");
            }
            throw new SAMException("receiver port not specified");
        }
        int port = Integer.parseInt(portStr);
        String host = props.getProperty("HOST");
        if (host == null) {
            host = rec.getHandler().getClientIP();
            if (this._log.shouldLog(10)) {
                this._log.debug("no host specified. Taken from the client socket : " + host + ':' + port);
            }
        }
        boolean isSSL = Boolean.parseBoolean(props.getProperty("SSL"));
        if (this._acceptors.get() > 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("an accepting server is already defined for this destination");
            }
            throw new SAMException("an accepting server is already defined for this destination");
        }
        Object object = this.socketServerLock;
        synchronized (object) {
            if (this.socketServer != null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("a forwarding server is already defined for this destination");
                }
                throw new SAMException("a forwarding server is already defined for this destination");
            }
            this.socketServer = this.socketMgr.getServerSocket();
        }
        SocketForwarder forwarder = new SocketForwarder(host, port, isSSL, this, verbose, sendPorts);
        new I2PAppThread(rec.getThreadGroup(), forwarder, "SAMV3StreamForwarder").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private I2PServerSocket getSocketServer() {
        Object object = this.socketServerLock;
        synchronized (object) {
            return this.socketServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopForwardingIncoming() throws SAMException, InterruptedIOException {
        SAMv3Handler.SessionRecord rec = SAMv3Handler.sSessionsHash.get(this.nick);
        if (rec == null) {
            throw new InterruptedIOException();
        }
        I2PServerSocket server = null;
        Object object = this.socketServerLock;
        synchronized (object) {
            if (this.socketServer == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("no socket server is defined for this destination");
                }
                throw new SAMException("no socket server is defined for this destination");
            }
            server = this.socketServer;
            this.socketServer = null;
            if (this._log.shouldLog(10)) {
                this._log.debug("nulling socketServer in stopForwardingIncoming. Object " + this);
            }
        }
        try {
            server.close();
        }
        catch (I2PException i2PException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.socketMgr.destroySocketManager();
    }

    @Override
    public boolean sendBytes(String s, byte[] b, int pr, int fp, int tp) throws DataFormatException {
        throw new DataFormatException(null);
    }

    private static class Pipe
    implements Runnable,
    Handler {
        private final ReadableByteChannel in;
        private final WritableByteChannel out;
        private final ByteBuffer buf;
        private final SAMBridge bridge;

        public Pipe(ReadableByteChannel in, WritableByteChannel out, SAMBridge bridge) {
            this.in = in;
            this.out = out;
            this.buf = ByteBuffer.allocate(1024);
            this.bridge = bridge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.bridge != null) {
                this.bridge.register(this);
            }
            try {
                while (!(Thread.interrupted() || this.in.read(this.buf) < 0 && this.buf.position() == 0)) {
                    this.buf.flip();
                    this.out.write(this.buf);
                    this.buf.compact();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
                try {
                    this.buf.flip();
                    while (this.buf.hasRemaining()) {
                        this.out.write(this.buf);
                    }
                }
                catch (IOException iOException) {}
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                if (this.bridge != null) {
                    this.bridge.unregister(this);
                }
            }
        }

        @Override
        public void stopHandling() {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class SocketForwarder
    implements Runnable {
        private final String host;
        private final int port;
        private final SAMv3StreamSession session;
        private final boolean isSSL;
        private final boolean verbose;
        private final boolean sendPorts;

        SocketForwarder(String host, int port, boolean isSSL, SAMv3StreamSession session, boolean verbose, boolean sendPorts) {
            this.host = host;
            this.port = port;
            this.session = session;
            this.verbose = verbose;
            this.sendPorts = sendPorts;
            this.isSSL = isSSL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (this.session.getSocketServer() != null) {
                SocketChannel clientServerSock;
                I2PSocket i2ps;
                block31: {
                    Log log;
                    try {
                        i2ps = this.session.getSocketServer().accept();
                        if (i2ps == null) {
                            continue;
                        }
                    }
                    catch (SocketTimeoutException ste) {
                        continue;
                    }
                    catch (ConnectException ce) {
                        log = I2PAppContext.getGlobalContext().logManager().getLog(SAMv3StreamSession.class);
                        if (log.shouldLog(30)) {
                            log.warn("Error accepting", ce);
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    catch (I2PException ipe) {
                        log = I2PAppContext.getGlobalContext().logManager().getLog(SAMv3StreamSession.class);
                        if (!log.shouldLog(30)) return;
                        log.warn("Error accepting", ipe);
                        return;
                    }
                    try {
                        if (this.isSSL) {
                            I2PAppContext ctx = I2PAppContext.getGlobalContext();
                            Class<SAMv3StreamSession> clazz = SAMv3StreamSession.class;
                            // MONITORENTER : net.i2p.sam.SAMv3StreamSession.class
                            if (_sslSocketFactory == null) {
                                try {
                                    _sslSocketFactory = new I2PSSLSocketFactory(ctx, true, "certificates/sam");
                                }
                                catch (GeneralSecurityException gse) {
                                    Log log2 = ctx.logManager().getLog(SAMv3StreamSession.class);
                                    log2.error("SSL error", gse);
                                    try {
                                        i2ps.close();
                                        throw new RuntimeException("SSL error", gse);
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    throw new RuntimeException("SSL error", gse);
                                }
                            }
                            // MONITOREXIT : clazz
                            SSLSocket sock = (SSLSocket)_sslSocketFactory.createSocket(this.host, this.port);
                            I2PSSLSocketFactory.verifyHostname(ctx, sock, this.host);
                            clientServerSock = new SSLSocketChannel(sock);
                            break block31;
                        }
                        InetSocketAddress addr = new InetSocketAddress(this.host, this.port);
                        clientServerSock = SocketChannel.open(addr);
                    }
                    catch (IOException ioe) {
                        Log log3 = I2PAppContext.getGlobalContext().logManager().getLog(SAMv3StreamSession.class);
                        if (log3.shouldLog(30)) {
                            log3.warn("Error forwarding", ioe);
                        }
                        try {
                            i2ps.close();
                        }
                        catch (IOException gse) {}
                        continue;
                    }
                }
                try {
                    clientServerSock.socket().setKeepAlive(true);
                    if (this.verbose) {
                        if (this.sendPorts) {
                            SAMv3Handler.notifyStreamIncomingConnection(clientServerSock, i2ps.getPeerDestination(), i2ps.getPort(), i2ps.getLocalPort());
                        } else {
                            SAMv3Handler.notifyStreamIncomingConnection(clientServerSock, i2ps.getPeerDestination());
                        }
                    }
                    SocketChannel fromClient = clientServerSock;
                    ReadableByteChannel fromI2P = Channels.newChannel(i2ps.getInputStream());
                    SocketChannel toClient = clientServerSock;
                    WritableByteChannel toI2P = Channels.newChannel(i2ps.getOutputStream());
                    new I2PAppThread(new Pipe(fromClient, toI2P, null), "ForwardV3 SAMPipeClientToI2P").start();
                    new I2PAppThread(new Pipe(fromI2P, toClient, null), "ForwardV3 SAMPipeI2PToClient").start();
                }
                catch (IOException e) {
                    try {
                        clientServerSock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        i2ps.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

