/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.sam.ReadLine;
import net.i2p.sam.SAMBridge;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv1Handler;
import net.i2p.sam.SAMv3StreamSession;
import net.i2p.util.PasswordManager;

class SAMv3Handler
extends SAMv1Handler {
    private Session session;
    public static final SessionsDB sSessionsHash = new SessionsDB();
    private volatile boolean stolenSocket;
    private volatile boolean streamForwardingSocket;
    private final boolean sendPorts;
    private long _lastPing;
    private static final int FIRST_READ_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 180000;

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor, SAMBridge parent) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties(), parent);
    }

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps, SAMBridge parent) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps, parent);
        boolean bl = this.sendPorts = verMajor == 3 && verMinor >= 2 || verMajor > 3;
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM version 3 handler instantiated");
        }
    }

    @Override
    public boolean verifVersion() {
        return this.verMajor == 3;
    }

    public String getClientIP() {
        return this.socket.socket().getInetAddress().getHostAddress();
    }

    public void stealSocket() {
        this.stolenSocket = true;
        if (this.sendPorts) {
            try {
                this.socket.socket().setSoTimeout(0);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        this.stopHandling();
    }

    SAMBridge getBridge() {
        return this.bridge;
    }

    Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() {
        String msg = null;
        String domain = null;
        String opcode = null;
        boolean canContinue = false;
        this.thread.setName("SAMv3Handler " + this._id);
        if (this._log.shouldLog(10)) {
            this._log.debug("SAMv3 handling started");
        }
        try {
            Socket socket = this.getClientSocket().socket();
            InputStream in = socket.getInputStream();
            StringBuilder buf = new StringBuilder(1024);
            boolean gotFirstLine = false;
            while (true) {
                Properties props;
                String line;
                block87: {
                    if (this.shouldStop()) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Stop request found");
                        }
                        break;
                    }
                    if (this.sendPorts) {
                        try {
                            ReadLine.readLine(socket, buf, 180000);
                            line = buf.toString();
                            buf.setLength(0);
                            break block87;
                        }
                        catch (SocketTimeoutException ste) {
                            long now = System.currentTimeMillis();
                            if (buf.length() <= 0) {
                                if (this._lastPing > 0L) {
                                    if (now - this._lastPing >= 180000L) {
                                        if (this._log.shouldWarn()) {
                                            this._log.warn("Failed to respond to PING");
                                        }
                                        this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"PONG timeout\"\n");
                                        break;
                                    }
                                } else {
                                    if (this._log.shouldDebug()) {
                                        this._log.debug("Sendng PING " + now);
                                    }
                                    this._lastPing = now;
                                    if (!this.writeString("PING " + now + '\n')) {
                                        break;
                                    }
                                }
                            } else if (this._lastPing > 0L) {
                                if (now - this._lastPing >= 360000L) {
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("Failed to respond to PING");
                                    }
                                    this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"PONG timeout\"\n");
                                    break;
                                }
                            } else {
                                if (this._lastPing < 0L) {
                                    if (this._log.shouldWarn()) {
                                        this._log.warn("2nd timeout");
                                    }
                                    this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"command timeout, bye\"\n");
                                    break;
                                }
                                this._lastPing = -1L;
                                if (this._log.shouldWarn()) {
                                    this._log.warn("timeout after partial: " + buf);
                                }
                            }
                            if (!this._log.shouldDebug()) continue;
                            this._log.debug("loop after timeout");
                            continue;
                        }
                    }
                    buf.setLength(0);
                    try {
                        ReadLine.readLine(socket, buf, gotFirstLine ? 0 : 60000);
                        socket.setSoTimeout(0);
                    }
                    catch (SocketTimeoutException ste) {
                        this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"command timeout, bye\"\n");
                        break;
                    }
                    line = buf.toString();
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("New message received: [" + line + ']');
                }
                if ((domain = (String)(props = SAMUtils.parseParams(line)).remove("\"\"COMMAND\"\"")) == null) {
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Ignoring newline");
                    continue;
                }
                gotFirstLine = true;
                opcode = (String)props.remove("\"\"OPCODE\"\"");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Parsing (domain: \"" + domain + "\"; opcode: \"" + opcode + "\")");
                }
                if (domain.equals("PING")) {
                    this.execPingMessage(opcode);
                    continue;
                }
                if (domain.equals("PONG")) {
                    this.execPongMessage(opcode);
                    continue;
                }
                if (domain.equals("QUIT") || domain.equals("STOP") || domain.equals("EXIT")) {
                    this.writeString(domain + " STATUS RESULT=OK MESSAGE=bye\n");
                    break;
                }
                if (opcode == null) {
                    if (this.writeString(domain + " STATUS RESULT=I2P_ERROR MESSAGE=\"command not specified\"\n")) {
                        continue;
                    }
                    break;
                }
                if (domain.equals("STREAM")) {
                    canContinue = this.execStreamMessage(opcode, props);
                } else if (domain.equals("SESSION")) {
                    if (this.i2cpProps != null) {
                        props.putAll((Map<?, ?>)this.i2cpProps);
                    }
                    canContinue = this.execSessionMessage(opcode, props);
                } else if (domain.equals("DEST")) {
                    canContinue = this.execDestMessage(opcode, props);
                } else if (domain.equals("NAMING")) {
                    canContinue = this.execNamingMessage(opcode, props);
                } else if (domain.equals("DATAGRAM")) {
                    canContinue = this.execDatagramMessage(opcode, props);
                } else if (domain.equals("RAW")) {
                    canContinue = this.execRawMessage(opcode, props);
                } else {
                    if (!domain.equals("AUTH")) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Unrecognized message domain: \"" + domain + "\"");
                        }
                        break;
                    }
                    canContinue = this.execAuthMessage(opcode, props);
                }
                if (!canContinue) break;
            }
        }
        catch (IOException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Caught IOException in handler", e);
            }
        }
        catch (SAMException e) {
            this._log.error("Unexpected exception for message [" + msg + ']', e);
        }
        catch (RuntimeException e) {
            this._log.error("Unexpected exception for message [" + msg + ']', e);
        }
        finally {
            block89: {
                block88: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Stopping handler");
                    }
                    if (!this.stolenSocket) {
                        try {
                            this.closeClientSocket();
                        }
                        catch (IOException e) {
                            if (!this._log.shouldWarn()) break block88;
                            this._log.warn("Error closing socket", e);
                        }
                    }
                }
                if (this.streamForwardingSocket && this.getStreamSession() != null) {
                    try {
                        ((SAMv3StreamSession)this.streamSession).stopForwardingIncoming();
                    }
                    catch (SAMException e) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Error while stopping forwarding connections", e);
                        }
                    }
                    catch (InterruptedIOException e) {
                        if (!this._log.shouldWarn()) break block89;
                        this._log.warn("Interrupted while stopping forwarding connections", e);
                    }
                }
            }
            this.die();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopHandling() {
        if (this._log.shouldInfo()) {
            this._log.info("Stopping (stolen? " + this.stolenSocket + "): " + this, new Exception("I did it"));
        }
        Object object = this.stopLock;
        synchronized (object) {
            this.stopHandler = true;
        }
        if (!this.stolenSocket) {
            try {
                this.closeClientSocket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.bridge.unregister(this);
    }

    private void die() {
        SessionRecord rec = null;
        if (this.session != null) {
            this.session.close();
            rec = sSessionsHash.get(this.session.getNick());
        }
        if (rec != null) {
            rec.getThreadGroup().interrupt();
            while (rec.getThreadGroup().activeCount() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            rec.getThreadGroup().destroy();
            sSessionsHash.del(this.session.getNick());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean execSessionMessage(String opcode, Properties props) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 57[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SAMv3StreamSession newSAMStreamSession(String login) throws IOException, DataFormatException, SAMException {
        return new SAMv3StreamSession(login);
    }

    @Override
    protected boolean execStreamMessage(String opcode, Properties props) {
        String nick = null;
        SessionRecord rec = null;
        if (this.session != null) {
            this._log.error("STREAM message received, but this session is a master session");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "master session cannot be used for streams");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        nick = props.getProperty("ID");
        if (nick == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("SESSION ID parameter not specified");
            }
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "ID not specified");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        props.remove("ID");
        rec = sSessionsHash.get(nick);
        if (rec == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("STREAM SESSION ID does not exist");
            }
            try {
                this.notifyStreamResult(true, "INVALID_ID", "STREAM SESSION ID does not exist");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        this.streamSession = rec.getHandler().streamSession;
        if (this.streamSession == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("specified ID is not a stream session");
            }
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "specified ID is not a STREAM session");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("ACCEPT")) {
            return this.execStreamAccept(props);
        }
        if (opcode.equals("FORWARD")) {
            return this.execStreamForwardIncoming(props);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized STREAM message opcode: \"" + opcode + "\"");
        }
        try {
            this.notifyStreamResult(true, "I2P_ERROR", "Unrecognized STREAM message opcode: " + opcode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean execStreamConnect(Properties props) {
        boolean verbose = !Boolean.parseBoolean(props.getProperty("SILENT"));
        try {
            if (props.isEmpty()) {
                this.notifyStreamResult(verbose, "I2P_ERROR", "No parameters specified in STREAM CONNECT message");
                if (this._log.shouldLog(10)) {
                    this._log.debug("No parameters specified in STREAM CONNECT message");
                }
                return false;
            }
            String dest = props.getProperty("DESTINATION");
            if (dest == null) {
                this.notifyStreamResult(verbose, "I2P_ERROR", "Destination not specified in STREAM CONNECT message");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Destination not specified in STREAM CONNECT message");
                }
                return false;
            }
            props.remove("DESTINATION");
            try {
                ((SAMv3StreamSession)this.streamSession).connect(this, dest, props);
                return true;
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid destination in STREAM CONNECT message");
                }
                this.notifyStreamResult(verbose, "INVALID_KEY", null);
            }
            catch (ConnectException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "CONNECTION_REFUSED", null);
            }
            catch (NoRouteToHostException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "CANT_REACH_PEER", null);
            }
            catch (InterruptedIOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "TIMEOUT", null);
            }
            catch (I2PException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean execStreamForwardIncoming(Properties props) {
        try {
            try {
                this.streamForwardingSocket = true;
                ((SAMv3StreamSession)this.streamSession).startForwardingIncoming(props, this.sendPorts);
                this.notifyStreamResult(true, "OK", null);
                return true;
            }
            catch (SAMException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Forwarding STREAM connections failed", e);
                }
                this.notifyStreamResult(true, "I2P_ERROR", "Forwarding failed : " + e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean execStreamAccept(Properties props) {
        boolean verbose = !Boolean.parseBoolean(props.getProperty("SILENT"));
        try {
            try {
                this.notifyStreamResult(verbose, "OK", null);
                ((SAMv3StreamSession)this.streamSession).accept(this, verbose);
                return true;
            }
            catch (InterruptedIOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "TIMEOUT", e.getMessage());
            }
            catch (I2PException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
            catch (SAMException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "ALREADY_ACCEPTING", null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void notifyStreamResult(boolean verbose, String result, String message) throws IOException {
        if (!verbose) {
            return;
        }
        String msgString = SAMv3Handler.createMessageString(message);
        String out = "STREAM STATUS RESULT=" + result + msgString + '\n';
        if (!this.writeString(out)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public void notifyStreamIncomingConnection(Destination d, int fromPort, int toPort) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        StringBuilder buf = new StringBuilder(600);
        buf.append(d.toBase64());
        if (this.sendPorts) {
            buf.append(" FROM_PORT=").append(fromPort).append(" TO_PORT=").append(toPort);
        }
        buf.append('\n');
        if (!this.writeString(buf.toString())) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static void notifyStreamIncomingConnection(SocketChannel client, Destination d) throws IOException {
        if (!SAMv3Handler.writeString(d.toBase64() + "\n", client)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static void notifyStreamIncomingConnection(SocketChannel client, Destination d, int fromPort, int toPort) throws IOException {
        if (!SAMv3Handler.writeString(d.toBase64() + " FROM_PORT=" + fromPort + " TO_PORT=" + toPort + '\n', client)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    private boolean execAuthMessage(String opcode, Properties props) {
        String user;
        if (opcode.equals("ENABLE")) {
            this.i2cpProps.setProperty("sam.auth", "true");
        } else if (opcode.equals("DISABLE")) {
            this.i2cpProps.setProperty("sam.auth", "false");
        } else if (opcode.equals("ADD")) {
            user = props.getProperty("USER");
            String pw = props.getProperty("PASSWORD");
            if (user == null || pw == null) {
                return this.writeString("AUTH STATUS RESULT=I2P_ERROR MESSAGE=\"USER and PASSWORD required\"\n");
            }
            String prop = "sam.auth." + user + ".shash";
            if (this.i2cpProps.containsKey(prop)) {
                return this.writeString("AUTH STATUS RESULT=I2P_ERROR MESSAGE=\"user " + user + " already exists\"\n");
            }
            PasswordManager pm = new PasswordManager(I2PAppContext.getGlobalContext());
            String shash = pm.createHash(pw);
            this.i2cpProps.setProperty(prop, shash);
        } else if (opcode.equals("REMOVE")) {
            user = props.getProperty("USER");
            if (user == null) {
                return this.writeString("AUTH STATUS RESULT=I2P_ERROR MESSAGE=\"USER required\"\n");
            }
            String prop = "sam.auth." + user + ".shash";
            if (!this.i2cpProps.containsKey(prop)) {
                return this.writeString("AUTH STATUS RESULT=I2P_ERROR MESSAGE=\"user " + user + " not found\"\n");
            }
            this.i2cpProps.remove(prop);
        } else {
            return this.writeString("AUTH STATUS RESULT=I2P_ERROR MESSAGE=\"Unknown AUTH command\"\n");
        }
        try {
            this.bridge.saveConfig();
            return this.writeString("AUTH STATUS RESULT=OK\n");
        }
        catch (IOException ioe) {
            return this.writeString("AUTH STATUS RESULT=I2P_ERROR MESSAGE=\"Config save failed: " + ioe + "\"\n");
        }
    }

    private void execPingMessage(String msg) {
        StringBuilder buf = new StringBuilder();
        buf.append("PONG");
        if (msg != null) {
            buf.append(' ').append(msg);
        }
        buf.append('\n');
        this.writeString(buf.toString());
    }

    private void execPongMessage(String s) {
        if (s == null) {
            s = "";
        }
        if (this._lastPing > 0L) {
            String expected = Long.toString(this._lastPing);
            if (expected.equals(s)) {
                this._lastPing = 0L;
                if (this._log.shouldInfo()) {
                    this._log.warn("Got expected pong: " + s);
                }
            } else if (this._log.shouldInfo()) {
                this._log.warn("Got unexpected pong: " + s);
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn("Pong received without a ping: " + s);
        }
    }

    static interface Session {
        public String getNick();

        public void close();

        public boolean sendBytes(String var1, byte[] var2, int var3, int var4, int var5) throws DataFormatException, I2PSessionException;
    }

    public static class SessionRecord {
        private final String m_dest;
        private final Properties m_props;
        private ThreadGroup m_threadgroup;
        private final SAMv3Handler m_handler;

        public SessionRecord(String dest, Properties props, SAMv3Handler handler) {
            this.m_dest = dest;
            this.m_props = new Properties();
            this.m_props.putAll((Map<?, ?>)props);
            this.m_handler = handler;
        }

        public SessionRecord(SessionRecord in) {
            this.m_dest = in.getDest();
            this.m_props = in.getProps();
            this.m_threadgroup = in.getThreadGroup();
            this.m_handler = in.getHandler();
        }

        public String getDest() {
            return this.m_dest;
        }

        public synchronized Properties getProps() {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)this.m_props);
            return this.m_props;
        }

        public SAMv3Handler getHandler() {
            return this.m_handler;
        }

        public synchronized ThreadGroup getThreadGroup() {
            return this.m_threadgroup;
        }

        public synchronized void createThreadGroup(String name) {
            if (this.m_threadgroup == null) {
                this.m_threadgroup = new ThreadGroup(name);
            }
        }
    }

    public static class SessionsDB {
        private static final long serialVersionUID = 1L;
        private final HashMap<String, SessionRecord> map = new HashMap();

        public synchronized boolean put(String nick, SessionRecord session) throws ExistingIdException, ExistingDestException {
            if (this.map.containsKey(nick)) {
                throw new ExistingIdException();
            }
            for (SessionRecord r : this.map.values()) {
                if (!r.getDest().equals(session.getDest())) continue;
                throw new ExistingDestException();
            }
            if (!this.map.containsKey(nick)) {
                session.createThreadGroup("SAM session " + nick);
                this.map.put(nick, session);
                return true;
            }
            return false;
        }

        public synchronized boolean del(String nick) {
            return this.map.remove(nick) != null;
        }

        public synchronized SessionRecord get(String nick) {
            return this.map.get(nick);
        }

        public synchronized boolean containsKey(String nick) {
            return this.map.containsKey(nick);
        }

        static class ExistingDestException
        extends Exception {
            private static final long serialVersionUID = 1L;

            ExistingDestException() {
            }
        }

        static class ExistingIdException
        extends Exception {
            private static final long serialVersionUID = 1L;

            ExistingIdException() {
            }
        }
    }
}

