/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.naming.NamingService;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.sam.SAMException;

class SAMUtils {
    SAMUtils() {
    }

    public static void genRandomKey(OutputStream priv, OutputStream pub) {
        SAMUtils.genRandomKey(priv, pub, SigType.DSA_SHA1);
    }

    public static void genRandomKey(OutputStream priv, OutputStream pub, SigType sigType) {
        try {
            I2PClient c = I2PClientFactory.createClient();
            Destination d = c.createDestination(priv, sigType);
            priv.flush();
            if (pub != null) {
                d.writeBytes(pub);
                pub.flush();
            }
        }
        catch (I2PException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkDestination(String dest) {
        try {
            Destination d = new Destination();
            d.fromBase64(dest);
            return true;
        }
        catch (DataFormatException e) {
            return false;
        }
    }

    public static boolean checkPrivateDestination(String dest) {
        byte[] b = Base64.decode(dest);
        if (b == null || b.length < 663) {
            return false;
        }
        ByteArrayInputStream destKeyStream = new ByteArrayInputStream(b);
        try {
            Destination d = new Destination();
            d.readBytes(destKeyStream);
            new PrivateKey().readBytes(destKeyStream);
            SigningPrivateKey spk = new SigningPrivateKey(d.getSigningPublicKey().getType());
            spk.readBytes(destKeyStream);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return destKeyStream.available() == 0;
    }

    private static Destination lookupHost(String name) {
        NamingService ns = I2PAppContext.getGlobalContext().namingService();
        Destination dest = ns.lookup(name);
        return dest;
    }

    public static Destination getDest(String s) throws DataFormatException {
        Destination d = SAMUtils.lookupHost(s);
        if (d == null) {
            String msg = s.length() >= 516 ? "Bad Base64 dest: " : (s.length() == 60 && s.endsWith(".b32.i2p") ? "Lease set not found: " : "Host name not found: ");
            throw new DataFormatException(msg + s);
        }
        return d;
    }

    public static Properties parseParams(StringTokenizer tok) throws SAMException {
        int ntoks = tok.countTokens();
        Properties props = new Properties();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < ntoks; ++i) {
            String token = tok.nextToken();
            int pos = token.indexOf("=");
            if (pos <= 0) {
                if (pos == 0) {
                    throw new SAMException("No param specified [" + token + "]");
                }
                throw new SAMException("Bad formatting for param [" + token + "]");
            }
            String param = token.substring(0, pos);
            value.append(token.substring(pos + 1));
            if (value.length() == 0) {
                throw new SAMException("Empty value for param " + param);
            }
            if (value.charAt(0) == '\"') {
                while (i < ntoks && value.lastIndexOf("\"") <= 0) {
                    value.append(' ').append(tok.nextToken());
                    ++i;
                }
            }
            props.setProperty(param, value.toString());
            value.setLength(0);
        }
        return props;
    }
}

