/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.router.web.FormHandler;

public class ConfigStatsHandler
extends FormHandler {
    private String _filename;
    private List<String> _stats = new ArrayList<String>();
    private String _graphs = "";
    private boolean _explicitFilter = false;
    private String _explicitFilterValue;
    private boolean _isFull = false;

    @Override
    protected void processForm() {
        this.saveChanges();
    }

    public void setFilename(String filename) {
        this._filename = filename != null ? filename.trim() : null;
    }

    public void setStatList(String[] stats) {
        if (stats != null) {
            for (int i = 0; i < stats.length; ++i) {
                String cur = stats[i].trim();
                if (cur.length() <= 0 || this._stats.contains(cur)) continue;
                this._stats.add(cur);
            }
        }
    }

    public void setGraphList(String[] stats) {
        if (stats != null) {
            StringBuilder s = new StringBuilder(128);
            for (int i = 0; i < stats.length; ++i) {
                String cur = stats[i].trim();
                if (cur.length() <= 0) continue;
                if (s.length() > 0) {
                    s.append(",");
                }
                s.append(cur);
            }
            this._graphs = s.toString();
        } else {
            this._graphs = "";
        }
    }

    public void setExplicitFilter(String foo) {
        this._explicitFilter = true;
    }

    public void setExplicitFilterValue(String filter) {
        this._explicitFilterValue = filter;
    }

    public void setIsFull(String foo) {
        this._isFull = true;
    }

    private void saveChanges() {
        HashMap<String, String> changes = new HashMap<String, String>();
        if (this._filename == null) {
            this._filename = "stats.log";
        }
        changes.put("stat.logFile", this._filename);
        if (this._explicitFilter) {
            this._stats.clear();
            if (this._explicitFilterValue == null) {
                this._explicitFilterValue = "";
            }
            if (this._explicitFilterValue.indexOf(44) != -1) {
                StringTokenizer tok = new StringTokenizer(this._explicitFilterValue, ",");
                while (tok.hasMoreTokens()) {
                    String cur = tok.nextToken().trim();
                    if (cur.length() <= 0 || this._stats.contains(cur)) continue;
                    this._stats.add(cur);
                }
            } else {
                String stat = this._explicitFilterValue.trim();
                if (stat.length() > 0 && !this._stats.contains(stat)) {
                    this._stats.add(stat);
                }
            }
        }
        StringBuilder stats = new StringBuilder();
        for (int i = 0; i < this._stats.size(); ++i) {
            stats.append(this._stats.get(i));
            if (i + 1 >= this._stats.size()) continue;
            stats.append(',');
        }
        changes.put("stat.logFilters", stats.toString());
        boolean graphsChanged = !this._graphs.equals(this._context.getProperty("stat.summaries"));
        changes.put("stat.summaries", this._graphs);
        boolean fullChanged = this._context.getBooleanProperty("stat.full") != this._isFull;
        changes.put("stat.full", "" + this._isFull);
        this._context.router().saveConfig(changes, null);
        if (!this._stats.isEmpty()) {
            this.addFormNotice(this._t("Stat filter and location updated successfully to") + ": " + stats.toString());
        }
        if (fullChanged) {
            if (this._isFull) {
                this.addFormNotice(this._t("Full statistics enabled"));
            } else {
                this.addFormNotice(this._t("Full statistics disabled"));
            }
            this.addFormNotice(this._t("Restart required to take effect"));
        }
        if (graphsChanged) {
            this.addFormNoticeNoEscape(this._t("Graph list updated, may take up to 60s to be reflected on the {0}Graphs Page{1}", "<a href=\"graphs\">", "</a>"));
        }
    }
}

