/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.util.Log;

public class ConfigLoggingHelper
extends HelperBase {
    private static String[] levels = new String[]{ConfigLoggingHelper._x("CRIT"), ConfigLoggingHelper._x("ERROR"), ConfigLoggingHelper._x("WARN"), ConfigLoggingHelper._x("INFO"), ConfigLoggingHelper._x("DEBUG")};

    public String getLogFilePattern() {
        return this._context.logManager().getBaseLogfilename();
    }

    public String getRecordPattern() {
        return new String(this._context.logManager().getFormat());
    }

    public String getDatePattern() {
        return this._context.logManager().getDateFormatPattern();
    }

    public String getMaxFileSize() {
        int bytes = this._context.logManager().getFileSize();
        if (bytes <= 0) {
            return "1.00 MB";
        }
        return DataHelper.formatSize2(bytes).replace("&nbsp;", " ") + 'B';
    }

    public String getLogLevelTable() {
        StringBuilder buf = new StringBuilder(32768);
        Properties limits = this._context.logManager().getLimits();
        TreeSet<String> sortedLogs = new TreeSet<String>();
        for (String prefix : limits.stringPropertyNames()) {
            sortedLogs.add(prefix);
        }
        buf.append("<textarea name=\"levels\" rows=\"4\" cols=\"60\" wrap=\"off\" spellcheck=\"false\">");
        for (String prefix : sortedLogs) {
            String level = limits.getProperty(prefix);
            buf.append(prefix).append('=').append(level).append('\n');
        }
        buf.append("</textarea><br>\n");
        buf.append("<i>").append(this._t("Add additional logging statements above. Example: net.i2p.router.tunnel=WARN")).append("</i><br>");
        buf.append("<i>").append(this._t("Or put entries in the logger.config file. Example: logger.record.net.i2p.router.tunnel=WARN")).append("</i><br>");
        buf.append("<i>").append(this._t("Valid levels are DEBUG, INFO, WARN, ERROR, CRIT")).append("</i>\n");
        return buf.toString();
    }

    public String getDefaultLogLevelBox() {
        String cur = this._context.logManager().getDefaultLimit();
        return this.getLogLevelBox("defaultloglevel", cur, false);
    }

    private String getLogLevelBox(String name, String cur, boolean showRemove) {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<select name=\"").append(name).append("\">\n");
        for (int i = 0; i < levels.length; ++i) {
            String l = levels[i];
            buf.append("<option value=\"").append(l).append('\"');
            if (l.equals(cur)) {
                buf.append(" selected=\"selected\"");
            }
            buf.append('>').append(this._t(l)).append("</option>\n");
        }
        if (showRemove) {
            buf.append("<option value=\"remove\">").append(this._t("Remove")).append("</option>");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getNewClassBox() {
        List<Log> logs = this._context.logManager().getLogs();
        Set<String> limits = this._context.logManager().getLimits().stringPropertyNames();
        TreeSet<String> sortedLogs = new TreeSet<String>();
        for (Log log : logs) {
            String name = log.getName();
            if (!limits.contains(name)) {
                sortedLogs.add(name);
            }
            int dots = 0;
            int lastdot = -1;
            int nextdot = 0;
            while ((nextdot = name.indexOf(46, lastdot + 1)) > 0) {
                String subst;
                if (++dots >= 3 && !limits.contains(subst = name.substring(0, nextdot))) {
                    sortedLogs.add(subst);
                }
                lastdot = nextdot;
            }
        }
        StringBuilder buf = new StringBuilder(65536);
        buf.append("<select name=\"newlogclass\">\n<option value=\"\" selected=\"selected\">").append(this._t("Select a class to add")).append("</option>\n");
        for (String l : sortedLogs) {
            buf.append("<option value=\"").append(l).append("\">").append(l).append("</option>\n");
        }
        buf.append("</select>\n");
        buf.append(this.getLogLevelBox("newloglevel", "WARN", false));
        return buf.toString();
    }
}

