/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import net.i2p.I2PAppContext;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.util.ConcurrentHashSet;

public class DecayingHashSet
extends DecayingBloomFilter {
    private ConcurrentHashSet<ArrayWrapper> _current;
    private ConcurrentHashSet<ArrayWrapper> _previous;

    public DecayingHashSet(I2PAppContext context, int durationMs, int entryBytes) {
        this(context, durationMs, entryBytes, "DHS");
    }

    public DecayingHashSet(I2PAppContext context, int durationMs, int entryBytes, String name) {
        super(durationMs, entryBytes, name, context);
        if (entryBytes <= 0 || entryBytes > 32) {
            throw new IllegalArgumentException("Bad size");
        }
        this._current = new ConcurrentHashSet(128);
        this._previous = new ConcurrentHashSet(128);
        if (this._log.shouldLog(10)) {
            this._log.debug("New DHS " + name + " entryBytes = " + entryBytes + " cycle (s) = " + durationMs / 1000);
        }
        context.statManager().createRateStat("router.decayingHashSet." + name + ".size", "Size", "Router", new long[]{10 * Math.max(60000, durationMs)});
        context.statManager().createRateStat("router.decayingHashSet." + name + ".dups", "1000000 * Duplicates/Size", "Router", new long[]{10 * Math.max(60000, durationMs)});
    }

    @Override
    public int getInsertedCount() {
        return this._current.size() + this._previous.size();
    }

    @Override
    public double getFalsePositiveRate() {
        if (this._entryBytes <= 8) {
            return 0.0;
        }
        return 1.0 / Math.pow(2.0, 64.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(byte[] entry, int off, int len) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        if (len != this._entryBytes) {
            throw new IllegalArgumentException("Bad entry [" + len + ", expected " + this._entryBytes + "]");
        }
        ArrayWrapper w = new ArrayWrapper(entry, off, len);
        this.getReadLock();
        try {
            boolean bl = this.locked_add(w, true);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public boolean add(long entry) {
        return this.add(entry, true);
    }

    @Override
    public boolean isKnown(long entry) {
        return this.add(entry, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(long entry, boolean addIfNew) {
        ArrayWrapper w = new ArrayWrapper(entry);
        this.getReadLock();
        try {
            boolean bl = this.locked_add(w, addIfNew);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean locked_add(ArrayWrapper w, boolean addIfNew) {
        boolean seen = this._previous.contains((Object)w);
        if (!seen) {
            seen = addIfNew ? !this._current.add((Object)w) : this._current.contains((Object)w);
        }
        if (seen) {
            ++this._currentDuplicates;
        }
        return seen;
    }

    @Override
    public void clear() {
        this._current.clear();
        this._previous.clear();
        this._currentDuplicates = 0L;
    }

    @Override
    public void stopDecaying() {
        this._keepDecaying = false;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decay() {
        long dups;
        int currentCount;
        if (!this.getWriteLock()) {
            return;
        }
        try {
            ConcurrentHashSet<ArrayWrapper> tmp = this._previous;
            currentCount = this._current.size();
            this._previous = this._current;
            this._current = tmp;
            this._current.clear();
            dups = this._currentDuplicates;
            this._currentDuplicates = 0L;
        }
        finally {
            this.releaseWriteLock();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Decaying the filter " + this._name + " after inserting " + currentCount + " elements and " + dups + " false positives");
        }
        this._context.statManager().addRateData("router.decayingHashSet." + this._name + ".size", (long)currentCount);
        if (currentCount > 0) {
            this._context.statManager().addRateData("router.decayingHashSet." + this._name + ".dups", 1000000L * dups / (long)currentCount);
        }
    }

    private static class ArrayWrapper {
        private final long _longhashcode;

        public ArrayWrapper(byte[] b, int offset, int len) {
            int idx = offset;
            int shift = Math.min(8, 64 / len);
            long lhc = 0L;
            for (int i = 0; i < len; ++i) {
                lhc ^= (long)b[idx++] << i * shift;
            }
            this._longhashcode = lhc;
        }

        public ArrayWrapper(long b) {
            this._longhashcode = b;
        }

        public int hashCode() {
            return (int)this._longhashcode;
        }

        public long longHashCode() {
            return this._longhashcode;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ArrayWrapper)) {
                return false;
            }
            return ((ArrayWrapper)o).longHashCode() == this._longhashcode;
        }
    }
}

