/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.I2PThread;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;

class TunnelGatewayPumper
implements Runnable {
    private final RouterContext _context;
    private final Set<PumpedTunnelGateway> _wantsPumping;
    private final Set<PumpedTunnelGateway> _backlogged;
    private volatile boolean _stop;
    private static final int MIN_PUMPERS = 1;
    private static final int MAX_PUMPERS = 4;
    private final int _pumpers;
    private static final long REQUEUE_TIME = 50L;
    private static final int POISON_PTG = -99999;

    public TunnelGatewayPumper(RouterContext ctx) {
        this._context = ctx;
        this._wantsPumping = new LinkedHashSet<PumpedTunnelGateway>(16);
        this._backlogged = new HashSet<PumpedTunnelGateway>(16);
        if (ctx.getBooleanProperty("i2p.dummyTunnelManager")) {
            this._pumpers = 1;
        } else {
            long maxMemory = SystemVersion.getMaxMemory();
            this._pumpers = (int)Math.max(1L, Math.min(4L, 1L + maxMemory / 0x2000000L));
        }
        for (int i = 0; i < this._pumpers; ++i) {
            new I2PThread((Runnable)this, "Tunnel GW pumper " + (i + 1) + '/' + this._pumpers, true).start();
        }
    }

    public void stopPumping() {
        int i;
        this._stop = true;
        this._wantsPumping.clear();
        for (i = 0; i < this._pumpers; ++i) {
            PoisonPTG poison = new PoisonPTG(this._context);
            this.wantsPumping(poison);
        }
        for (i = 1; i <= 5 && !this._wantsPumping.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._wantsPumping.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsPumping(PumpedTunnelGateway gw) {
        if (!this._stop) {
            Set<PumpedTunnelGateway> set = this._wantsPumping;
            synchronized (set) {
                if (!this._backlogged.contains(gw) && this._wantsPumping.add(gw)) {
                    this._wantsPumping.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TunnelGateway gw = null;
        ArrayList<PendingGatewayMessage> queueBuf = new ArrayList<PendingGatewayMessage>(32);
        boolean requeue = false;
        while (!this._stop) {
            try {
                Set<PumpedTunnelGateway> set = this._wantsPumping;
                synchronized (set) {
                    if (requeue && gw != null) {
                        this._wantsPumping.remove(gw);
                        if (this._backlogged.add((PumpedTunnelGateway)gw)) {
                            this._context.simpleTimer2().addEvent((SimpleTimer.TimedEvent)new Requeue((PumpedTunnelGateway)gw), 50L);
                        }
                    }
                    gw = null;
                    if (this._wantsPumping.isEmpty()) {
                        this._wantsPumping.wait();
                    } else {
                        Iterator<PumpedTunnelGateway> iter = this._wantsPumping.iterator();
                        gw = iter.next();
                        iter.remove();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (gw == null) continue;
            if (gw.getMessagesSent() == -99999) break;
            requeue = ((PumpedTunnelGateway)gw).pump(queueBuf);
        }
    }

    private static class PoisonPTG
    extends PumpedTunnelGateway {
        public PoisonPTG(RouterContext ctx) {
            super(ctx, null, null, null, null);
        }

        @Override
        public int getMessagesSent() {
            return -99999;
        }
    }

    private class Requeue
    implements SimpleTimer.TimedEvent {
        private final PumpedTunnelGateway _ptg;

        public Requeue(PumpedTunnelGateway ptg) {
            this._ptg = ptg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            Set set = TunnelGatewayPumper.this._wantsPumping;
            synchronized (set) {
                TunnelGatewayPumper.this._backlogged.remove(this._ptg);
                if (TunnelGatewayPumper.this._wantsPumping.add(this._ptg)) {
                    TunnelGatewayPumper.this._wantsPumping.notify();
                }
            }
        }
    }
}

