/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.Service;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.tunnel.BatchedRouterPreprocessor;
import net.i2p.router.tunnel.BloomFilterIVValidator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.InboundEndpointProcessor;
import net.i2p.router.tunnel.InboundGatewayReceiver;
import net.i2p.router.tunnel.InboundSender;
import net.i2p.router.tunnel.OutboundReceiver;
import net.i2p.router.tunnel.OutboundSender;
import net.i2p.router.tunnel.OutboundTunnelEndpoint;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.router.tunnel.ThrottledPumpedTunnelGateway;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.router.tunnel.TunnelGatewayPumper;
import net.i2p.router.tunnel.TunnelGatewayZeroHop;
import net.i2p.router.tunnel.TunnelParticipant;
import net.i2p.util.Log;

public class TunnelDispatcher
implements Service {
    private final RouterContext _context;
    private final Log _log;
    private final ConcurrentHashMap<TunnelId, TunnelGateway> _outboundGateways;
    private final ConcurrentHashMap<TunnelId, OutboundTunnelEndpoint> _outboundEndpoints;
    private final ConcurrentHashMap<TunnelId, TunnelParticipant> _participants;
    private final ConcurrentHashMap<TunnelId, TunnelGateway> _inboundGateways;
    private final ConcurrentHashMap<TunnelId, HopConfig> _participatingConfig;
    private long _lastParticipatingExpiration;
    private BloomFilterIVValidator _validator;
    private final LeaveTunnel _leaveJob;
    private final TunnelGatewayPumper _pumper;
    private final Object _joinParticipantLock = new Object();
    private static final long[] RATES = new long[]{600000L, 3600000L, 10800000L, 86400000L};
    private static final long MAX_FUTURE_EXPIRATION = 240000L;

    public TunnelDispatcher(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelDispatcher.class);
        this._outboundGateways = new ConcurrentHashMap();
        this._outboundEndpoints = new ConcurrentHashMap();
        this._participants = new ConcurrentHashMap();
        this._inboundGateways = new ConcurrentHashMap();
        this._participatingConfig = new ConcurrentHashMap();
        this._pumper = new TunnelGatewayPumper(ctx);
        this._leaveJob = new LeaveTunnel(ctx);
        ctx.statManager().createRequiredRateStat("tunnel.participatingTunnels", "Tunnels routed for others", "Tunnels", new long[]{60000L, 600000L, 3600000L, 10800000L, 86400000L});
        ctx.statManager().createRateStat("tunnel.dispatchOutboundPeer", "How many messages we send out a tunnel targetting a peer?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchOutboundTunnel", "How many messages we send out a tunnel targetting a tunnel?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchInbound", "How many messages we send through our tunnel gateway?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchParticipant", "How many messages we send through a tunnel we are participating in?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.dispatchEndpoint", "How many messages we receive as the outbound endpoint of a tunnel?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinOutboundGateway", "How many tunnels we join as the outbound gateway?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinOutboundGatewayZeroHop", "How many zero hop tunnels we join as the outbound gateway?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinInboundEndpoint", "How many tunnels we join as the inbound endpoint?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinInboundEndpointZeroHop", "How many zero hop tunnels we join as the inbound endpoint?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinParticipant", "How many tunnels we join as a participant?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinOutboundEndpoint", "How many tunnels we join as the outbound endpoint?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.joinInboundGateway", "How many tunnels we join as the inbound gateway?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRequiredRateStat("tunnel.participatingBandwidth", "Participating traffic received (Bytes/sec)", "Tunnels", new long[]{60000L, 600000L});
        ctx.statManager().createRequiredRateStat("tunnel.participatingBandwidthOut", "Participating traffic sent (Bytes/sec)", "Tunnels", new long[]{60000L, 600000L});
        ctx.statManager().createRateStat("tunnel.participatingMessageDropped", "Dropped for exceeding share limit", "Tunnels", new long[]{60000L, 600000L});
        ctx.statManager().createRequiredRateStat("tunnel.participatingMessageCount", "Number of 1KB participating messages", "Tunnels", new long[]{60000L, 600000L, 3600000L});
        ctx.statManager().createRequiredRateStat("tunnel.participatingMessageCountAvgPerTunnel", "Estimate of participating messages per tunnel lifetime", "Tunnels", new long[]{60000L});
        ctx.statManager().createRateStat("tunnel.ownedMessageCount", "How many messages are sent through a tunnel we created (period == failures)?", "Tunnels", new long[]{60000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.failedCompletelyMessages", "How many messages are sent through a tunnel that failed prematurely (period == failures)?", "Tunnels", new long[]{60000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.failedPartially", "How many messages are sent through a tunnel that only failed partially (period == failures)?", "Tunnels", new long[]{60000L, 600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchMultipleCount", "How many messages are batched into a tunnel message", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchDelay", "How many messages were pending when the batching waited", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchDelaySent", "How many messages were flushed when the batching delay completed", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchCount", "How many groups of messages were flushed together", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchDelayAmount", "How long we should wait before flushing the batch", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchFlushRemaining", "How many messages remain after flushing", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.writeDelay", "How long after a message reaches the gateway is it processed (lifetime is size)", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchSmallFragments", "How many outgoing pad bytes are in small fragments?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchFullFragments", "How many outgoing tunnel messages use the full data area?", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.batchFragmentation", "Avg. number of fragments per msg", "Tunnels", new long[]{600000L, 3600000L});
        ctx.statManager().createRateStat("tunnel.distributeLookupSuccess", "Was a deferred lookup successful?", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.dropAtOBEP", "New conn throttle", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.outboundLookupSuccess", "Was a deferred lookup successful?", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.inboundLookupSuccess", "Was a deferred lookup successful?", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.participantLookupSuccess", "Was a deferred lookup successful?", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.buildRequestDup", "How frequently we get dup build request messages", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.smallFragments", "How many pad bytes are in small fragments?", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.fullFragments", "How many tunnel messages use the full data area?", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.fragmentedComplete", "How many fragments were in a completely received message?", "Tunnels", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.fragmentedDropped", "Number of dropped fragments", "Tunnels", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.corruptMessage", "Corrupt messages received", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.dropDangerousClientTunnelMessage", "(lifetime is the I2NP type)", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.dropDangerousExplTunnelMessage", "(lifetime is the I2NP type)", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.handleLoadClove", "When do we receive load test cloves", "Tunnels", new long[]{3600000L});
        ctx.statManager().createRateStat("tunnel.dropGatewayOverflow", "Dropped message at GW, queue full", "Tunnels", new long[]{3600000L});
    }

    private TunnelGateway.QueuePreprocessor createPreprocessor(HopConfig cfg) {
        return new BatchedRouterPreprocessor(this._context, cfg);
    }

    private TunnelGateway.QueuePreprocessor createPreprocessor(TunnelCreatorConfig cfg) {
        return new BatchedRouterPreprocessor(this._context, cfg);
    }

    public boolean joinOutbound(TunnelCreatorConfig cfg) {
        TunnelGateway gw;
        if (this._log.shouldLog(20)) {
            this._log.info("Outbound built successfully: " + cfg);
        }
        if (cfg.getLength() > 1) {
            TunnelGateway.QueuePreprocessor preproc = this.createPreprocessor(cfg);
            OutboundSender sender = new OutboundSender(this._context, cfg);
            OutboundReceiver receiver = new OutboundReceiver(this._context, cfg);
            gw = new PumpedTunnelGateway(this._context, preproc, sender, receiver, this._pumper);
        } else {
            gw = new TunnelGatewayZeroHop(this._context, cfg);
        }
        TunnelId outId = cfg.getConfig(0).getSendTunnel();
        if (this._outboundGateways.putIfAbsent(outId, gw) != null) {
            return false;
        }
        if (cfg.getLength() > 1) {
            this._context.statManager().addRateData("tunnel.joinOutboundGateway", 1L);
            this._context.messageHistory().tunnelJoined("outbound", cfg);
        } else {
            this._context.statManager().addRateData("tunnel.joinOutboundGatewayZeroHop", 1L);
            this._context.messageHistory().tunnelJoined("outboundZeroHop", cfg);
        }
        return true;
    }

    public boolean joinInbound(TunnelCreatorConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Inbound built successfully: " + cfg);
        }
        if (cfg.getLength() > 1) {
            TunnelParticipant participant = new TunnelParticipant(this._context, new InboundEndpointProcessor(this._context, cfg, this._validator));
            TunnelId recvId = cfg.getConfig(cfg.getLength() - 1).getReceiveTunnel();
            if (this._participants.putIfAbsent(recvId, participant) != null) {
                return false;
            }
            this._context.statManager().addRateData("tunnel.joinInboundEndpoint", 1L);
            this._context.messageHistory().tunnelJoined("inboundEndpoint", cfg);
        } else {
            TunnelGatewayZeroHop gw = new TunnelGatewayZeroHop(this._context, cfg);
            TunnelId recvId = cfg.getConfig(0).getReceiveTunnel();
            if (this._inboundGateways.putIfAbsent(recvId, gw) != null) {
                return false;
            }
            this._context.statManager().addRateData("tunnel.joinInboundEndpointZeroHop", 1L);
            this._context.messageHistory().tunnelJoined("inboundEndpointZeroHop", cfg);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinParticipant(HopConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Joining as participant: " + cfg);
        }
        TunnelId recvId = cfg.getReceiveTunnel();
        TunnelParticipant participant = new TunnelParticipant(this._context, cfg, new HopProcessor(this._context, cfg, this._validator));
        Object object = this._joinParticipantLock;
        synchronized (object) {
            if (this._participatingConfig.putIfAbsent(recvId, cfg) != null) {
                return false;
            }
            if (this._participants.putIfAbsent(recvId, participant) != null) {
                this._participatingConfig.remove(recvId);
                return false;
            }
        }
        this._context.messageHistory().tunnelJoined("participant", cfg);
        this._context.statManager().addRateData("tunnel.joinParticipant", 1L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinOutboundEndpoint(HopConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Joining as OBEP: " + cfg);
        }
        TunnelId recvId = cfg.getReceiveTunnel();
        OutboundTunnelEndpoint endpoint = new OutboundTunnelEndpoint(this._context, cfg, new HopProcessor(this._context, cfg, this._validator));
        Object object = this._joinParticipantLock;
        synchronized (object) {
            if (this._participatingConfig.putIfAbsent(recvId, cfg) != null) {
                return false;
            }
            if (this._outboundEndpoints.putIfAbsent(recvId, endpoint) != null) {
                this._participatingConfig.remove(recvId);
                return false;
            }
        }
        this._context.messageHistory().tunnelJoined("outboundEndpoint", cfg);
        this._context.statManager().addRateData("tunnel.joinOutboundEndpoint", 1L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinInboundGateway(HopConfig cfg) {
        if (this._log.shouldLog(20)) {
            this._log.info("Joining as IBGW: " + cfg);
        }
        TunnelGateway.QueuePreprocessor preproc = this.createPreprocessor(cfg);
        InboundSender sender = new InboundSender(this._context, cfg);
        InboundGatewayReceiver receiver = new InboundGatewayReceiver(this._context, cfg);
        ThrottledPumpedTunnelGateway gw = new ThrottledPumpedTunnelGateway(this._context, preproc, sender, receiver, this._pumper, cfg);
        TunnelId recvId = cfg.getReceiveTunnel();
        Object object = this._joinParticipantLock;
        synchronized (object) {
            if (this._participatingConfig.putIfAbsent(recvId, cfg) != null) {
                return false;
            }
            if (this._inboundGateways.putIfAbsent(recvId, gw) != null) {
                this._participatingConfig.remove(recvId);
                return false;
            }
        }
        this._context.messageHistory().tunnelJoined("inboundGateway", cfg);
        this._context.statManager().addRateData("tunnel.joinInboundGateway", 1L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
        return true;
    }

    public int getParticipatingCount() {
        return this._participatingConfig.size();
    }

    public long getNewOBGWID() {
        long rv;
        TunnelId tid;
        while (this._outboundGateways.containsKey(tid = new TunnelId(rv = 1L + this._context.random().nextLong(0xFFFFFFFDL)))) {
        }
        return rv;
    }

    public long getNewIBEPID() {
        long rv;
        TunnelId tid;
        while (this._participants.containsKey(tid = new TunnelId(rv = 1L + this._context.random().nextLong(0xFFFFFFFDL)))) {
        }
        return rv;
    }

    public long getNewIBZeroHopID() {
        long rv;
        TunnelId tid;
        while (this._inboundGateways.containsKey(tid = new TunnelId(rv = 1L + this._context.random().nextLong(0xFFFFFFFDL)))) {
        }
        return rv;
    }

    public long getLastParticipatingExpiration() {
        return this._lastParticipatingExpiration;
    }

    public void remove(TunnelCreatorConfig cfg) {
        if (cfg.isInbound()) {
            TunnelParticipant participant;
            TunnelId recvId = cfg.getConfig(cfg.getLength() - 1).getReceiveTunnel();
            if (this._log.shouldLog(10)) {
                this._log.debug("removing our own inbound " + cfg);
            }
            if ((participant = this._participants.remove(recvId)) == null) {
                this._inboundGateways.remove(recvId);
            } else {
                for (int i = 0; i < cfg.getLength(); ++i) {
                    Hash peer = cfg.getPeer(i);
                    PeerProfile profile = this._context.profileOrganizer().getProfile(peer);
                    if (profile == null) continue;
                    int ok = participant.getCompleteCount();
                    int fail = participant.getFailedCount();
                    profile.getTunnelHistory().incrementProcessed(ok, fail);
                }
            }
        } else {
            TunnelId outId;
            TunnelGateway gw;
            if (this._log.shouldLog(10)) {
                this._log.debug("removing our own outbound " + cfg);
            }
            if ((gw = this._outboundGateways.remove(outId = cfg.getConfig(0).getSendTunnel())) != null) {
                // empty if block
            }
        }
        long msgs = cfg.getProcessedMessagesCount();
        int failures = cfg.getTunnelFailures();
        boolean failed = cfg.getTunnelFailed();
        this._context.statManager().addRateData("tunnel.ownedMessageCount", msgs, (long)failures);
        if (failed) {
            this._context.statManager().addRateData("tunnel.failedCompletelyMessages", msgs, (long)failures);
        } else if (failures > 0) {
            this._context.statManager().addRateData("tunnel.failedPartiallyMessages", msgs, (long)failures);
        }
    }

    public void remove(HopConfig cfg) {
        boolean removed;
        TunnelId recvId = cfg.getReceiveTunnel();
        boolean bl = removed = null != this._participatingConfig.remove(recvId);
        if (removed) {
            if (this._log.shouldLog(10)) {
                this._log.debug("removing " + cfg);
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Participating tunnel, but no longer listed in participatingConfig? " + cfg);
        }
        boolean bl2 = removed = null != this._participants.remove(recvId);
        if (removed) {
            return;
        }
        boolean bl3 = removed = null != this._inboundGateways.remove(recvId);
        if (removed) {
            return;
        }
        this._outboundEndpoints.remove(recvId);
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        TunnelParticipant participant = this._participants.get(msg.getTunnelIdObj());
        if (participant != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("dispatch to participant " + participant + ": " + msg.getUniqueId() + " from " + recvFrom.toBase64().substring(0, 4));
            }
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), msg.getTunnelId(), "participant");
            participant.dispatch(msg, recvFrom);
            this._context.statManager().addRateData("tunnel.dispatchParticipant", 1L);
        } else {
            OutboundTunnelEndpoint endpoint = this._outboundEndpoints.get(msg.getTunnelIdObj());
            if (endpoint != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("dispatch where we are the outbound endpoint: " + endpoint + ": " + msg + " from " + recvFrom.toBase64().substring(0, 4));
                }
                this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), msg.getTunnelId(), "outbound endpoint");
                endpoint.dispatch(msg, recvFrom);
                this._context.statManager().addRateData("tunnel.dispatchEndpoint", 1L);
            } else {
                int level;
                this._context.messageHistory().droppedTunnelDataMessageUnknown(msg.getUniqueId(), msg.getTunnelId());
                int n = level = this._context.router().getUptime() > 600000L ? 30 : 10;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "no matching participant/endpoint for id=" + msg.getTunnelId() + " expiring in " + DataHelper.formatDuration((long)(msg.getMessageExpiration() - this._context.clock().now())) + ": existing = " + this._participants.size() + " / " + this._outboundEndpoints.size());
                }
            }
        }
    }

    public void dispatch(TunnelGatewayMessage msg) {
        long before = this._context.clock().now();
        TunnelGateway gw = this._inboundGateways.get(msg.getTunnelId());
        if (gw != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("dispatch where we are the inbound gateway: " + gw + ": " + msg);
            }
            long minTime = before - 60000L;
            long maxTime = before + 240000L;
            if (msg.getMessageExpiration() < minTime || msg.getMessage().getMessageExpiration() < minTime || msg.getMessageExpiration() > maxTime || msg.getMessage().getMessageExpiration() > maxTime) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Not dispatching a gateway message for tunnel " + msg.getTunnelId().getTunnelId() + " as the wrapper's expiration is in " + DataHelper.formatDuration((long)(msg.getMessageExpiration() - before)) + " and/or the content's expiration is in " + DataHelper.formatDuration((long)(msg.getMessage().getMessageExpiration() - before)) + " with messageId " + msg.getUniqueId() + "/" + msg.getMessage().getUniqueId() + " and message type " + msg.getMessage().getClass().getSimpleName());
                }
                return;
            }
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), msg.getMessage().getUniqueId(), msg.getTunnelId().getTunnelId(), "inbound gateway");
            gw.add(msg);
            this._context.statManager().addRateData("tunnel.dispatchInbound", 1L);
        } else {
            int level;
            this._context.messageHistory().droppedTunnelGatewayMessageUnknown(msg.getUniqueId(), msg.getTunnelId().getTunnelId());
            int n = level = this._context.router().getUptime() > 600000L ? 30 : 20;
            if (this._log.shouldLog(level)) {
                this._log.log(level, "no matching tunnel for id=" + msg.getTunnelId().getTunnelId() + ": gateway message expiring in " + DataHelper.formatDuration((long)(msg.getMessageExpiration() - this._context.clock().now())) + "/" + DataHelper.formatDuration((long)(msg.getMessage().getMessageExpiration() - this._context.clock().now())) + " messageId " + msg.getUniqueId() + "/" + msg.getMessage().getUniqueId() + " messageType: " + msg.getMessage().getClass().getSimpleName() + " existing = " + this._inboundGateways.size(), (Throwable)new Exception("source"));
            }
        }
    }

    public void dispatchOutbound(I2NPMessage msg, TunnelId outboundTunnel, Hash targetPeer) {
        this.dispatchOutbound(msg, outboundTunnel, null, targetPeer);
    }

    public void dispatchOutbound(I2NPMessage msg, TunnelId outboundTunnel, TunnelId targetTunnel, Hash targetPeer) {
        if (outboundTunnel == null) {
            throw new IllegalArgumentException("null outbound tunnel?");
        }
        long before = this._context.clock().now();
        TunnelGateway gw = this._outboundGateways.get(outboundTunnel);
        if (gw != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("dispatch outbound through " + outboundTunnel.getTunnelId() + ": " + msg);
            }
            if (msg.getMessageExpiration() < before - 60000L) {
                if (this._log.shouldLog(40)) {
                    this._log.error("why are you sending a tunnel message that expired " + (before - msg.getMessageExpiration()) + "ms ago? " + msg, (Throwable)new Exception("cause"));
                }
                return;
            }
            if (msg.getMessageExpiration() < before) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("why are you sending a tunnel message that expired " + (before - msg.getMessageExpiration()) + "ms ago? " + msg, (Throwable)new Exception("cause"));
                }
            } else if (msg.getMessageExpiration() > before + 240000L) {
                if (this._log.shouldLog(40)) {
                    this._log.error("why are you sending a tunnel message that expires " + (msg.getMessageExpiration() - before) + "ms from now? " + msg, (Throwable)new Exception("cause"));
                }
                return;
            }
            long tid1 = outboundTunnel.getTunnelId();
            long tid2 = targetTunnel != null ? targetTunnel.getTunnelId() : -1L;
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), tid1, tid2, targetPeer, "outbound gateway");
            gw.add(msg, targetPeer, targetTunnel);
            if (targetTunnel == null) {
                this._context.statManager().addRateData("tunnel.dispatchOutboundPeer", 1L);
            } else {
                this._context.statManager().addRateData("tunnel.dispatchOutboundTunnel", 1L);
            }
        } else {
            this._context.messageHistory().droppedTunnelGatewayMessageUnknown(msg.getUniqueId(), outboundTunnel.getTunnelId());
            int level = 30;
            if (this._log.shouldLog(level)) {
                this._log.log(level, "no matching outbound tunnel for id=" + outboundTunnel + ": existing = " + this._outboundGateways.size(), (Throwable)new Exception("src"));
            }
        }
    }

    public List<HopConfig> listParticipatingTunnels() {
        return new ArrayList<HopConfig>(this._participatingConfig.values());
    }

    public void updateParticipatingStats(int ms) {
        long count = 0L;
        long bw = 0L;
        long tcount = 0L;
        long tooYoung = this._context.clock().now() - 60000L;
        long tooOld = tooYoung - 540000L;
        for (HopConfig cfg : this._participatingConfig.values()) {
            long c = cfg.getAndResetRecentMessagesCount();
            bw += c;
            long created = cfg.getCreation();
            if (created > tooYoung || created < tooOld) continue;
            ++tcount;
            count += c;
        }
        if (tcount > 0L) {
            count = count * (long)(600000 / ms) / tcount;
        }
        this._context.statManager().addRateData("tunnel.participatingMessageCountAvgPerTunnel", count, (long)ms);
        this._context.statManager().addRateData("tunnel.participatingMessageCount", bw, (long)ms);
        this._context.statManager().addRateData("tunnel.participatingBandwidth", bw * 1024L / (long)(ms / 1000), (long)ms);
        this._context.statManager().addRateData("tunnel.participatingTunnels", tcount);
    }

    public boolean shouldDropParticipatingMessage(Location loc, int type, int length) {
        float rand;
        boolean reject;
        float share;
        if (length <= 0) {
            return false;
        }
        int used = this._context.bandwidthLimiter().getCurrentParticipatingBandwidth();
        if (used <= 0) {
            return false;
        }
        int maxKBps = Math.min(this._context.bandwidthLimiter().getInboundKBytesPerSecond(), this._context.bandwidthLimiter().getOutboundKBytesPerSecond());
        float maxBps = (float)maxKBps * (share = (float)this._context.router().getSharePercentage()) * 1228.8f;
        float pctDrop = ((float)used - maxBps) / (float)used;
        if (pctDrop <= 0.0f) {
            return false;
        }
        double len = length;
        if (loc == Location.OBEP) {
            len = type == 23 || type == 21 ? (len /= 1.5) : (len *= 1.5);
        } else if (loc == Location.IBGW) {
            len = type == 24 || type == 22 ? (len /= 3.375) : (len /= 1.5);
        }
        if ((int)len != 1024) {
            pctDrop = (float)Math.pow(pctDrop, 1024.0 / len);
        }
        boolean bl = reject = (rand = this._context.random().nextFloat()) <= pctDrop;
        if (reject) {
            if (this._log.shouldLog(30)) {
                int availBps = (int)((float)(maxKBps * 1024) * share - (float)used);
                this._log.warn("Drop part. msg. avail/max/used " + availBps + "/" + (int)maxBps + "/" + used + " %Drop = " + pctDrop + ' ' + (Object)((Object)loc) + ' ' + type + ' ' + length);
            }
            this._context.statManager().addRateData("tunnel.participatingMessageDropped", 1L);
        }
        return reject;
    }

    @Override
    public synchronized void startup() {
        this._validator = new BloomFilterIVValidator(this._context, TunnelDispatcher.getShareBandwidth(this._context));
    }

    public static int getShareBandwidth(RouterContext ctx) {
        int irateKBps = ctx.bandwidthLimiter().getInboundKBytesPerSecond();
        int orateKBps = ctx.bandwidthLimiter().getOutboundKBytesPerSecond();
        double pct = ctx.router().getSharePercentage();
        return (int)(pct * (double)Math.min(irateKBps, orateKBps));
    }

    @Override
    public synchronized void shutdown() {
        if (this._validator != null) {
            this._validator.destroy();
        }
        this._validator = null;
        this._pumper.stopPumping();
        this._outboundGateways.clear();
        this._outboundEndpoints.clear();
        this._participants.clear();
        this._inboundGateways.clear();
        this._participatingConfig.clear();
        this._leaveJob.clear();
    }

    @Override
    public void restart() {
        this.shutdown();
        this.startup();
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
    }

    private class LeaveTunnel
    extends JobImpl {
        private final LinkedBlockingQueue<HopConfig> _configs;
        private static final int LEAVE_BATCH_TIME = 10000;

        public LeaveTunnel(RouterContext ctx) {
            super(ctx);
            this._configs = new LinkedBlockingQueue();
            this.getTiming().setStartAfter(ctx.clock().now() + 1200000L);
            this.getContext().jobQueue().addJob(this);
        }

        public void add(HopConfig cfg) {
            this._configs.offer(cfg);
        }

        public void clear() {
            this._configs.clear();
        }

        @Override
        public String getName() {
            return "Expire participating tunnels";
        }

        @Override
        public void runJob() {
            HopConfig cur = null;
            long now = this.getContext().clock().now() + 10000L;
            long nextTime = now + 600000L;
            while ((cur = this._configs.peek()) != null) {
                long exp = cur.getExpiration() + 120000L + 10000L;
                if (exp < now) {
                    this._configs.poll();
                    if (TunnelDispatcher.this._log.shouldLog(20)) {
                        TunnelDispatcher.this._log.info("Expiring " + cur);
                    }
                    TunnelDispatcher.this.remove(cur);
                    continue;
                }
                if (exp >= nextTime) break;
                nextTime = exp;
                break;
            }
            this.getTiming().setStartAfter(nextTime);
            this.getContext().jobQueue().addJob(this);
        }
    }

    static enum Location {
        OBEP,
        PARTICIPANT,
        IBGW;

    }
}

