/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.concurrent.BlockingQueue;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.CoDelBlockingQueue;
import net.i2p.util.HexDump;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class MessageReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final BlockingQueue<InboundMessageState> _completeMessages;
    private volatile boolean _alive;
    private static final int MIN_THREADS = 2;
    private static final int MAX_THREADS = 5;
    private static final int MIN_QUEUE_SIZE = 32;
    private static final int MAX_QUEUE_SIZE = 128;
    private final int _threadCount;
    private static final long POISON_IMS = -99999999999L;

    public MessageReceiver(RouterContext ctx, UDPTransport transport) {
        int qsize;
        this._context = ctx;
        this._log = ctx.logManager().getLog(MessageReceiver.class);
        this._transport = transport;
        long maxMemory = SystemVersion.getMaxMemory();
        if (maxMemory < 0x2000000L) {
            this._threadCount = 1;
            qsize = 16;
        } else if (maxMemory < 0x4000000L) {
            this._threadCount = 2;
            qsize = 32;
        } else {
            this._threadCount = Math.max(2, Math.min(5, ctx.bandwidthLimiter().getInboundKBytesPerSecond() / 20));
            qsize = (int)Math.max(32L, Math.min(128L, maxMemory / 0x200000L));
        }
        this._completeMessages = new CoDelBlockingQueue<InboundMessageState>(ctx, "UDP-MessageReceiver", qsize);
        this._context.statManager().createRateStat("udp.inboundExpired", "How many messages were expired before reception?", "udp", UDPTransport.RATES);
        this._alive = true;
    }

    public synchronized void startup() {
        this._alive = true;
        for (int i = 0; i < this._threadCount; ++i) {
            I2PThread t = new I2PThread((Runnable)new Runner(), "UDP message receiver " + (i + 1) + '/' + this._threadCount, true);
            t.start();
        }
    }

    public synchronized void shutdown() {
        int i;
        this._alive = false;
        this._completeMessages.clear();
        for (i = 0; i < this._threadCount; ++i) {
            InboundMessageState ims = new InboundMessageState(this._context, -99999999999L, null);
            this._completeMessages.offer(ims);
        }
        for (i = 1; i <= 5 && !this._completeMessages.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._completeMessages.clear();
    }

    public void receiveMessage(InboundMessageState state) {
        if (this._alive) {
            try {
                this._completeMessages.put(state);
            }
            catch (InterruptedException ie) {
                this._alive = false;
            }
        }
    }

    public void loop(I2NPMessageHandler handler) {
        InboundMessageState message = null;
        ByteArray buf = new ByteArray(new byte[65536]);
        while (this._alive) {
            block9: {
                int expired = 0;
                long expiredLifetime = 0L;
                try {
                    while (message == null) {
                        message = this._completeMessages.take();
                        if (message != null && message.getMessageId() == -99999999999L) {
                            message = null;
                            break;
                        }
                        if (message == null || !message.isExpired()) continue;
                        expiredLifetime += message.getLifetime();
                        message = null;
                        ++expired;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (expired > 0) {
                    this._context.statManager().addRateData("udp.inboundExpired", (long)expired, expiredLifetime);
                }
                if (message == null) continue;
                int size = message.getCompleteSize();
                try {
                    I2NPMessage msg = this.readMessage(buf, message, handler);
                    if (msg == null) break block9;
                    this._transport.messageReceived(msg, null, message.getFrom(), message.getLifetime(), size);
                }
                catch (RuntimeException re) {
                    this._log.error("b0rked receiving a message.. wazza huzza hmm?", (Throwable)re);
                    continue;
                }
            }
            message = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private I2NPMessage readMessage(ByteArray buf, InboundMessageState state, I2NPMessageHandler handler) {
        try {
            I2NPMessage m;
            Object fragments;
            int numFragments = state.getFragmentCount();
            if (numFragments > 1) {
                fragments = state.getFragments();
                int off = 0;
                for (int i = 0; i < numFragments; ++i) {
                    System.arraycopy(fragments[i].getData(), 0, buf.getData(), off, fragments[i].getValid());
                    off += fragments[i].getValid();
                }
                if (off != state.getCompleteSize()) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Hmm, offset of the fragments = " + off + " while the state says " + state.getCompleteSize());
                    }
                    I2NPMessage i2NPMessage = null;
                    return i2NPMessage;
                }
                m = I2NPMessageImpl.fromRawByteArray(this._context, buf.getData(), 0, state.getCompleteSize(), handler);
            } else {
                m = I2NPMessageImpl.fromRawByteArray(this._context, state.getFragments()[0].getData(), 0, state.getCompleteSize(), handler);
            }
            m.setUniqueId(state.getMessageId());
            fragments = m;
            return fragments;
        }
        catch (I2NPMessageException ime) {
            PeerState ps;
            if (this._log.shouldLog(30)) {
                ByteArray ba = state.getFragmentCount() > 1 ? buf : state.getFragments()[0];
                byte[] data = ba.getData();
                this._log.warn("Message invalid: " + state + " PeerState: " + this._transport.getPeerState(state.getFrom()) + "\nDUMP:\n" + HexDump.dump((byte[])data, (int)0, (int)state.getCompleteSize()) + "\nRAW:\n" + Base64.encode((byte[])data, (int)0, (int)state.getCompleteSize()), (Throwable)((Object)ime));
            }
            if (state.getFragments()[0].getData()[0] == 1 && (ps = this._transport.getPeerState(state.getFrom())) != null && ps.getRemotePort() == 65520) {
                this._transport.sendDestroy(ps);
                this._transport.dropPeer(ps, true, "Corrupt DSM");
                this._context.banlist().banlistRouterForever(state.getFrom(), MessageReceiver._x("Sent corrupt DSM"));
            }
            this._context.messageHistory().droppedInboundMessage(state.getMessageId(), state.getFrom(), "error: " + ime.toString() + ": " + state.toString());
            I2NPMessage i2NPMessage = null;
            return i2NPMessage;
        }
        catch (Exception e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error handling a message: " + state, (Throwable)e);
            }
            this._context.messageHistory().droppedInboundMessage(state.getMessageId(), state.getFrom(), "error: " + e.toString() + ": " + state.toString());
            I2NPMessage i2NPMessage = null;
            return i2NPMessage;
        }
        finally {
            state.releaseResources();
        }
    }

    private static final String _x(String s) {
        return s;
    }

    private class Runner
    implements Runnable {
        private final I2NPMessageHandler _handler;

        public Runner() {
            this._handler = new I2NPMessageHandler(MessageReceiver.this._context);
        }

        @Override
        public void run() {
            MessageReceiver.this.loop(this._handler);
        }
    }
}

