/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

abstract class MTU {
    private static final boolean hasMTU = SystemVersion.isJava6();

    MTU() {
    }

    public static int getMTU(InetAddress ia) {
        Enumeration<NetworkInterface> ifcs;
        if (ia == null || !hasMTU) {
            return 0;
        }
        try {
            ifcs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException se) {
            return 0;
        }
        if (ifcs != null) {
            while (ifcs.hasMoreElements()) {
                NetworkInterface ifc = ifcs.nextElement();
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!ia.equals(addr)) continue;
                    try {
                        boolean isIPv6 = addr instanceof Inet6Address;
                        int mtu = ifc.getMTU();
                        if (isIPv6 && mtu < 1280 || !isIPv6 && mtu < 620) {
                            Log log = I2PAppContext.getGlobalContext().logManager().getLog(MTU.class);
                            log.logAlways(30, "Unusually low MTU " + mtu + " for interface " + ia + ", consider disabling");
                        }
                        return MTU.rectify(isIPv6, mtu);
                    }
                    catch (SocketException isIPv6) {
                    }
                    catch (Throwable t) {
                        return 0;
                    }
                }
            }
        }
        return 0;
    }

    public static int rectify(boolean isIPv6, int mtu) {
        int rv = mtu;
        int mod = rv % 16;
        if (isIPv6) {
            return Math.max(1280, Math.min(1472, rv -= mod));
        }
        if (mod > 12) {
            rv -= mod - 12;
        } else if (mod < 12) {
            rv -= mod + 4;
        }
        return Math.max(620, Math.min(1484, rv));
    }
}

