/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.tasks.ThreadDump;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class OOMListener
implements I2PThread.OOMEventListener {
    private final RouterContext _context;
    private final AtomicBoolean _wasCalled = new AtomicBoolean();

    public OOMListener(RouterContext ctx) {
        this._context = ctx;
    }

    public void outOfMemory(OutOfMemoryError oom) {
        try {
            if (this._context.router().isFinalShutdownInProgress()) {
                return;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            if (this._wasCalled.getAndSet(true)) {
                return;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            Thread.currentThread().setPriority(9);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            Router.clearCaches();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        Log log = null;
        try {
            log = this._context.logManager().getLog(Router.class);
            log.log(50, "Thread ran out of memory, shutting down I2P", (Throwable)oom);
            log.log(50, "free mem: " + Runtime.getRuntime().freeMemory() + " total mem: " + Runtime.getRuntime().totalMemory());
            if (this._context.hasWrapper()) {
                String path = !SystemVersion.isWindows() && !SystemVersion.isMac() && "i2psvc".equals(System.getProperty("user.name")) ? "/etc/i2p" : this._context.getBaseDir().toString();
                log.log(50, "To prevent future shutdowns, increase wrapper.java.maxmemory in " + path + File.separatorChar + "wrapper.config");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            ThreadDump.dump(this._context, 1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            this._context.router().eventLog().addEvent("oom");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        try {
            this._context.router().shutdown(10);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }
}

