/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessageException;

public class GarlicMessage
extends FastI2NPMessageImpl {
    public static final int MESSAGE_TYPE = 11;
    private byte[] _data;

    public GarlicMessage(I2PAppContext context) {
        super(context);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        if (this._data != null) {
            throw new IllegalStateException();
        }
        this._data = data;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != 11) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        long len = DataHelper.fromLong((byte[])data, (int)curIndex, (int)4);
        curIndex += 4;
        if (len <= 0L || len > 65536L) {
            throw new I2NPMessageException("size=" + len);
        }
        this._data = new byte[(int)len];
        System.arraycopy(data, curIndex, this._data, 0, (int)len);
    }

    @Override
    protected int calculateWrittenLength() {
        return 4 + this._data.length;
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        DataHelper.toLong((byte[])out, (int)curIndex, (int)4, (long)this._data.length);
        System.arraycopy(this._data, 0, out, curIndex += 4, this._data.length);
        return curIndex += this._data.length;
    }

    @Override
    public int getType() {
        return 11;
    }

    public int hashCode() {
        return DataHelper.hashCode((byte[])this.getData());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GarlicMessage) {
            GarlicMessage msg = (GarlicMessage)object;
            return DataHelper.eq((byte[])this.getData(), (byte[])msg.getData());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[GarlicMessage: ");
        buf.append("Data length: ").append(this.getData().length).append(" bytes");
        buf.append("]");
        return buf.toString();
    }
}

