/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.Properties;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base32;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;

public class I2PTunnelIRCServer
extends I2PTunnelServer
implements Runnable {
    private final byte[] cloakKey;
    private final String hostname;
    private final String method;
    private final String webircPassword;
    private final String webircSpoofIP;
    public static final String PROP_METHOD = "ircserver.method";
    public static final String PROP_METHOD_DEFAULT = "user";
    public static final String PROP_CLOAK = "ircserver.cloakKey";
    public static final String PROP_WEBIRC_PASSWORD = "ircserver.webircPassword";
    public static final String PROP_WEBIRC_SPOOF_IP = "ircserver.webircSpoofIP";
    public static final String PROP_WEBIRC_SPOOF_IP_DEFAULT = "127.0.0.1";
    public static final String PROP_HOSTNAME = "ircserver.fakeHostname";
    public static final String PROP_HOSTNAME_DEFAULT = "%f.b32.i2p";
    private static final long HEADER_TIMEOUT = 15000L;
    private static final long TOTAL_HEADER_TIMEOUT = 30000L;
    private static final int MAX_LINE_LENGTH = 1024;
    private static final String ERR_UNAVAILABLE = ":ircserver.i2p 499 you :This I2P IRC server is unavailable. It may be down or undergoing maintenance. Please try again later.\r\n";
    private static final String ERR_REGISTRATION = ":ircserver.i2p 499 you :Bad registration.\r\n";
    private static final String ERR_TIMEOUT = ":ircserver.i2p 499 you :Timeout registering.\r\n";
    private static final String ERR_EOF = ":ircserver.i2p 499 you :EOF while registering.\r\n";
    private static final String[] BAD_PROTOCOLS = new String[]{"GET ", "HEAD ", "POST ", "GNUTELLA CONNECT", "\u0013BitTorrent protocol"};

    public I2PTunnelIRCServer(InetAddress host, int port, File privkey, String privkeyname, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privkey, privkeyname, l, notifyThis, tunnel);
        Properties opts = tunnel.getClientOptions();
        this.method = opts.getProperty(PROP_METHOD, PROP_METHOD_DEFAULT);
        assert (this.method != null);
        this.webircPassword = opts.getProperty(PROP_WEBIRC_PASSWORD);
        this.webircSpoofIP = opts.getProperty(PROP_WEBIRC_SPOOF_IP, PROP_WEBIRC_SPOOF_IP_DEFAULT);
        String passphrase = opts.getProperty(PROP_CLOAK);
        if (passphrase == null) {
            this.cloakKey = new byte[32];
            tunnel.getContext().random().nextBytes(this.cloakKey);
        } else {
            this.cloakKey = SHA256Generator.getInstance().calculateHash(passphrase.trim().getBytes()).getData();
        }
        this.hostname = opts.getProperty(PROP_HOSTNAME, PROP_HOSTNAME_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void blockingHandle(I2PSocket socket) {
        block59: {
            if (this._log.shouldLog(20)) {
                this._log.info("Incoming connection to '" + this.toString() + "' port " + socket.getLocalPort() + " from: " + socket.getPeerDestination().calculateHash() + " port " + socket.getPort());
            }
            try {
                String modifiedRegistration;
                if (!this.method.equals("webirc")) {
                    modifiedRegistration = I2PTunnelIRCServer.filterRegistration(socket, this.cloakDest(socket.getPeerDestination()));
                    socket.setReadTimeout(this.readTimeout);
                } else {
                    StringBuffer buf = new StringBuffer("WEBIRC ");
                    buf.append(this.webircPassword);
                    buf.append(" cgiirc ");
                    buf.append(this.cloakDest(socket.getPeerDestination()));
                    buf.append(' ');
                    buf.append(this.webircSpoofIP);
                    buf.append("\r\n");
                    modifiedRegistration = buf.toString();
                }
                Socket s = this.getSocket(socket.getPeerDestination().calculateHash(), socket.getLocalPort());
                I2PTunnelRunner t = new I2PTunnelRunner(s, socket, this.slock, null, modifiedRegistration.getBytes(), null, (I2PTunnelRunner.FailCallback)null);
                this._clientExecutor.execute(t);
            }
            catch (RegistrationException ex) {
                try {
                    socket.getOutputStream().write(ERR_REGISTRATION.getBytes("ISO-8859-1"));
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error while receiving the new IRC Connection", ex);
                }
            }
            catch (EOFException ex) {
                try {
                    socket.getOutputStream().write(ERR_EOF.getBytes("ISO-8859-1"));
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error while receiving the new IRC Connection", ex);
                }
            }
            catch (SocketTimeoutException ex) {
                try {
                    socket.getOutputStream().write(ERR_TIMEOUT.getBytes("ISO-8859-1"));
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error while receiving the new IRC Connection", ex);
                }
            }
            catch (SocketException ex) {
                try {
                    socket.getOutputStream().write(ERR_UNAVAILABLE.getBytes("ISO-8859-1"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this._log.shouldLog(40)) {
                    this._log.error("Error connecting to IRC server " + this.remoteHost + ':' + this.remotePort, ex);
                }
            }
            catch (IOException ex) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error while receiving the new IRC Connection", ex);
                }
            }
            catch (OutOfMemoryError oom) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!this._log.shouldLog(40)) break block59;
                this._log.error("OOM in IRC server", oom);
            }
        }
    }

    String cloakDest(Destination d) {
        byte[] b = new byte[d.size() + this.cloakKey.length];
        System.arraycopy(b, 0, d.toByteArray(), 0, d.size());
        System.arraycopy(b, d.size(), this.cloakKey, 0, this.cloakKey.length);
        String hc = Base32.encode(SHA256Generator.getInstance().calculateHash(b).getData());
        String hf = Base32.encode(d.calculateHash().getData());
        return this.hostname.replace("%f", hf).replace("%c", hc);
    }

    private static String filterRegistration(I2PSocket socket, String newHostname) throws IOException {
        String command;
        StringBuilder buf = new StringBuilder(128);
        int lineCount = 0;
        long expire = System.currentTimeMillis() + 30000L;
        do {
            String s;
            if ((s = I2PTunnelIRCServer.readLine(socket, expire - System.currentTimeMillis())) == null) {
                throw new EOFException("EOF reached before the end of the headers");
            }
            if (lineCount == 0) {
                for (int i = 0; i < BAD_PROTOCOLS.length; ++i) {
                    if (!s.startsWith(BAD_PROTOCOLS[i])) continue;
                    throw new RegistrationException("Bad protocol " + BAD_PROTOCOLS[i]);
                }
            }
            if (++lineCount > 10) {
                throw new RegistrationException("Too many lines before USER or SERVER, giving up");
            }
            if (System.currentTimeMillis() > expire) {
                throw new SocketTimeoutException("Headers took too long");
            }
            s = s.trim();
            String[] field = s.split(" ", 5);
            int idx = 0;
            try {
                if (field[0].charAt(0) == ':') {
                    // empty if block
                }
                int n = ++idx;
                ++idx;
                command = field[n].toUpperCase(Locale.US);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new RegistrationException("Dropping defective message: [" + s + ']');
            }
            if ("USER".equals(command)) {
                if (field.length < idx + 4) {
                    throw new RegistrationException("Too few parameters in USER message: " + s);
                }
                buf.append("USER ").append(field[idx]).append(' ').append(newHostname);
                buf.append(' ');
                buf.append(field[idx + 2]).append(' ').append(field[idx + 3]).append("\r\n");
                break;
            }
            buf.append(s).append("\r\n");
        } while (!"SERVER".equals(command));
        return buf.toString();
    }

    private static String readLine(I2PSocket socket, long timeout) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder(128);
        if (timeout <= 0L) {
            throw new SocketTimeoutException();
        }
        long expires = System.currentTimeMillis() + timeout;
        InputStream in = socket.getInputStream();
        int i = 0;
        socket.setReadTimeout(timeout);
        while ((c = in.read()) != -1) {
            if (++i > 1024) {
                throw new RegistrationException("Line too long - max 1024");
            }
            if (c == 10) break;
            long newTimeout = expires - System.currentTimeMillis();
            if (newTimeout <= 0L) {
                throw new SocketTimeoutException();
            }
            buf.append((char)c);
            if (newTimeout == timeout) continue;
            timeout = newTimeout;
            socket.setReadTimeout(timeout);
        }
        if (c == -1) {
            if (System.currentTimeMillis() >= expires) {
                throw new SocketTimeoutException();
            }
            throw new EOFException();
        }
        return buf.toString();
    }

    private static class RegistrationException
    extends IOException {
        public RegistrationException(String s) {
            super(s);
        }
    }
}

