/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketAddress;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;

public class I2PTunnelClient
extends I2PTunnelClientBase {
    protected List<Destination> dests;
    private final List<I2PSocketAddress> _addrs = new ArrayList<I2PSocketAddress>(1);
    private static final long DEFAULT_READ_TIMEOUT = 300000L;
    protected long readTimeout = 300000L;

    public I2PTunnelClient(int localPort, String destinations, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "Standard client on " + tunnel.listenHost + ':' + localPort, tunnel, pkf);
        this.dests = new ArrayList<Destination>(1);
        this.buildAddresses(destinations);
        if (this._addrs.isEmpty()) {
            l.log("No valid target destinations found");
            this.notifyEvent("openClientResult", "error");
            throw new IllegalArgumentException("No valid target destinations found");
        }
        this.setName(this.getLocalPort() + " -> " + destinations);
        this.notifyEvent("openClientResult", "ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAddresses(String destinations) {
        if (destinations == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(destinations, ", ");
        List<I2PSocketAddress> list = this._addrs;
        synchronized (list) {
            this._addrs.clear();
            while (tok.hasMoreTokens()) {
                String destination = tok.nextToken();
                try {
                    I2PSocketAddress addr = new I2PSocketAddress(destination);
                    this._addrs.add(addr);
                    if (addr.isUnresolved()) {
                        String name = addr.getHostName();
                        if (name.length() == 60 && name.endsWith(".b32.i2p")) {
                            this.l.log("Warning - Could not resolve " + name + ", perhaps it is not up, will retry when connecting.");
                            continue;
                        }
                        this.l.log("Warning - Could not resolve " + name + ", you must add it to your address book for it to work.");
                        continue;
                    }
                    this.dests.add(addr.getAddress());
                }
                catch (IllegalArgumentException iae) {
                    this.l.log("Bad destination " + destination + " - " + iae);
                }
            }
        }
    }

    public void setReadTimeout(long ms) {
        this.readTimeout = ms;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clientConnectionRun(Socket s) {
        block8: {
            I2PSocket i2ps = null;
            try {
                I2PSocketAddress addr = this.pickDestination();
                if (addr == null) {
                    throw new UnknownHostException("No valid destination configured");
                }
                Destination clientDest = addr.getAddress();
                if (clientDest == null) {
                    throw new UnknownHostException("Could not resolve " + addr.getHostName());
                }
                int port = addr.getPort();
                i2ps = this.createI2PSocket(clientDest, port);
                i2ps.setReadTimeout(this.readTimeout);
                I2PTunnelRunner t = new I2PTunnelRunner(s, i2ps, this.sockLock, null, null, (List<I2PSocket>)this.mySockets, (I2PTunnelRunner.FailCallback)null);
                t.run();
            }
            catch (Exception ex) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Error connecting", ex);
                }
                I2PTunnelClient.closeSocket(s);
                if (i2ps == null) break block8;
                Object object = this.sockLock;
                synchronized (object) {
                    this.mySockets.remove(this.sockLock);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final I2PSocketAddress pickDestination() {
        List<I2PSocketAddress> list = this._addrs;
        synchronized (list) {
            int size = this._addrs.size();
            if (size <= 0) {
                if (this._log.shouldLog(40)) {
                    this._log.error("No client targets?!");
                }
                return null;
            }
            if (size == 1) {
                return this._addrs.get(0);
            }
            int index = this._context.random().nextInt(size);
            return this._addrs.get(index);
        }
    }

    @Override
    public void optionsUpdated(I2PTunnel tunnel) {
        if (this.getTunnel() != tunnel) {
            return;
        }
        Properties props = tunnel.getClientOptions();
        String targets = props.getProperty("targetDestination");
        this.buildAddresses(targets);
        super.optionsUpdated(tunnel);
    }
}

