/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.util.skiplist;

import java.io.Flushable;
import java.util.Random;
import net.i2p.util.RandomSource;
import net.metanotion.util.skiplist.SkipIterator;
import net.metanotion.util.skiplist.SkipLevels;
import net.metanotion.util.skiplist.SkipSpan;

public class SkipList
implements Flushable {
    protected static final int P = 2;
    private static final int MIN_SLOTS = 4;
    protected SkipSpan first;
    protected SkipLevels stack;
    public static final Random rng = RandomSource.getInstance();
    protected int size;

    @Override
    public void flush() {
    }

    protected SkipList() {
    }

    public SkipList(int span) {
        if (span < 1 || span > 256) {
            throw new IllegalArgumentException("Invalid span size");
        }
        this.first = new SkipSpan(span);
        this.stack = new SkipLevels(1, this.first);
    }

    public int size() {
        return this.size;
    }

    public void addItem() {
        ++this.size;
    }

    public void delItem() {
        if (this.size > 0) {
            --this.size;
        }
    }

    public int maxLevels() {
        return 4;
    }

    public int generateColHeight() {
        int bits = rng.nextInt();
        int max = this.maxLevels();
        for (int res = 0; res < max; ++res) {
            if (bits % 2 == 0) {
                return res;
            }
            bits /= 2;
        }
        return max;
    }

    public void put(Comparable key, Object val) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (val == null) {
            throw new NullPointerException();
        }
        SkipLevels slvls = this.stack.put(this.stack.levels.length - 1, key, val, this);
        if (slvls != null) {
            SkipLevels[] levels = new SkipLevels[slvls.levels.length];
            for (int i = 0; i < slvls.levels.length; ++i) {
                levels[i] = i < this.stack.levels.length ? this.stack.levels[i] : slvls;
            }
            this.stack.levels = levels;
            this.stack.flush();
            this.flush();
        }
    }

    public Object remove(Comparable key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object[] res = this.stack.remove(this.stack.levels.length - 1, key, this);
        if (res != null) {
            if (res[1] != null) {
                SkipLevels slvls = (SkipLevels)res[1];
                for (int i = 0; i < slvls.levels.length; ++i) {
                    if (this.stack.levels[i] != slvls) continue;
                    this.stack.levels[i] = slvls.levels[i];
                }
                this.stack.flush();
            }
            this.flush();
            return res[0];
        }
        return null;
    }

    public void printSL() {
        System.out.println("List size " + this.size);
        System.out.println(this.stack.printAll());
    }

    public void print() {
        System.out.println("List size " + this.size);
        System.out.println(this.first.print());
    }

    public Object get(Comparable key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.stack.get(this.stack.levels.length - 1, key);
    }

    public SkipIterator iterator() {
        return new SkipIterator(this.first, 0);
    }

    public SkipIterator min() {
        return new SkipIterator(this.first, 0);
    }

    public SkipIterator max() {
        SkipSpan ss = this.stack.getEnd();
        return new SkipIterator(ss, ss.nKeys - 1);
    }

    public SkipIterator find(Comparable key) {
        int[] search = new int[1];
        SkipSpan ss = this.stack.getSpan(this.stack.levels.length - 1, key, search);
        if (search[0] < 0) {
            search[0] = -1 * (search[0] + 1);
        }
        return new SkipIterator(ss, search[0]);
    }

    public void balance() {
    }
}

