/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import freenet.support.CPUInformation.AMDCPUInfo;
import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.CPUInfo;
import freenet.support.CPUInformation.IntelCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;
import freenet.support.CPUInformation.VIACPUInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.util.FileUtil;
import net.i2p.util.SystemVersion;

public class NativeBigInteger
extends BigInteger {
    private static boolean _nativeOk;
    private static String _loadStatus;
    private static String _cpuModel;
    private static String _extractedResource;
    private static boolean _doLog;
    private static final String JBIGI_OPTIMIZATION_K6 = "k6";
    private static final String JBIGI_OPTIMIZATION_K6_2 = "k62";
    private static final String JBIGI_OPTIMIZATION_K6_3 = "k63";
    private static final String JBIGI_OPTIMIZATION_ATHLON = "athlon";
    private static final String JBIGI_OPTIMIZATION_ATHLON64 = "athlon64";
    private static final String JBIGI_OPTIMIZATION_PENTIUM = "pentium";
    private static final String JBIGI_OPTIMIZATION_PENTIUMMMX = "pentiummmx";
    private static final String JBIGI_OPTIMIZATION_PENTIUM2 = "pentium2";
    private static final String JBIGI_OPTIMIZATION_PENTIUM3 = "pentium3";
    private static final String JBIGI_OPTIMIZATION_PENTIUM4 = "pentium4";
    private static final String JBIGI_OPTIMIZATION_VIAC3 = "viac3";
    private static final String JBIGI_OPTIMIZATION_ATOM = "atom";
    private static final String JBIGI_OPTIMIZATION_CORE2 = "core2";
    private static final String JBIGI_OPTIMIZATION_COREI = "corei";
    private static final String JBIGI_OPTIMIZATION_GEODE = "geode";
    private static final String JBIGI_OPTIMIZATION_NANO = "nano";
    private static final String JBIGI_OPTIMIZATION_PENTIUMM = "pentiumm";
    private static final String JBIGI_OPTIMIZATION_VIAC32 = "viac32";
    private static final String JBIGI_OPTIMIZATION_ARM = "arm";
    private static final String JBIGI_OPTIMIZATION_PPC = "ppc";
    private static final boolean _isWin;
    private static final boolean _isOS2;
    private static final boolean _isMac;
    private static final boolean _isLinux;
    private static final boolean _isKFreebsd;
    private static final boolean _isFreebsd;
    private static final boolean _isNetbsd;
    private static final boolean _isOpenbsd;
    private static final boolean _isSunos;
    private static final boolean _isAndroid;
    private static final boolean _is64;
    private static final boolean _isX86;
    private static final boolean _isArm;
    private static final boolean _isPPC;
    private static final String _libPrefix;
    private static final String _libSuffix;
    private static final String sCPUType;
    private byte[] cachedBa;

    private static String resolveCPUType() {
        try {
            CPUInfo c = CPUID.getInfo();
            try {
                _cpuModel = c.getCPUModelString();
            }
            catch (UnknownCPUException unknownCPUException) {
                // empty catch block
            }
            if (c instanceof VIACPUInfo) {
                VIACPUInfo viacpu = (VIACPUInfo)c;
                if (viacpu.IsNanoCompatible()) {
                    return JBIGI_OPTIMIZATION_NANO;
                }
                return JBIGI_OPTIMIZATION_VIAC3;
            }
            if (c instanceof AMDCPUInfo) {
                AMDCPUInfo amdcpu = (AMDCPUInfo)c;
                if (amdcpu.IsAthlon64Compatible()) {
                    return JBIGI_OPTIMIZATION_ATHLON64;
                }
                if (amdcpu.IsAthlonCompatible()) {
                    return JBIGI_OPTIMIZATION_ATHLON;
                }
                if (amdcpu.IsGeodeCompatible()) {
                    return JBIGI_OPTIMIZATION_GEODE;
                }
                if (amdcpu.IsK6_3_Compatible()) {
                    return JBIGI_OPTIMIZATION_K6_3;
                }
                if (amdcpu.IsK6_2_Compatible()) {
                    return JBIGI_OPTIMIZATION_K6_2;
                }
                if (amdcpu.IsK6Compatible()) {
                    return JBIGI_OPTIMIZATION_K6;
                }
            } else if (c instanceof IntelCPUInfo) {
                IntelCPUInfo intelcpu = (IntelCPUInfo)c;
                if (intelcpu.IsCoreiCompatible()) {
                    return JBIGI_OPTIMIZATION_COREI;
                }
                if (intelcpu.IsCore2Compatible()) {
                    return JBIGI_OPTIMIZATION_CORE2;
                }
                if (intelcpu.IsPentium4Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM4;
                }
                if (intelcpu.IsAtomCompatible()) {
                    return JBIGI_OPTIMIZATION_ATOM;
                }
                if (intelcpu.IsPentiumMCompatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUMM;
                }
                if (intelcpu.IsPentium3Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM3;
                }
                if (intelcpu.IsPentium2Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM2;
                }
                if (intelcpu.IsPentiumMMXCompatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUMMMX;
                }
                if (intelcpu.IsPentiumCompatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM;
                }
            }
            return null;
        }
        catch (UnknownCPUException e) {
            return null;
        }
    }

    public static native byte[] nativeModPow(byte[] var0, byte[] var1, byte[] var2);

    public NativeBigInteger(byte[] val) {
        super(val);
    }

    public NativeBigInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
    }

    public NativeBigInteger(int bitlen, int certainty, Random rnd) {
        super(bitlen, certainty, rnd);
    }

    public NativeBigInteger(int numbits, Random rnd) {
        super(numbits, rnd);
    }

    public NativeBigInteger(String val) {
        super(val);
    }

    public NativeBigInteger(String val, int radix) {
        super(val, radix);
    }

    public NativeBigInteger(BigInteger integer) {
        this(integer.toByteArray());
    }

    @Override
    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        if (_nativeOk && this.signum() >= 0 && exponent.signum() >= 0 && m.signum() > 0) {
            return new NativeBigInteger(NativeBigInteger.nativeModPow(this.toByteArray(), exponent.toByteArray(), m.toByteArray()));
        }
        return super.modPow(exponent, m);
    }

    @Override
    public byte[] toByteArray() {
        if (this.cachedBa == null) {
            this.cachedBa = super.toByteArray();
        }
        return this.cachedBa;
    }

    public static boolean isNative() {
        return _nativeOk;
    }

    public static String loadStatus() {
        return _loadStatus;
    }

    public static String getLoadedResourceName() {
        return _extractedResource;
    }

    public static String cpuType() {
        if (sCPUType != null) {
            return sCPUType;
        }
        return "unrecognized";
    }

    public static String cpuModel() {
        return _cpuModel;
    }

    public static void main(String[] args) {
        _doLog = true;
        NativeBigInteger.runModPowTest(100);
    }

    private static void runModPowTest(int numRuns) {
        System.out.println("DEBUG: Warming up the random number generator...");
        SecureRandom rand = new SecureRandom();
        rand.nextBoolean();
        System.out.println("DEBUG: Random number generator warmed up");
        byte[] _sampleGenerator = CryptoConstants.elgg.toByteArray();
        byte[] _samplePrime = CryptoConstants.elgp.toByteArray();
        BigInteger jg = new BigInteger(_sampleGenerator);
        BigInteger jp = new BigInteger(_samplePrime);
        long totalTime = 0L;
        long javaTime = 0L;
        int runsProcessed = 0;
        for (runsProcessed = 0; runsProcessed < numRuns; ++runsProcessed) {
            BigInteger bi = new BigInteger(226, rand);
            NativeBigInteger g = new NativeBigInteger(_sampleGenerator);
            NativeBigInteger p = new NativeBigInteger(_samplePrime);
            NativeBigInteger k = new NativeBigInteger(1, bi.toByteArray());
            long beforeModPow = System.currentTimeMillis();
            BigInteger myValue = g.modPow(k, p);
            long afterModPow = System.currentTimeMillis();
            BigInteger jval = jg.modPow(bi, jp);
            long afterJavaModPow = System.currentTimeMillis();
            totalTime += afterModPow - beforeModPow;
            javaTime += afterJavaModPow - afterModPow;
            if (!myValue.equals(jval)) {
                System.err.println("ERROR: [" + runsProcessed + "]\tnative modPow != java modPow");
                System.err.println("ERROR: native modPow value: " + myValue.toString());
                System.err.println("ERROR: java modPow value: " + jval.toString());
                System.err.println("ERROR: run time: " + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
                break;
            }
            System.out.println("DEBUG: current run time: " + (afterModPow - beforeModPow) + "ms (total: " + totalTime + "ms, " + totalTime / (long)(runsProcessed + 1) + "ms each)");
        }
        System.out.println("INFO: run time: " + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
        if (numRuns == runsProcessed) {
            System.out.println("INFO: " + runsProcessed + " runs complete without any errors");
        } else {
            System.out.println("ERROR: " + runsProcessed + " runs until we got an error");
        }
        if (_nativeOk) {
            System.out.println("native run time: \t" + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("java run time:   \t" + javaTime + "ms (" + javaTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("native = " + (double)totalTime * 100.0 / (double)javaTime + "% of pure java time");
        } else {
            System.out.println("java run time: \t" + javaTime + "ms (" + javaTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("However, we couldn't load the native library, so this doesn't test much");
        }
    }

    private static final void loadNative() {
        try {
            String wantedProp = System.getProperty("jbigi.enable", "true");
            boolean wantNative = Boolean.parseBoolean(wantedProp);
            if (wantNative) {
                NativeBigInteger.debug("trying loadGeneric");
                boolean loaded = NativeBigInteger.loadGeneric("jbigi");
                if (loaded) {
                    _nativeOk = true;
                    String s = I2PAppContext.getGlobalContext().getProperty("jbigi.loadedResource");
                    if (s != null) {
                        NativeBigInteger.info("Locally optimized library " + s + " loaded from file");
                    } else {
                        NativeBigInteger.info("Locally optimized native BigInteger library loaded from file");
                    }
                } else {
                    List<String> toTry = NativeBigInteger.getResourceList();
                    NativeBigInteger.debug("loadResource list to try is: " + toTry);
                    for (String s : toTry) {
                        NativeBigInteger.debug("trying loadResource " + s);
                        if (!NativeBigInteger.loadFromResource(s)) continue;
                        _nativeOk = true;
                        _extractedResource = s;
                        NativeBigInteger.info("Native BigInteger library " + s + " loaded from resource");
                        break;
                    }
                }
            }
            if (!_nativeOk) {
                NativeBigInteger.warn("Native BigInteger library jbigi not loaded - using pure Java - poor performance may result - see http://i2p-projekt.i2p/jbigi for help");
            }
        }
        catch (Exception e) {
            NativeBigInteger.warn("Native BigInteger library jbigi not loaded, using pure java", e);
        }
    }

    private static void debug(String s) {
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).debug(s);
    }

    private static void info(String s) {
        if (_doLog) {
            System.err.println("INFO: " + s);
        }
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).info(s);
        _loadStatus = s;
    }

    private static void warn(String s) {
        NativeBigInteger.warn(s, null);
    }

    private static void warn(String s, Throwable t) {
        if (_doLog) {
            System.err.println("WARNING: " + s);
            if (t != null) {
                t.printStackTrace();
            }
        }
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).warn(s, t);
        _loadStatus = t != null ? s + ' ' + t : s;
    }

    private static final boolean loadGeneric(String name) {
        try {
            if (name == null) {
                return false;
            }
            System.loadLibrary(name);
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            if (_isAndroid) {
                NativeBigInteger.warn("jbigi loadLibrary() fail", ule);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean loadFromResource(String resourceName) {
        if (resourceName == null) {
            return false;
        }
        URL resource = ClassLoader.getSystemResource(resourceName);
        if (resource == null) {
            NativeBigInteger.info("Resource name [" + resourceName + "] was not found");
            return false;
        }
        File outFile = null;
        FileOutputStream fos = null;
        String filename = _libPrefix + "jbigi" + _libSuffix;
        try {
            int read;
            InputStream libStream = resource.openStream();
            outFile = new File(I2PAppContext.getGlobalContext().getTempDir(), filename);
            fos = new FileOutputStream(outFile);
            byte[] buf = new byte[4096];
            while ((read = libStream.read(buf)) >= 0) {
                fos.write(buf, 0, read);
            }
            fos.close();
            fos = null;
            System.load(outFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError ule) {
            NativeBigInteger.warn("Failed to load the resource " + resourceName + " - not a valid library for this platform");
            if (outFile != null) {
                outFile.delete();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            NativeBigInteger.warn("Problem writing out the temporary native library data", ioe);
            if (outFile != null) {
                outFile.delete();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        File newFile = new File(I2PAppContext.getGlobalContext().getBaseDir(), filename);
        FileUtil.copy(outFile, newFile, false, true);
        return true;
    }

    private static List<String> getResourceList() {
        if (_isAndroid) {
            return Collections.emptyList();
        }
        ArrayList<String> rv = new ArrayList<String>(8);
        String primary = NativeBigInteger.getMiddleName2(true);
        if (primary != null) {
            if (_is64) {
                if (!primary.equals(JBIGI_OPTIMIZATION_ATHLON64)) {
                    rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + primary + "_64" + _libSuffix);
                }
                rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + JBIGI_OPTIMIZATION_ATHLON64 + "_64" + _libSuffix);
            }
            if (_isArm) {
                Map<String, String> cpuinfo = NativeBigInteger.getCPUInfo();
                int ver = 0;
                String proc = cpuinfo.get("processor");
                String arch = cpuinfo.get("cpu architecture");
                if (proc != null && proc.contains("ARMv6")) {
                    ver = 6;
                } else if (arch != null && arch.length() > 0) {
                    String sver = arch.substring(0, 1);
                    try {
                        ver = Integer.parseInt(sver);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                for (int i = ver; i >= 3; --i) {
                    rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + primary + 'v' + i + _libSuffix);
                }
            }
            rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + primary + _libSuffix);
            if (_is64 && !primary.equals(JBIGI_OPTIMIZATION_ATHLON64)) {
                rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + JBIGI_OPTIMIZATION_ATHLON64 + _libSuffix);
            }
            if (primary.equals(JBIGI_OPTIMIZATION_ATOM) || primary.equals(JBIGI_OPTIMIZATION_PENTIUMM) || primary.equals(JBIGI_OPTIMIZATION_GEODE)) {
                rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + JBIGI_OPTIMIZATION_PENTIUM3 + _libSuffix);
            }
            if (_is64) {
                rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + JBIGI_OPTIMIZATION_ATHLON + _libSuffix);
            }
        } else if (_is64) {
            rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + JBIGI_OPTIMIZATION_ATHLON64 + "_64" + _libSuffix);
            rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + JBIGI_OPTIMIZATION_ATHLON64 + _libSuffix);
        }
        if (_is64) {
            rv.add(_libPrefix + NativeBigInteger.getMiddleName1() + "none_64" + _libSuffix);
        }
        if (!(_isArm || _isPPC || _isMac)) {
            rv.add(NativeBigInteger.getResourceName(false));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getCPUInfo() {
        HashMap<String, String> rv = new HashMap<String, String>(32);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/cpuinfo"), "ISO-8859-1"), 4096);
            String line = null;
            while ((line = in.readLine()) != null) {
                String key;
                String[] parts = line.split(":", 2);
                if (parts.length < 2 || rv.containsKey(key = parts[0].trim().toLowerCase(Locale.US))) continue;
                rv.put(key, parts[1].trim());
            }
        }
        catch (IOException ioe) {
            NativeBigInteger.warn("Unable to read /proc/cpuinfo", ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rv;
    }

    private static final String getResourceName(boolean optimized) {
        String middle = NativeBigInteger.getMiddleName(optimized);
        if (middle == null) {
            return null;
        }
        return _libPrefix + middle + _libSuffix;
    }

    private static final String getMiddleName(boolean optimized) {
        String m2 = NativeBigInteger.getMiddleName2(optimized);
        if (m2 == null) {
            return null;
        }
        return NativeBigInteger.getMiddleName1() + m2;
    }

    private static final String getMiddleName2(boolean optimized) {
        String sAppend;
        if (optimized) {
            if (sCPUType == null) {
                return null;
            }
            sAppend = sCPUType.equals(JBIGI_OPTIMIZATION_K6_3) && !_isWin ? JBIGI_OPTIMIZATION_K6_2 : (sCPUType.equals(JBIGI_OPTIMIZATION_COREI) && !_is64 && (_isKFreebsd || _isNetbsd || _isOpenbsd) ? JBIGI_OPTIMIZATION_CORE2 : (sCPUType.equals(JBIGI_OPTIMIZATION_PENTIUM2) && _isSunos && _isX86 ? JBIGI_OPTIMIZATION_PENTIUM3 : (sCPUType.equals(JBIGI_OPTIMIZATION_VIAC32) ? JBIGI_OPTIMIZATION_PENTIUM3 : sCPUType)));
        } else {
            sAppend = "none";
        }
        return sAppend;
    }

    private static final String getMiddleName1() {
        if (_isWin) {
            return "jbigi-windows-";
        }
        if (_isKFreebsd) {
            return "jbigi-kfreebsd-";
        }
        if (_isFreebsd) {
            return "jbigi-freebsd-";
        }
        if (_isNetbsd) {
            return "jbigi-netbsd-";
        }
        if (_isOpenbsd) {
            return "jbigi-openbsd-";
        }
        if (_isMac) {
            return "jbigi-osx-";
        }
        if (_isOS2) {
            return "jbigi-os2-";
        }
        if (_isSunos) {
            return "jbigi-solaris-";
        }
        return "jbigi-linux-";
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    static {
        _loadStatus = "uninitialized";
        _cpuModel = "uninitialized";
        _doLog = System.getProperty("jbigi.dontLog") == null && I2PAppContext.getCurrentContext() != null && I2PAppContext.getCurrentContext().isRouterContext();
        _isWin = SystemVersion.isWindows();
        _isOS2 = System.getProperty("os.name").startsWith("OS/2");
        _isMac = SystemVersion.isMac();
        _isLinux = System.getProperty("os.name").toLowerCase(Locale.US).contains("linux");
        _isKFreebsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("kfreebsd");
        _isFreebsd = !_isKFreebsd && System.getProperty("os.name").toLowerCase(Locale.US).contains("freebsd");
        _isNetbsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("netbsd");
        _isOpenbsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("openbsd");
        _isSunos = System.getProperty("os.name").toLowerCase(Locale.US).contains("sunos");
        _isAndroid = SystemVersion.isAndroid();
        _is64 = SystemVersion.is64Bit();
        _isX86 = SystemVersion.isX86();
        _isArm = SystemVersion.isARM();
        _isPPC = System.getProperty("os.arch").contains(JBIGI_OPTIMIZATION_PPC);
        String string = _libPrefix = _isWin || _isOS2 ? "" : "lib";
        String string2 = _isWin || _isOS2 ? ".dll" : (_libSuffix = _isMac ? ".jnilib" : ".so");
        sCPUType = _isX86 ? NativeBigInteger.resolveCPUType() : (_isArm ? JBIGI_OPTIMIZATION_ARM : (_isPPC && !_isMac ? JBIGI_OPTIMIZATION_PPC : null));
        NativeBigInteger.loadNative();
    }
}

