/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.data.DataHelper;

public class HexDump {
    private static final int FORMAT_OFFSET_PADDING = 8;
    private static final int FORMAT_BYTES_PER_ROW = 16;
    private static final byte[] HEXCHARS = DataHelper.getASCII("0123456789abcdef");

    public static String dump(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            HexDump.dump(data, 0, data.length, out);
            return out.toString("ISO-8859-1");
        }
        catch (IOException e) {
            throw new RuntimeException("no 8859?", e);
        }
    }

    public static String dump(byte[] data, int off, int len) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            HexDump.dump(data, off, len, out);
            return out.toString("ISO-8859-1");
        }
        catch (IOException e) {
            throw new RuntimeException("no 8859?", e);
        }
    }

    public static void dump(byte[] data, OutputStream out) throws IOException {
        HexDump.dump(data, 0, data.length, out);
    }

    public static void dump(byte[] data, int off, int len, OutputStream out) throws IOException {
        int end = len + off;
        for (int dumpoff = off; dumpoff < end; dumpoff += 16) {
            int val;
            int i;
            String hexoff = Integer.toString(dumpoff, 16);
            int hexofflen = hexoff.length();
            for (i = 0; i < 8 - hexofflen; ++i) {
                out.write(48);
            }
            out.write(DataHelper.getASCII(hexoff));
            out.write(32);
            int nextbytes = 16 < end - dumpoff ? 16 : end - dumpoff;
            for (i = 0; i < 16; ++i) {
                if (i % 8 == 0) {
                    out.write(32);
                }
                if (i >= nextbytes) {
                    out.write(DataHelper.getASCII("   "));
                    continue;
                }
                val = data[dumpoff + i] & 0xFF;
                out.write(HEXCHARS[val >>> 4]);
                out.write(HEXCHARS[val & 0xF]);
                out.write(32);
            }
            out.write(" |".getBytes());
            for (i = 0; i < 16; ++i) {
                if (i >= nextbytes) {
                    out.write(32);
                    continue;
                }
                val = data[i + dumpoff];
                if (val > 31 && val < 127) {
                    out.write(val);
                    continue;
                }
                out.write(46);
            }
            out.write(124);
            out.write(10);
        }
    }
}

