/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.i2p.util.SystemVersion;

public class FileUtil {
    private static boolean _failedOracle;
    private static boolean _failedApache;

    public static final boolean rmdir(String path, boolean failIfNotEmpty) {
        return FileUtil.rmdir(new File(path), failIfNotEmpty);
    }

    public static final boolean rmdir(File target, boolean failIfNotEmpty) {
        if (!target.exists()) {
            return true;
        }
        if (!target.isDirectory()) {
            return target.delete();
        }
        File[] children = target.listFiles();
        if (children == null) {
            return false;
        }
        if (failIfNotEmpty && children.length > 0) {
            return false;
        }
        for (int i = 0; i < children.length; ++i) {
            if (FileUtil.rmdir(children[i], failIfNotEmpty)) continue;
            return false;
        }
        return target.delete();
    }

    public static boolean extractZip(File zipfile, File targetDir) {
        return FileUtil.extractZip(zipfile, targetDir, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean extractZip(File zipfile, File targetDir, int logLevel) {
        int files = 0;
        ZipFile zip = null;
        try {
            byte[] buf = new byte[16384];
            zip = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (true) {
                ZipOutputStream jos;
                FileOutputStream fos;
                InputStream in;
                if (entries.hasMoreElements()) {
                    boolean parentsOk;
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().contains("..")) {
                        System.err.println("ERROR: Refusing to extract a zip entry with '..' in it [" + entry.getName() + "]");
                        boolean bl = false;
                        return bl;
                    }
                    if (entry.getName().indexOf(0) >= 0) {
                        System.err.println("ERROR: Refusing to extract a zip entry with null in it [" + entry.getName() + "]");
                        boolean bl = false;
                        return bl;
                    }
                    File target = new File(targetDir, entry.getName());
                    File parent = target.getParentFile();
                    if (parent != null && !parent.exists() && !(parentsOk = parent.mkdirs())) {
                        if (logLevel <= 40) {
                            System.err.println("ERROR: Unable to create the parent dir for " + entry.getName() + ": [" + parent.getAbsolutePath() + "]");
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (entry.isDirectory()) {
                        if (target.exists()) continue;
                        boolean created = target.mkdirs();
                        if (!created) {
                            if (logLevel <= 40) {
                                System.err.println("ERROR: Unable to create the directory [" + entry.getName() + "]");
                            }
                            boolean bl = false;
                            return bl;
                        }
                        if (logLevel > 20) continue;
                        System.err.println("INFO: Creating directory [" + entry.getName() + "]");
                        continue;
                    }
                    in = null;
                    fos = null;
                    jos = null;
                    try {
                        in = zip.getInputStream(entry);
                        if (entry.getName().endsWith(".jar.pack") || entry.getName().endsWith(".war.pack")) {
                            target = new File(targetDir, entry.getName().substring(0, entry.getName().length() - ".pack".length()));
                            jos = new JarOutputStream(new FileOutputStream(target));
                            FileUtil.unpack(in, (JarOutputStream)jos);
                            if (logLevel <= 20) {
                                System.err.println("INFO: File [" + entry.getName() + "] extracted and unpacked");
                            }
                        } else {
                            fos = new FileOutputStream(target);
                            int read = 0;
                            while ((read = in.read(buf)) != -1) {
                                fos.write(buf, 0, read);
                            }
                            if (logLevel <= 20) {
                                System.err.println("INFO: File [" + entry.getName() + "] extracted");
                            }
                        }
                        ++files;
                        continue;
                    }
                    catch (IOException ioe) {
                        if (logLevel <= 40) {
                            System.err.println("ERROR: Error extracting the zip entry (" + entry.getName() + ')');
                            if (ioe.getMessage() != null && ioe.getMessage().indexOf("CAFED00D") >= 0) {
                                System.err.println("This may be caused by a packed library that requires Java 1.6, your Java version is: " + System.getProperty("java.version"));
                            }
                            ioe.printStackTrace();
                        }
                        boolean bl = false;
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (files <= 0 || logLevel > 30) return bl;
                        System.err.println("INFO: " + files + " files extracted to " + targetDir);
                        return bl;
                    }
                    catch (Exception e) {
                        boolean bl;
                        block86: {
                            if (logLevel <= 40) {
                                System.err.println("ERROR: Error extracting the zip entry (" + entry.getName() + ')');
                                e.printStackTrace();
                            }
                            bl = false;
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                if (jos != null) {
                                    jos.close();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (zip == null) break block86;
                            try {
                                zip.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (files <= 0 || logLevel > 30) return bl;
                        System.err.println("INFO: " + files + " files extracted to " + targetDir);
                        return bl;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                boolean bl = true;
                return bl;
                {
                    catch (IOException ioe) {
                        if (logLevel <= 40) {
                            System.err.println("ERROR: Unable to extract the zip file");
                            ioe.printStackTrace();
                        }
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (jos == null) continue;
                        jos.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                break;
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
            if (files > 0 && logLevel <= 30) {
                System.err.println("INFO: " + files + " files extracted to " + targetDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyZip(File zipfile) {
        ZipFile zip = null;
        try {
            byte[] buf = new byte[16384];
            zip = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            boolean p200TestRequired = true;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().indexOf("..") != -1) {
                    boolean bl = false;
                    return bl;
                }
                if (entry.isDirectory()) continue;
                if (p200TestRequired && (entry.getName().endsWith(".jar.pack") || entry.getName().endsWith(".war.pack"))) {
                    if (!FileUtil.isPack200Supported()) {
                        System.err.println("ERROR: Zip verify failed, your JVM does not support unpack200");
                        boolean bl = false;
                        return bl;
                    }
                    p200TestRequired = false;
                }
                try {
                    InputStream in = zip.getInputStream(entry);
                    while (in.read(buf) != -1) {
                    }
                    in.close();
                }
                catch (IOException ioe) {
                    boolean bl = false;
                    if (zip == null) return bl;
                    try {
                        zip.close();
                        return bl;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isPack200Supported() {
        try {
            Class.forName("java.util.jar.Pack200", false, ClassLoader.getSystemClassLoader());
            return true;
        }
        catch (Exception exception) {
            try {
                Class.forName("org.apache.harmony.unpack200.Archive", false, ClassLoader.getSystemClassLoader());
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }

    private static void unpack(InputStream in, JarOutputStream out) throws Exception {
        if (!_failedOracle) {
            try {
                Class<?> p200 = Class.forName("java.util.jar.Pack200", true, ClassLoader.getSystemClassLoader());
                Method newUnpacker = p200.getMethod("newUnpacker", new Class[0]);
                Object unpacker = newUnpacker.invoke(null, (Object[])null);
                Method unpack = unpacker.getClass().getMethod("unpack", InputStream.class, JarOutputStream.class);
                unpack.invoke(unpacker, in, out);
                return;
            }
            catch (ClassNotFoundException e) {
                _failedOracle = true;
            }
            catch (NoSuchMethodException e) {
                _failedOracle = true;
            }
        }
        if (!_failedApache) {
            try {
                Class<?> p200 = Class.forName("org.apache.harmony.unpack200.Archive", true, ClassLoader.getSystemClassLoader());
                Constructor<?> newUnpacker = p200.getConstructor(InputStream.class, JarOutputStream.class);
                Object unpacker = newUnpacker.newInstance(in, out);
                Method unpack = unpacker.getClass().getMethod("unpack", new Class[0]);
                unpack.invoke(unpacker, (Object[])null);
                return;
            }
            catch (ClassNotFoundException e) {
                _failedApache = true;
            }
            catch (NoSuchMethodException e) {
                _failedApache = true;
            }
        }
        throw new IOException("Unpack200 not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String filename, int maxNumLines, boolean startAtBeginning) {
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        FileInputStream fis = null;
        BufferedReader in = null;
        try {
            fis = new FileInputStream(f);
            in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            ArrayList<String> lines = new ArrayList<String>(maxNumLines > 0 ? maxNumLines : 64);
            String line = null;
            while ((line = in.readLine()) != null) {
                lines.add(line);
                if (maxNumLines <= 0 || lines.size() < maxNumLines) continue;
                if (startAtBeginning) break;
                lines.remove(0);
            }
            StringBuilder buf = new StringBuilder(lines.size() * 80);
            for (int i = 0; i < lines.size(); ++i) {
                buf.append((String)lines.get(i)).append('\n');
            }
            String string = buf.toString();
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(String path, String root, OutputStream out) throws IOException {
        String rootDirStr;
        File rootDir = new File(root);
        while (path.startsWith("/") && path.length() > 0) {
            path = path.substring(1);
        }
        if (path.length() <= 0) {
            throw new FileNotFoundException("Not serving up the root dir");
        }
        File target = new File(rootDir, path);
        if (!target.exists()) {
            throw new FileNotFoundException("Requested file does not exist: " + path);
        }
        String targetStr = target.getCanonicalPath();
        if (!targetStr.startsWith(rootDirStr = rootDir.getCanonicalPath())) {
            throw new FileNotFoundException("Requested file is outside the root dir: " + path);
        }
        byte[] buf = new byte[4096];
        FileInputStream in = null;
        try {
            in = new FileInputStream(target);
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean copy(String source, String dest, boolean overwriteExisting) {
        return FileUtil.copy(source, dest, overwriteExisting, false);
    }

    public static boolean copy(String source, String dest, boolean overwriteExisting, boolean quiet) {
        File src = new File(source);
        File dst = new File(dest);
        return FileUtil.copy(src, dst, overwriteExisting, quiet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dst, boolean overwriteExisting, boolean quiet) {
        if (dst.exists() && dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        if (!src.exists()) {
            return false;
        }
        if (dst.exists() && !overwriteExisting) {
            return false;
        }
        byte[] buf = new byte[4096];
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            int read = 0;
            while ((read = ((InputStream)in).read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, read);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            if (!quiet) {
                ioe.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean rename(File from, File to) {
        if (!from.exists()) {
            return false;
        }
        boolean success = false;
        boolean isWindows = SystemVersion.isWindows();
        boolean exists = to.exists();
        if (!isWindows || !exists) {
            success = from.renameTo(to);
        }
        if (!success) {
            if (exists && to.delete()) {
                success = from.renameTo(to);
            }
            if (!success && (success = FileUtil.copy(from, to, true, true))) {
                from.delete();
            }
        }
        return success;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.err.println("Usage: delete path | copy source dest | rename from to | unzip path.zip");
        } else if ("delete".equals(args[0])) {
            boolean deleted = FileUtil.rmdir(args[1], false);
            if (!deleted) {
                System.err.println("Error deleting [" + args[1] + "]");
            }
        } else if ("copy".equals(args[0])) {
            boolean copied = FileUtil.copy(args[1], args[2], false);
            if (!copied) {
                System.err.println("Error copying [" + args[1] + "] to [" + args[2] + "]");
            }
        } else if ("unzip".equals(args[0])) {
            File f = new File(args[1]);
            File to = new File("tmp");
            to.mkdir();
            boolean copied = FileUtil.verifyZip(f);
            if (!copied) {
                System.err.println("Error verifying " + args[1]);
            }
            if (copied = FileUtil.extractZip(f, to)) {
                System.err.println("Unzipped [" + args[1] + "] to [" + to + "]");
            } else {
                System.err.println("Error unzipping [" + args[1] + "] to [" + to + "]");
            }
        } else if ("rename".equals(args[0])) {
            boolean success = FileUtil.rename(new File(args[1]), new File(args[2]));
            if (!success) {
                System.err.println("Error renaming [" + args[1] + "] to [" + args[2] + "]");
            }
        } else {
            System.err.println("Usage: delete path | copy source dest | rename from to | unzip path.zip");
        }
    }
}

